/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.data.ACell;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.InvalidDataException;

public abstract class ACodedOp<T extends ACell, C extends ACell, V extends ACell>
extends AOp<T> {
    protected final byte tag;
    protected final Ref<C> code;
    protected final Ref<V> value;

    @Override
    public abstract Context execute(Context var1);

    protected ACodedOp(byte tag, Ref<C> code, Ref<V> value) {
        this.tag = tag;
        this.code = code;
        this.value = value;
    }

    @Override
    public byte getTag() {
        return this.tag;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        int epos = pos;
        epos = this.code.encode(bs, epos);
        epos = this.value.encode(bs, epos);
        return epos;
    }

    @Override
    public int encodeAfterOpcode(byte[] bs, int pos) {
        throw new Error("Should be unreachable");
    }

    @Override
    public final int getRefCount() {
        return 2;
    }

    @Override
    public int estimatedEncodingSize() {
        return 1 + this.code.estimatedEncodingSize() + this.value.estimatedEncodingSize();
    }

    public Ref<?> getRef(int i) {
        switch (i) {
            case 0: {
                return this.code;
            }
            case 1: {
                return this.value;
            }
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public final AOp<T> updateRefs(IRefFunction func) {
        Ref nc = func.apply(this.code);
        Ref nv = func.apply(this.value);
        return this.rebuild(nc, nv);
    }

    protected abstract AOp<T> rebuild(Ref<C> var1, Ref<V> var2);

    @Override
    public void validateCell() throws InvalidDataException {
    }
}

