/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.Constants;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.ResultContext;
import convex.core.SourceCodes;
import convex.core.cpos.Block;
import convex.core.cpos.BlockResult;
import convex.core.cvm.AOp;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.Juice;
import convex.core.cvm.Keywords;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.RecordFormat;
import convex.core.cvm.Symbols;
import convex.core.cvm.TransactionContext;
import convex.core.cvm.impl.InvalidBlockException;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AIndex;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.impl.LongBlob;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Counters;
import convex.core.util.Economics;
import convex.core.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;

public class State
extends ARecordGeneric {
    public static final Index<AArrayBlob, AVector<ACell>> EMPTY_SCHEDULE = Index.none();
    public static final Index<AArrayBlob, PeerStatus> EMPTY_PEERS = Index.none();
    private static final Keyword[] STATE_KEYS = new Keyword[]{Keywords.ACCOUNTS, Keywords.PEERS, Keywords.GLOBALS, Keywords.SCHEDULE};
    private static final RecordFormat FORMAT = RecordFormat.of(STATE_KEYS);
    private static final long FIELD_COUNT = FORMAT.count();
    public static final AVector<Symbol> GLOBAL_SYMBOLS = Vectors.of(Symbols.TIMESTAMP, Symbols.FEES, Symbols.JUICE_PRICE, Symbols.MEMORY, Symbols.MEMORY_VALUE, Symbols.BLOCK, Symbols.PROTOCOL);
    public static final int GLOBAL_TIMESTAMP = 0;
    public static final int GLOBAL_FEES = 1;
    public static final int GLOBAL_JUICE_PRICE = 2;
    public static final int GLOBAL_MEMORY_MEM = 3;
    public static final int GLOBAL_MEMORY_CVX = 4;
    public static final int GLOBAL_BLOCK = 5;
    public static final int GLOBAL_PROTOCOL = 6;
    public static final State EMPTY = State.create(Vectors.empty(), EMPTY_PEERS, Constants.INITIAL_GLOBALS, EMPTY_SCHEDULE);

    private State(AVector<AccountStatus> accounts, Index<AArrayBlob, PeerStatus> peers, AVector<ACell> globals, Index<AArrayBlob, AVector<ACell>> schedule) {
        super((byte)-43, FORMAT, Vectors.of(accounts, peers, globals, schedule).toVector());
    }

    public State(AVector<ACell> values) {
        super((byte)-43, FORMAT, values.toVector());
    }

    static State create(AVector<ACell> values) {
        if (values.count() != FIELD_COUNT) {
            return null;
        }
        return new State(values);
    }

    @Override
    public ACell get(Keyword k) {
        if (Keywords.ACCOUNTS.equals(k)) {
            return this.getAccounts();
        }
        if (Keywords.PEERS.equals(k)) {
            return this.getPeers();
        }
        if (Keywords.GLOBALS.equals(k)) {
            return this.getGlobals();
        }
        if (Keywords.SCHEDULE.equals(k)) {
            return this.getSchedule();
        }
        return null;
    }

    public static State create(AVector<AccountStatus> accounts, Index<AArrayBlob, PeerStatus> peers, AVector<ACell> globals, Index<AArrayBlob, AVector<ACell>> schedule) {
        return new State(accounts, peers, globals, schedule);
    }

    @Override
    public int getEncodingLength() {
        return this.values.getEncodingLength();
    }

    @Override
    public int estimatedEncodingSize() {
        return this.values.estimatedEncodingSize();
    }

    public static State read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        State result = State.create(values);
        if (result == null) {
            throw new BadFormatException("Bad format for CVM global state");
        }
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    public AVector<AccountStatus> getAccounts() {
        return (AVector)this.values.get(0);
    }

    public Index<AArrayBlob, PeerStatus> getPeers() {
        return (Index)this.values.get(1);
    }

    public Long getBalance(Address address) {
        AccountStatus acc = this.getAccount(address);
        if (acc == null) {
            return null;
        }
        return acc.getBalance();
    }

    public State withBalance(Address address, long newBalance) {
        AccountStatus acc = this.getAccount(address);
        if (acc == null) {
            throw new Error("No account for " + String.valueOf(address));
        }
        acc = acc.withBalance(newBalance);
        return this.putAccount(address, acc);
    }

    public BlockResult applyBlock(SignedData<Block> signedBlock) {
        Block block = null;
        try {
            block = signedBlock.getValue();
            ++Counters.applyBlock;
            BlockResult maybeFailed = this.checkBlock(signedBlock);
            if (maybeFailed != null) {
                return maybeFailed;
            }
            State state = this.prepareBlock(block);
            TransactionContext tctx = TransactionContext.create(state);
            tctx.block = signedBlock;
            BlockResult blockResult = state.applyTransactions(block, tctx);
            return blockResult;
        }
        catch (Exception e) {
            return BlockResult.createInvalidBlock(this, block, Strings.create(e.getMessage()));
        }
    }

    public BlockResult checkBlock(SignedData<Block> signedBlock) {
        Block block = signedBlock.getValue();
        AccountKey peerKey = signedBlock.getAccountKey();
        PeerStatus ps = this.getPeers().get(peerKey);
        if (ps == null) {
            return BlockResult.createInvalidBlock(this, block, Strings.MISSING_PEER);
        }
        if (ps.getPeerStake() < 1000000000000L) {
            return BlockResult.createInvalidBlock(this, block, Strings.INSUFFICIENT_STAKE);
        }
        if (block.getTimeStamp() < ps.getTimestamp()) {
            return BlockResult.createInvalidBlock(this, block, Strings.MISORDERED_BLOCK);
        }
        if (block.getTimeStamp() < this.getTimestamp().longValue() - 900000L) {
            return BlockResult.createInvalidBlock(this, block, Strings.BACKDATED_BLOCK);
        }
        if (block.getTransactions().count() > 1024L) {
            return BlockResult.createInvalidBlock(this, block, Strings.ILLEGAL_BLOCK_SIZE);
        }
        return null;
    }

    private State prepareBlock(Block b) {
        State state = this;
        AVector<ACell> globals = state.getGlobals();
        long blockNum = this.getBlockNumber();
        state = state.withGlobals((AVector<ACell>)globals.assoc(5L, (ACell)CVMLong.create(blockNum + 1L)));
        state = state.applyTimeUpdate(b.getTimeStamp());
        state = state.applyScheduledTransactions();
        return state;
    }

    public State applyTimeUpdate(long newTimestamp) {
        State state = this;
        ASequence glbs = state.getGlobals();
        long oldTimestamp = ((CVMLong)((AVector)glbs).get(0)).longValue();
        if (newTimestamp <= oldTimestamp) {
            return this;
        }
        glbs = ((AVector)glbs).assoc(0L, (ACell)CVMLong.create(newTimestamp));
        long memAdditions = newTimestamp / 3600000L - oldTimestamp / 3600000L;
        if (memAdditions > 0L) {
            long mem = ((CVMLong)((AVector)glbs).get(3)).longValue();
            long add = memAdditions * 40000L;
            if (add > 0L) {
                long newMem = mem + add;
                glbs = ((AVector)glbs).assoc(3L, (ACell)CVMLong.create(newMem));
            } else {
                throw new Error("Bad memory additions?");
            }
        }
        state = state.withGlobals((AVector<ACell>)glbs);
        return state;
    }

    public State applyScheduledTransactions() {
        MapEntry<ABlob, AVector<ACell>> me;
        ABlob key;
        long time;
        long tcount = 0L;
        AIndex sched = this.getSchedule();
        CVMLong timestamp = this.getTimestamp();
        ArrayList al = null;
        while (tcount < 100L && !sched.isEmpty() && (time = (key = (ABlob)(me = sched.entryAt(0L)).getKey()).longValue()) <= timestamp.longValue()) {
            ASequence trans = (AVector)me.getValue();
            long numScheduled = trans.count();
            long take = Math.min(numScheduled, 100L - tcount);
            if (al == null) {
                al = new ArrayList();
            }
            for (long i = 0L; i < take; ++i) {
                al.add(((AVector)trans).get(i));
            }
            if (!(trans = ((AVector)trans).slice(take, numScheduled)).isEmpty()) continue;
            sched = sched.dissoc(key);
        }
        if (al == null) {
            return this;
        }
        State state = this.withSchedule((Index<ABlob, AVector<ACell>>)sched);
        int n = al.size();
        for (int i = 0; i < n; ++i) {
            AVector st = (AVector)al.get(i);
            Address origin = (Address)st.get(0);
            AOp op = (AOp)st.get(1);
            Context ctx = Context.create(state, origin, 10000000L);
            if ((ctx = ctx.run(op)).isExceptional()) continue;
            state = ctx.getState();
        }
        return state;
    }

    private BlockResult applyTransactions(Block block, TransactionContext tctx) throws InvalidBlockException {
        State state = this;
        int blockLength = block.length();
        Result[] results = new Result[blockLength];
        long fees = 0L;
        AVector<SignedData<ATransaction>> transactions = block.getTransactions();
        for (int i = 0; i < blockLength; ++i) {
            SignedData signed;
            tctx.tx = signed = (SignedData)transactions.get(i);
            tctx.txNumber = i;
            ResultContext rc = state.applyTransaction(signed, tctx);
            results[i] = Result.fromContext(CVMLong.create(i), rc);
            fees += rc.getJuiceFees();
            state = rc.context.getState();
        }
        state = State.distributeFees(state, tctx.getPeer(), fees, block);
        return BlockResult.create(state, results);
    }

    static State distributeFees(State state, AccountKey peer, long fees, Block block) {
        PeerStatus ps = state.getPeer(peer);
        AccountStatus rewardPool = state.getAccount(Address.ZERO);
        long poolBalance = rewardPool.getBalance();
        long timeStamp = block.getTimeStamp();
        long timeReward = 0L;
        if (ps != null) {
            long peerFees = fees / 2L;
            fees -= peerFees;
            long oldTimestamp = ps.getTimestamp();
            long elapsed = Math.max(0L, Math.min(timeStamp - oldTimestamp, 600000L));
            timeReward = Math.max(0L, Math.min(0L, elapsed));
            ps = ps.distributeBlockReward(state, peerFees + timeReward, timeStamp);
            state = state.withPeer(peer, ps);
        }
        if (fees > 0L) {
            state = state.putAccount(Address.ZERO, rewardPool.withBalance(poolBalance + fees - timeReward));
        }
        return state;
    }

    public ResultContext applyTransaction(SignedData<ATransaction> signedTx, TransactionContext tctx) throws InvalidBlockException {
        long expectedSequence;
        Address addr;
        ATransaction t = RT.ensureTransaction(signedTx.getValue());
        if (t == null) {
            throw new InvalidBlockException("Not a signed transaction: " + String.valueOf(signedTx.getHash()));
        }
        tctx.origin = addr = t.getOrigin();
        AccountStatus as = this.getAccount(addr);
        if (as == null) {
            ResultContext rc = ResultContext.error(this, ErrorCodes.NOBODY, "Transaction for non-existent Account: " + String.valueOf(addr));
            return rc.withSource(SourceCodes.CVM);
        }
        long sequence = t.getSequence();
        if (sequence != (expectedSequence = as.getSequence() + 1L)) {
            ResultContext rc = ResultContext.error(this, ErrorCodes.SEQUENCE, "Sequence = " + sequence + " but expected " + expectedSequence);
            return rc.withSource(SourceCodes.CVM);
        }
        AccountKey key = as.getAccountKey();
        if (key == null) {
            ResultContext rc = ResultContext.error(this, ErrorCodes.STATE, "Transaction for account that is an Actor: " + String.valueOf(addr));
            return rc.withSource(SourceCodes.CVM);
        }
        boolean sigValid = signedTx.checkSignature(key);
        if (!sigValid) {
            ResultContext rc = ResultContext.error(this, ErrorCodes.SIGNATURE, Strings.BAD_SIGNATURE);
            return rc.withSource(SourceCodes.CVM);
        }
        ResultContext ctx = this.applyTransaction(t, tctx);
        return ctx;
    }

    public ResultContext applyTransaction(ATransaction t, TransactionContext tctx) {
        ResultContext rc = this.createResultContext(t);
        Context ctx = this.prepareTransaction(rc, tctx);
        if (!ctx.isExceptional()) {
            State preparedState = ctx.getState();
            rc.context = ctx = t.apply(ctx);
            ctx = ctx.completeTransaction(preparedState, rc);
        } else {
            rc.source = SourceCodes.CVM;
        }
        return rc.withContext(ctx);
    }

    public ResultContext applyTransaction(ATransaction t) {
        return this.applyTransaction(t, TransactionContext.create(this));
    }

    private Context prepareTransaction(ResultContext rc, TransactionContext tctx) {
        long initialJuice;
        Address origin;
        ATransaction t = rc.tx;
        long juicePrice = rc.juicePrice;
        tctx.origin = origin = t.getOrigin();
        AccountStatus account = this.getAccount(origin);
        if (account == null) {
            return Context.create(this).withError(ErrorCodes.NOBODY);
        }
        long balance = account.getBalance();
        long juiceLimit = Juice.calcAvailable(balance, juicePrice);
        if ((juiceLimit = Math.min(10000000L, juiceLimit)) <= (initialJuice = 0L)) {
            return Context.create(this, origin).withJuiceError();
        }
        Context ctx = Context.create(this, origin, juiceLimit);
        ctx = ctx.withJuice(initialJuice);
        ctx = ctx.withTransactionContext(tctx);
        return ctx;
    }

    private ResultContext createResultContext(ATransaction t) {
        long juicePrice = this.getJuicePrice().longValue();
        ResultContext rc = new ResultContext(t, juicePrice);
        return rc;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public HashMap<AccountKey, Double> computeStakes() {
        HashMap<AccountKey, Double> hm = new HashMap<AccountKey, Double>(this.getPeers().size());
        long timeStamp = this.getTimestamp().longValue();
        Double totalStake = this.getPeers().reduceEntries((acc, e) -> {
            PeerStatus ps = (PeerStatus)e.getValue();
            double stake = ps.getTotalStakeShares();
            long peerTimestamp = ps.getTimestamp();
            double decay = Economics.stakeDecay(timeStamp, peerTimestamp);
            hm.put(RT.ensureAccountKey((ACell)e.getKey()), stake *= decay);
            return stake + acc;
        }, 0.0);
        hm.put(null, totalStake);
        return hm;
    }

    public State withAccounts(AVector<AccountStatus> newAccounts) {
        if (newAccounts == this.getAccounts()) {
            return this;
        }
        return State.create((AVector<ACell>)this.values.assoc(0L, (ACell)newAccounts));
    }

    public State putAccount(Address address, AccountStatus accountStatus) {
        long n;
        long ix = address.longValue();
        if (ix > (n = this.getAccounts().count())) {
            throw new IndexOutOfBoundsException("Trying to add an account beyond accounts array at position: " + ix);
        }
        AVector<AccountStatus> accounts = this.getAccounts();
        ASequence newAccounts = ix == n ? accounts.conj(accountStatus) : accounts.assoc(ix, (ACell)accountStatus);
        return this.withAccounts((AVector<AccountStatus>)newAccounts);
    }

    public AccountStatus getAccount(Address target) {
        long ix = target.longValue();
        return this.getAccount(ix);
    }

    public AccountStatus getAccount(long ix) {
        AVector<AccountStatus> accts = this.getAccounts();
        if (ix < 0L || ix >= accts.count()) {
            return null;
        }
        return accts.get(ix);
    }

    public AMap<Symbol, ACell> getEnvironment(Address addr) {
        AccountStatus as = this.getAccount(addr);
        if (as == null) {
            return null;
        }
        return as.getEnvironment();
    }

    public State withPeers(Index<AArrayBlob, PeerStatus> newPeers) {
        if (this.getPeers() == newPeers) {
            return this;
        }
        return State.create((AVector<ACell>)this.values.assoc(1L, (ACell)newPeers));
    }

    public State addActor() {
        AccountStatus as = AccountStatus.createActor();
        ASequence newAccounts = this.getAccounts().conj(as);
        return this.withAccounts((AVector<AccountStatus>)newAccounts);
    }

    public long computeTotalBalance() {
        long total = this.getAccounts().reduce((acc, as) -> acc + as.getBalance(), 0L);
        total += this.getPeers().reduceValues((acc, ps) -> acc + ps.getBalance(), 0L).longValue();
        total += this.getGlobalFees().longValue();
        return total += this.getGlobalMemoryValue().longValue();
    }

    public long computeSupply() {
        long supply = 1000000000000000000L;
        for (int i = 0; i < 8; ++i) {
            supply -= ((AccountStatus)this.getAccounts().get(i)).getBalance();
        }
        return supply;
    }

    public long computeTotalMemory() {
        long total = this.getAccounts().reduce((acc, as) -> acc + as.getMemory(), 0L);
        return total += this.getGlobalMemoryPool().longValue();
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
    }

    public CVMLong getTimestamp() {
        return (CVMLong)this.getGlobals().get(0);
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    public CVMLong getJuicePrice() {
        return (CVMLong)this.getGlobals().get(2);
    }

    public State scheduleOp(long time, Address address, AOp<?> op) {
        AVector v = Vectors.of(address, op);
        LongBlob key = LongBlob.create(time);
        AVector<ACell> list = this.getSchedule().get(key);
        list = list == null ? Vectors.of(v) : list.append(v);
        AIndex newSchedule = this.getSchedule().assoc(key, list);
        return this.withSchedule((Index<ABlob, AVector<ACell>>)newSchedule);
    }

    public Index<ABlob, AVector<ACell>> getSchedule() {
        return (Index)this.values.get(3);
    }

    public CVMLong getGlobalFees() {
        return (CVMLong)this.getGlobals().get(1);
    }

    public State withGlobalFees(CVMLong newFees) {
        return this.withGlobals((AVector<ACell>)this.getGlobals().assoc(1L, (ACell)newFees));
    }

    public PeerStatus getPeer(AccountKey peerAddress) {
        return this.getPeers().get(peerAddress);
    }

    public State withPeer(AccountKey peerKey, PeerStatus updatedPeer) {
        return this.withPeers((Index<AArrayBlob, PeerStatus>)this.getPeers().assoc(peerKey, updatedPeer));
    }

    public Address nextAddress() {
        return Address.create(this.getAccounts().count());
    }

    public ACell lookupCNS(String name) {
        return this.lookupCNS(Symbol.create(name));
    }

    public ACell lookupCNS(Symbol name) {
        Context ctx = Context.create(this);
        if ((ctx = ctx.lookupCNS(name)).isExceptional()) {
            return null;
        }
        return ctx.getResult();
    }

    public AVector<ACell> lookupCNSRecord(Symbol name) {
        Context ctx = Context.create(this);
        if ((ctx = ctx.lookupCNSRecord(name)).isExceptional()) {
            return null;
        }
        return RT.ensureVector(ctx.getResult());
    }

    public AVector<ACell> getGlobals() {
        return (AVector)this.values.get(2);
    }

    public State withTimestamp(long timestamp) {
        return this.withGlobals((AVector<ACell>)this.getGlobals().assoc(0L, (ACell)CVMLong.create(timestamp)));
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof State) {
            State as = (State)a;
            return this.equals(as);
        }
        return Cells.equalsGeneric(this, a);
    }

    public boolean equals(State a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Cells.equals(h, ha);
        }
        return this.values.equals(a.values);
    }

    public CVMLong getGlobalMemoryValue() {
        return (CVMLong)this.getGlobals().get(4);
    }

    public CVMLong getGlobalMemoryPool() {
        return (CVMLong)this.getGlobals().get(3);
    }

    public double getMemoryPrice() {
        long pool = this.getGlobalMemoryPool().longValue();
        long value = this.getGlobalMemoryValue().longValue();
        return (double)value / (double)pool;
    }

    private State withSchedule(Index<ABlob, AVector<ACell>> newSchedule) {
        if (this.getSchedule() == newSchedule) {
            return this;
        }
        return new State((AVector<ACell>)this.values.assoc(3L, (ACell)newSchedule));
    }

    private State withGlobals(AVector<ACell> newGlobals) {
        if (newGlobals == this.getGlobals()) {
            return this;
        }
        return new State((AVector<ACell>)this.values.assoc(2L, (ACell)newGlobals));
    }

    public State updateMemoryPool(long cvx, long mem) {
        ASequence r = this.getGlobals();
        r = ((AVector)r).assoc(4L, (ACell)CVMLong.create(cvx));
        r = ((AVector)r).assoc(3L, (ACell)CVMLong.create(mem));
        return this.withGlobals((AVector<ACell>)r);
    }

    public boolean hasAccount(Address address) {
        long av = address.longValue();
        return av >= 0L && av < this.getAccounts().count();
    }

    public static AVector<State> statesAsOfRange(AVector<State> states, CVMLong timestamp, long interval, int count) {
        ASequence v = Vectors.empty();
        for (int i = 0; i < count; ++i) {
            v = v.conj(State.stateAsOf(states, timestamp));
            timestamp = CVMLong.create(timestamp.longValue() + interval);
        }
        return v;
    }

    public static State stateAsOf(AVector<State> states, CVMLong timestamp) {
        return Utils.binarySearchLeftmost(states, State::getTimestamp, Comparator.comparingLong(CVMLong::longValue), timestamp);
    }

    @Override
    protected State withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return State.create(newValues);
    }

    public long getBlockNumber() {
        return RT.ensureLong((ACell)this.getGlobals().get(5)).longValue();
    }
}

