/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.Result;
import convex.core.cpos.Block;
import convex.core.cpos.BlockResult;
import convex.core.cvm.Peer;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ABlob;
import convex.core.data.AIndex;
import convex.core.data.AVector;
import convex.core.data.Hash;
import convex.core.data.Index;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;

public class PeerIndex {
    private long finalityPoint;
    private Index<Hash, AVector<CVMLong>> txLocations;
    private Index<Hash, CVMLong> blockLocations;

    public PeerIndex() {
        this(0L, Index.none(), Index.none());
    }

    public PeerIndex(long finalPoint, Index<Hash, AVector<CVMLong>> txLocs, Index<Hash, CVMLong> blockLocs) {
        this.finalityPoint = finalPoint;
        this.txLocations = txLocs;
        this.blockLocations = blockLocs;
    }

    public long getFinalityPoint() {
        return this.finalityPoint;
    }

    public PeerIndex update(Peer peer) {
        long pfp = peer.getFinalityPoint();
        if (pfp < this.finalityPoint) {
            return null;
        }
        if (pfp == this.finalityPoint) {
            return this;
        }
        PeerIndex result = this;
        for (long i = this.finalityPoint; i < pfp; ++i) {
            result = result.processBlock(peer, i);
        }
        return result;
    }

    private PeerIndex processBlock(Peer peer, long blockNum) {
        AIndex ntxLocs = this.txLocations;
        AIndex nBlockLocs = this.blockLocations;
        BlockResult br = peer.getBlockResult(blockNum);
        SignedData<Block> blockSD = peer.getPeerOrder().getBlock(blockNum);
        nBlockLocs = nBlockLocs.assoc(blockSD.getHash(), CVMLong.create(blockNum));
        AVector<SignedData<ATransaction>> txs = blockSD.getValue().getTransactions();
        AVector<Result> rs = br.getResults();
        long n = rs.count();
        long i = 0L;
        while (i < n) {
            SignedData<ATransaction> tx = txs.get(i);
            Hash txID = tx.getHash();
            ntxLocs = ntxLocs.assoc(txID, Vectors.createLongs(blockNum, i++));
        }
        return new PeerIndex(blockNum + 1L, (Index<Hash, AVector<CVMLong>>)ntxLocs, (Index<Hash, CVMLong>)nBlockLocs);
    }

    public Result getTransactionResult(Peer peer, ABlob txID) {
        AVector<CVMLong> loc = this.txLocations.get((Hash)txID);
        if (loc == null) {
            return null;
        }
        return peer.getBlockResult(((CVMLong)loc.get(0)).longValue()).getResult(((CVMLong)loc.get(1)).longValue());
    }

    public SignedData<ATransaction> getTransaction(Peer peer, Hash transactionID) {
        AVector<CVMLong> loc = this.txLocations.get(transactionID);
        if (loc == null) {
            return null;
        }
        return peer.getPeerOrder().getBlock(((CVMLong)loc.get(0)).longValue()).getValue().getTransactions().get(((CVMLong)loc.get(1)).longValue());
    }

    public AVector<CVMLong> getTransactionLocation(Hash transactionID) {
        return this.txLocations.get(transactionID);
    }

    public CVMLong getBlockIndex(Hash blockHash) {
        return this.blockLocations.get(blockHash);
    }
}

