/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.Coin;
import convex.core.ErrorCodes;
import convex.core.ResultContext;
import convex.core.SourceCodes;
import convex.core.cvm.AFn;
import convex.core.cvm.AOp;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Juice;
import convex.core.cvm.Keywords;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.State;
import convex.core.cvm.Symbols;
import convex.core.cvm.Syntax;
import convex.core.cvm.TransactionContext;
import convex.core.cvm.exception.AExceptional;
import convex.core.cvm.exception.AThrowable;
import convex.core.cvm.exception.ATrampoline;
import convex.core.cvm.exception.ErrorValue;
import convex.core.cvm.exception.Failure;
import convex.core.cvm.exception.HaltValue;
import convex.core.cvm.exception.RecurValue;
import convex.core.cvm.exception.ReducedValue;
import convex.core.cvm.exception.ReturnValue;
import convex.core.cvm.exception.RollbackValue;
import convex.core.cvm.exception.TailcallValue;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AList;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Hash;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.util.BlobBuilder;
import convex.core.init.Init;
import convex.core.lang.Compiler;
import convex.core.lang.Core;
import convex.core.lang.RT;
import convex.core.lang.impl.CoreFn;
import convex.core.util.Economics;
import convex.core.util.ErrorMessages;
import convex.core.util.Utils;

public class Context {
    private static final long INITIAL_JUICE = 0L;
    private static final AVector<AVector<ACell>> DEFAULT_LOG = null;
    private static int ZERO_DEPTH = 0;
    private static final AExceptional DEFAULT_EXCEPTION = null;
    private static final long ZERO_OFFER = 0L;
    public static final AVector<ACell> EMPTY_BINDINGS = Vectors.empty();
    private static final ACell NO_RESULT = null;
    private static final ACell NULL_SCOPE = null;
    private static final AExceptional NO_EXCEPTION = null;
    private static final CompilerState NO_COMPILER_STATE = null;
    private long juice;
    private long juiceLimit;
    private ACell result;
    private AExceptional exception;
    private int depth;
    private AVector<ACell> localBindings;
    private ChainState chainState;
    private AVector<AVector<ACell>> log;
    private CompilerState compilerState;

    protected Context(ChainState chainState, long juice, long juiceLimit, AVector<ACell> localBindings2, ACell result, int depth, AExceptional exception, AVector<AVector<ACell>> log, CompilerState comp) {
        this.chainState = chainState;
        this.juice = juice;
        this.juiceLimit = juiceLimit;
        this.localBindings = localBindings2;
        this.result = result;
        this.depth = depth;
        this.exception = exception;
        this.log = log;
        this.compilerState = comp;
    }

    private static <T extends ACell> Context create(ChainState cs, long juice, long juiceLimit, AVector<ACell> localBindings, ACell result, int depth, AVector<AVector<ACell>> log, CompilerState comp) {
        if (juice < 0L) {
            throw new IllegalArgumentException("Negative juice! " + juice);
        }
        Context ctx = new Context(cs, juice, juiceLimit, localBindings, result, depth, DEFAULT_EXCEPTION, log, comp);
        return ctx;
    }

    private static <T extends ACell> Context create(State state, TransactionContext tctx, long juice, long juiceLimit, AVector<ACell> localBindings, T result, int depth, Address origin, Address caller, Address address, long offer, AVector<AVector<ACell>> log, CompilerState comp) {
        ChainState chainState = ChainState.create(state, tctx, caller, address, offer, NULL_SCOPE);
        if (chainState == null) {
            throw new Error("Attempting to create context with invalid Address");
        }
        return Context.create(chainState, juice, juiceLimit, localBindings, result, depth, log, comp);
    }

    public static Context create(State state) {
        return Context.create(state, Address.ZERO);
    }

    public static Context create(State state, Address origin) {
        return Context.create(state, origin, 10000000L);
    }

    public static Context create(State state, Address origin, long juiceLimit) {
        if (origin == null) {
            throw new IllegalArgumentException("Null address!");
        }
        TransactionContext tctx = TransactionContext.create(state);
        tctx.origin = origin;
        AccountStatus as = state.getAccount(origin);
        if (as == null) {
            return Context.create(state).withError(ErrorCodes.NOBODY);
        }
        return Context.create(state, tctx, 0L, juiceLimit, EMPTY_BINDINGS, NO_RESULT, ZERO_DEPTH, origin, null, origin, 0L, DEFAULT_LOG, null);
    }

    public Context completeTransaction(State initialState, ResultContext rc) {
        long fees;
        Address address;
        AccountStatus account;
        long balance;
        long juicePrice;
        long executionJuice;
        State state = this.getState();
        rc.juiceUsed = executionJuice = this.juice;
        long trxJuice = Juice.priceTransaction(rc.tx);
        long totalJuice = executionJuice + trxJuice;
        long juiceFees = Juice.addMul(0L, totalJuice, juicePrice = rc.juicePrice);
        boolean juiceFailure = juiceFees > (balance = (account = state.getAccount(address = this.getAddress())).getBalance());
        boolean memoryFailure = false;
        long memorySpend = 0L;
        if (juiceFailure) {
            juiceFees = balance;
            state = initialState;
        } else if (!rc.context.isExceptional()) {
            long memUsed;
            rc.memUsed = memUsed = state.getMemorySize() - initialState.getMemorySize();
            long allowance = account.getMemory();
            if (memUsed > 0L) {
                long purchaseNeeded;
                long allowanceUsed = Math.min(allowance, memUsed);
                if (allowanceUsed > 0L) {
                    account = account.withMemory(allowance - allowanceUsed);
                }
                if ((purchaseNeeded = memUsed - allowanceUsed) > 0L) {
                    long poolBalance = state.getGlobalMemoryValue().longValue();
                    long poolAllowance = state.getGlobalMemoryPool().longValue();
                    memorySpend = Economics.swapPrice(purchaseNeeded, poolAllowance, poolBalance);
                    if (balance - juiceFees >= memorySpend) {
                        state = state.updateMemoryPool(poolBalance + memorySpend, poolAllowance - purchaseNeeded);
                    } else {
                        memorySpend = 0L;
                        state = initialState;
                        account = state.getAccount(address);
                        memoryFailure = true;
                    }
                }
            } else {
                long allowanceCredit = -memUsed;
                account = account.withMemory(allowance + allowanceCredit);
            }
        } else {
            AExceptional ex = rc.context.getExceptional();
            rc.source = ex.isCatchable() ? SourceCodes.CODE : SourceCodes.CVM;
        }
        rc.totalFees = fees = juiceFees + memorySpend;
        account = account.addBalanceAndSequence(-fees);
        state = state.putAccount(address, account);
        Context rctx = this.withState(state);
        if (juiceFailure) {
            rctx = rctx.withError(ErrorCodes.JUICE, "Insuffienct balance to cover juice fees of " + rc.getJuiceFees());
            rc.source = SourceCodes.CVM;
        } else if (memoryFailure) {
            rctx = rctx.withError(ErrorCodes.MEMORY, "Unable to allocate additional memory required for transaction (" + rc.memUsed + " bytes)");
            rc.source = SourceCodes.CVM;
        }
        return rctx;
    }

    public Context withState(State newState) {
        return this.withChainState(this.chainState.withState(newState));
    }

    public State getState() {
        return this.chainState.state;
    }

    public long getJuiceUsed() {
        return this.juice;
    }

    public long getJuiceAvailable() {
        return this.juiceLimit - this.juice;
    }

    public long getJuiceLimit() {
        return this.juiceLimit;
    }

    public long getOffer() {
        return this.chainState.getOffer();
    }

    public AHashMap<Symbol, ACell> getEnvironment() {
        return this.chainState.getEnvironment();
    }

    public CompilerState getCompilerState() {
        return this.compilerState;
    }

    public AHashMap<Symbol, AHashMap<ACell, ACell>> getMetadata() {
        return this.chainState.getMetadata();
    }

    public Context consumeJuice(long gulp) {
        if (gulp <= 0L) {
            throw new Error("Juice gulp must be positive!");
        }
        if (!this.checkJuice(gulp)) {
            return this.withJuiceError();
        }
        this.juice += gulp;
        return this;
    }

    public boolean checkJuice(long gulp) {
        long juiceUsed = this.juice + gulp;
        return juiceUsed >= 0L && juiceUsed <= this.juiceLimit;
    }

    public Context lookup(Symbol symbol) {
        Address address = this.getAddress();
        return this.lookupDynamic(address, symbol);
    }

    public Context lookupDynamic(Address address, Symbol symbol) {
        AccountStatus as = this.getAccountStatus(address);
        if (as == null) {
            return this.withError(ErrorCodes.NOBODY, "No account found for: " + String.valueOf(address));
        }
        MapEntry<Symbol, ACell> envEntry = this.lookupDynamicEntry(as, symbol);
        if (envEntry == null) {
            return this.withUndeclaredError(symbol);
        }
        Object result = envEntry.getValue();
        return this.withResult((ACell)result);
    }

    public AHashMap<ACell, ACell> lookupMeta(Symbol sym) {
        return this.lookupMeta(this.getAddress(), sym);
    }

    public AHashMap<ACell, ACell> lookupMeta(Address address, Symbol sym) {
        if (address == null) {
            address = this.getAddress();
        }
        for (int i = 0; i < 16; ++i) {
            AccountStatus as = this.getAccountStatus(address);
            if (as == null) {
                return null;
            }
            AHashMap<Symbol, ACell> env = as.getEnvironment();
            if (env != null && env.containsKey(sym)) {
                return as.getMetadata(sym);
            }
            if (Core.CORE_ADDRESS.equals(address)) break;
            address = this.getParentAddress(as);
            if (address != null) continue;
            return null;
        }
        return null;
    }

    public Address lookupDefiningAddress(Address address, Symbol sym) {
        Address addr = address == null ? this.getAddress() : address;
        for (int i = 0; i < 16 && addr != null; ++i) {
            AccountStatus as = this.getAccountStatus(addr);
            if (as == null) {
                return null;
            }
            MapEntry<Symbol, ACell> entry = as.getEnvironmentEntry(sym);
            if (entry != null) {
                return addr;
            }
            if (addr.equals(Core.CORE_ADDRESS)) break;
            addr = this.getParentAddress(as);
        }
        return null;
    }

    private Address getParentAddress(AccountStatus as) {
        Address ba = as.getParent();
        if (ba == null) {
            return Core.CORE_ADDRESS;
        }
        return ba;
    }

    public <T extends ACell> T lookupValue(String symName) {
        return (T)this.lookupValue(this.getAddress(), Symbol.create(symName));
    }

    public ACell lookupValue(Symbol sym) {
        return this.lookupValue(this.getAddress(), sym);
    }

    public ACell lookupValue(Address address, Symbol sym) {
        MapEntry<Symbol, ACell> entry = this.lookupDynamicEntry(address, sym);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public MapEntry<Symbol, ACell> lookupDynamicEntry(Address address, Symbol sym) {
        AccountStatus as;
        if (address == null) {
            address = this.getAddress();
        }
        if ((as = this.getAccountStatus(address)) == null) {
            return null;
        }
        return this.lookupDynamicEntry(as, sym);
    }

    private MapEntry<Symbol, ACell> lookupDynamicEntry(AccountStatus as, Symbol sym) {
        for (int i = 0; i < 16; ++i) {
            MapEntry<Symbol, ACell> result;
            if (as == null) {
                return Core.ENVIRONMENT.getEntry(sym);
            }
            AHashMap<Symbol, ACell> env = as.getEnvironment();
            if (env != null && (result = env.getEntry(sym)) != null) {
                return result;
            }
            Address parent = this.getParentAddress(as);
            as = this.getAccountStatus(parent);
        }
        return null;
    }

    public AccountStatus getAccountStatus() {
        Address a = this.getAddress();
        if (a == null) {
            return null;
        }
        return this.chainState.state.getAccount(a);
    }

    public Index<Address, ACell> getHoldings() {
        AccountStatus as = this.getAccountStatus(this.getAddress());
        if (as == null) {
            return null;
        }
        Index<Address, ACell> hodls = as.getHoldings();
        if (hodls == null) {
            hodls = AccountStatus.EMPTY_HOLDINGS;
        }
        return hodls;
    }

    public long getBalance() {
        return this.getBalance(this.getAddress());
    }

    public long getBalance(Address address) {
        AccountStatus as = this.getAccountStatus(address);
        if (as == null) {
            return 0L;
        }
        return as.getBalance();
    }

    public Address getCaller() {
        return this.chainState.caller;
    }

    public ACell getScope() {
        return this.chainState.scope;
    }

    public Address getAddress() {
        return this.chainState.address;
    }

    public <R extends ACell> R getResult() {
        if (this.exception != null) {
            String msg = "Can't get result with exceptional value: " + String.valueOf(this.exception);
            if (this.exception instanceof ErrorValue) {
                ErrorValue ev = (ErrorValue)this.exception;
                msg = msg + "\n" + String.valueOf(ev.getTrace());
            }
            throw new IllegalStateException(msg);
        }
        return (R)this.result;
    }

    public Object getValue() {
        if (this.exception != null) {
            return this.exception;
        }
        return this.result;
    }

    public AExceptional getExceptional() {
        if (this.exception == null) {
            throw new IllegalStateException("Can't get exceptional value for context with result: " + String.valueOf(this.exception));
        }
        return this.exception;
    }

    public Context withResult(ACell value) {
        this.result = value;
        this.exception = null;
        return this;
    }

    public Context withValue(Object value) {
        if (value instanceof AExceptional) {
            this.exception = (AExceptional)value;
            this.result = null;
        } else {
            this.result = (ACell)value;
            this.exception = null;
        }
        return this;
    }

    public Context withResult(long gulp, ACell value) {
        if (!this.checkJuice(gulp)) {
            return this.withJuiceError();
        }
        this.juice += gulp;
        return this.withResult(value);
    }

    public Context withJuiceError() {
        this.juice = this.juiceLimit;
        return this.withException(Failure.juice());
    }

    public Context withException(AExceptional exception) {
        this.exception = exception;
        this.result = null;
        return this;
    }

    public Context withException(long gulp, AExceptional value) {
        if (!this.checkJuice(gulp)) {
            return this.withJuiceError();
        }
        this.juice += gulp;
        return this.withException(value);
    }

    private Context withEnvironment(AHashMap<Symbol, ACell> newEnvironment) {
        ChainState cs = this.chainState.withEnvironment(newEnvironment);
        return this.withChainState(cs);
    }

    private Context withEnvironment(AHashMap<Symbol, ACell> newEnvironment, AHashMap<Symbol, AHashMap<ACell, ACell>> newMeta) {
        ChainState cs = this.chainState.withEnvironment(newEnvironment, newMeta);
        return this.withChainState(cs);
    }

    private Context withChainState(ChainState newChainState) {
        if (this.chainState == newChainState) {
            return this;
        }
        AccountStatus oldOrigin = this.chainState.getOriginAccount();
        this.chainState = newChainState;
        AccountStatus newOrigin = newChainState.getOriginAccount();
        if (oldOrigin == newOrigin) {
            return this;
        }
        long newBalance = newOrigin.getBalance();
        if (newBalance < oldOrigin.getBalance()) {
            this.reviseJuiceLimit(newBalance);
        }
        return this;
    }

    private void reviseJuiceLimit(long newBalance) {
        long juicePrice = this.chainState.state.getJuicePrice().longValue();
        this.juiceLimit = Math.min(this.juiceLimit, Juice.calcAvailable(newBalance, juicePrice));
    }

    public Context execute(AOp<?> op) {
        int savedDepth = this.getDepth();
        Context ctx = this.withDepth(savedDepth + 1);
        if (ctx.isExceptional()) {
            return ctx;
        }
        Context rctx = op.execute(ctx);
        rctx = rctx.withDepth(savedDepth);
        return rctx;
    }

    public Context run(AOp<?> op) {
        Context ctx = this.fork().exec(op);
        return this.handleStateResults(ctx, false);
    }

    public Context run(ACell code) {
        Context ctx = this.fork();
        ctx = ctx.eval(code);
        return this.handleStateResults(ctx, false);
    }

    public Context invoke(AFn<?> fn, ACell ... args) {
        Context ctx = fn.invoke(this, args);
        if (ctx.isExceptional()) {
            Object v = ctx.getExceptional();
            while (v instanceof ATrampoline) {
                ACell[] newArgs;
                ATrampoline rv;
                if (v instanceof RecurValue) {
                    if (fn == Core.RECUR) break;
                    rv = (RecurValue)v;
                    newArgs = rv.getValues();
                    ctx = ctx.withValue(null);
                    ctx = fn.invoke(ctx, newArgs);
                    v = ctx.getValue();
                    continue;
                }
                if (!(v instanceof TailcallValue)) continue;
                if (fn == Core.TAILCALL_STAR) break;
                rv = (TailcallValue)v;
                newArgs = rv.getValues();
                fn = ((TailcallValue)rv).getFunction();
                ctx = ctx.withValue(null);
                ctx = fn.invoke(ctx, newArgs);
                v = ctx.getValue();
            }
            if (v instanceof ReturnValue && fn != Core.RETURN) {
                Object val = ((ReturnValue)v).getValue();
                return ctx.withResult((ACell)val);
            }
            if (v instanceof AThrowable && fn instanceof CoreFn) {
                AThrowable ev = (AThrowable)v;
                ev.addTrace("In core function: " + String.valueOf(RT.str(fn)));
            }
        }
        return ctx;
    }

    public Context executeLocalBinding(ACell bindingForm, AOp<?> op) {
        Context ctx = this.execute(op);
        if (ctx.isExceptional()) {
            return ctx;
        }
        return ctx.updateBindings(bindingForm, ctx.getResult());
    }

    public Context updateBindings(ACell bindingForm, Object args) {
        Context ctx = this.withValue(null);
        if (bindingForm instanceof Symbol) {
            Symbol sym = (Symbol)bindingForm;
            if (sym.equals(Symbols.UNDERSCORE)) {
                return ctx;
            }
            return this.withLocalBindings((AVector<ACell>)this.localBindings.conj((ACell)args));
        }
        if (bindingForm instanceof AVector) {
            AVector v = (AVector)bindingForm;
            long vcount = v.count();
            Long argCount = RT.argumentCount(args);
            if (argCount == null) {
                return ctx.withError(ErrorCodes.CAST, "Trying to destructure an argument that is not a sequential collection");
            }
            boolean foundAmpersand = false;
            for (long i = 0L; i < vcount; ++i) {
                long argIndex;
                Object bf = v.get(i);
                if (Symbols.AMPERSAND.equals((ACell)bf)) {
                    if (foundAmpersand) {
                        return ctx.withCompileError("Can't bind two or more ampersands in a single binding vector");
                    }
                    long nLeft = vcount - i - 2L;
                    if (nLeft < 0L) {
                        return ctx.withCompileError("Can't bind ampersand at end of binding form");
                    }
                    long consumeCount = argCount - i - nLeft;
                    if (consumeCount < 0L) {
                        return ctx.withArityError("Insufficient arguments to allow variadic binding");
                    }
                    AVector rest = RT.vec(args, i, i + consumeCount);
                    if ((ctx = ctx.updateBindings((ACell)v.get(i + 1L), rest)).isExceptional()) {
                        return ctx;
                    }
                    foundAmpersand = true;
                    ++i;
                    continue;
                }
                long l = argIndex = foundAmpersand ? argCount - (vcount - i) : i;
                if (argIndex >= argCount) {
                    return ctx.withArityError("Insufficient arguments (" + argCount + ") for binding form: " + String.valueOf(bindingForm));
                }
                if (!(ctx = ctx.updateBindings((ACell)bf, RT.nth(args, argIndex))).isExceptional()) continue;
                return ctx;
            }
            if (!foundAmpersand && vcount != argCount) {
                return ctx.withArityError("Expected " + vcount + " arguments but got " + argCount + " for binding form: " + String.valueOf(bindingForm));
            }
        } else {
            return ctx.withCompileError("Don't understand binding form of type: " + String.valueOf(RT.getType(bindingForm)));
        }
        return ctx;
    }

    public boolean print(BlobBuilder bb, long limit) {
        bb.append("{");
        bb.append(":juice " + this.juice);
        bb.append(',');
        bb.append(":juice-limit " + this.juiceLimit);
        bb.append(',');
        bb.append(":result ");
        if (!RT.print(bb, this.result, limit)) {
            return false;
        }
        bb.append(',');
        bb.append(":state ");
        if (!this.getState().print(bb, limit)) {
            return false;
        }
        bb.append("}");
        return bb.check(limit);
    }

    public String toString() {
        BlobBuilder bb = new BlobBuilder();
        long LIMIT = 1000L;
        this.print(bb, LIMIT);
        return bb.toBlob().toCVMString(LIMIT).toString();
    }

    public AVector<ACell> getLocalBindings() {
        return this.localBindings;
    }

    public Context withLocalBindings(AVector<ACell> newBindings) {
        this.localBindings = newBindings;
        return this;
    }

    public AccountStatus getAccountStatus(Address address) {
        return this.getState().getAccount(address);
    }

    public int getDepth() {
        return this.depth;
    }

    public Address getOrigin() {
        return this.chainState.getOrigin();
    }

    public Context define(Symbol key, ACell value) {
        AHashMap<Symbol, ACell> env = this.getEnvironment();
        AMap newEnvironment = env.assoc(key, value);
        return this.withEnvironment((AHashMap<Symbol, ACell>)newEnvironment);
    }

    public Context defineWithSyntax(Syntax syn, ACell value) {
        Symbol key = (Symbol)syn.getValue();
        AHashMap<Symbol, ACell> env = this.getEnvironment();
        AMap newEnvironment = env.assoc(key, value);
        AMap newMeta = this.getMetadata().assoc(key, syn.getMeta());
        return this.withEnvironment((AHashMap<Symbol, ACell>)newEnvironment, (AHashMap<Symbol, AHashMap<ACell, ACell>>)newMeta);
    }

    public Context undefine(Symbol key) {
        AHashMap<Symbol, ACell> m = this.getEnvironment();
        AMap newEnvironment = m.dissoc(key);
        AMap newMeta = this.getMetadata().dissoc(key);
        return this.withEnvironment((AHashMap<Symbol, ACell>)newEnvironment, (AHashMap<Symbol, AHashMap<ACell, ACell>>)newMeta);
    }

    public Context expandCompile(ACell form) {
        int saveDepth = this.getDepth();
        Context rctx = this.withDepth(saveDepth + 1);
        if (rctx.isExceptional()) {
            return rctx;
        }
        rctx = Compiler.expandCompile(form, rctx);
        rctx = rctx.withDepth(saveDepth);
        return rctx;
    }

    public Context compile(ACell expandedForm) {
        AExceptional ex;
        int saveDepth = this.getDepth();
        Context rctx = this.withDepth(saveDepth + 1);
        if (rctx.isExceptional()) {
            return rctx;
        }
        CompilerState savedCompilerState = this.getCompilerState();
        if ((rctx = Compiler.compile(expandedForm, rctx)).isExceptional() && (ex = rctx.getExceptional()) instanceof ErrorValue) {
            ErrorValue ev = (ErrorValue)ex;
            String msg = "Compiling:" + String.valueOf(expandedForm);
            ev.addTrace(msg);
        }
        rctx = rctx.withDepth(saveDepth);
        rctx = rctx.withCompilerState(savedCompilerState);
        return rctx;
    }

    public Context eval(ACell form) {
        AOp op;
        Context ctx = this;
        if (form instanceof AOp) {
            op = (AOp)form;
        } else {
            if ((ctx = ctx.lookup(Symbols.STAR_LANG)).isExceptional()) {
                return ctx;
            }
            AFn cfn = RT.ensureFunction(ctx.getResult());
            if (cfn == null) {
                cfn = Core.COMPILE;
            }
            if ((ctx = ctx.invoke(cfn, form)).isExceptional()) {
                return ctx;
            }
            Object cop = ctx.getResult();
            if (!(cop instanceof AOp)) {
                return ctx.withCompileError("*lang* did not produce CVM op");
            }
            op = (AOp)cop;
            ctx = ctx.withResult(null);
        }
        return ctx.exec(op);
    }

    public <T extends ACell> Context exec(AOp<T> op) {
        AVector<ACell> savedBindings = this.getLocalBindings();
        Context ctx = this.withLocalBindings(Vectors.empty());
        ctx = ctx.execute(op);
        return ctx.withLocalBindings(savedBindings);
    }

    public Context evalAs(Address target, ACell form) {
        Address caller = this.getAddress();
        AccountStatus as = this.getAccountStatus(target);
        if (as == null) {
            return this.withError(ErrorMessages.nobody(target));
        }
        ACell controller = as.getController();
        boolean canControl = false;
        Context ctx = this;
        if (caller.equals(target)) {
            canControl = true;
        } else {
            if (controller == null) {
                return this.withError(ErrorCodes.TRUST, "Cannot control address with nil controller set: " + String.valueOf(target));
            }
            if (caller.equals(controller)) {
                canControl = true;
            } else {
                Address actorAddress = RT.callableAddress(controller);
                if (actorAddress == null) {
                    return ctx.withError(ErrorCodes.TRUST, "Cannot control address because controller is not a valid address or scoped actor");
                }
                AccountStatus actorAccount = this.getAccountStatus(actorAddress);
                if (actorAccount == null) {
                    return ctx.withError(ErrorCodes.TRUST, "Cannot control address because controller does not exist: " + String.valueOf(controller));
                }
                if ((ctx = ctx.actorCall(controller, 0L, Symbols.CHECK_TRUSTED_Q, caller, Keywords.CONTROL, target)).isExceptional()) {
                    return ctx.withError(ErrorCodes.TRUST, "Failure trying to obtain :control rights");
                }
                canControl = RT.bool(ctx.getResult());
            }
        }
        if (!canControl) {
            return ctx.withError(ErrorCodes.TRUST, "Cannot control address: " + String.valueOf(target));
        }
        Context exContext = Context.create(ctx.getState(), this.getTransactionContext(), ctx.juice, this.juiceLimit, EMPTY_BINDINGS, NO_RESULT, this.depth + 1, this.getOrigin(), caller, target, 0L, ctx.log, NO_COMPILER_STATE);
        Context rContext = exContext.eval(form);
        return this.handleStateResults(rContext, false);
    }

    public Context queryAs(Address address, ACell form) {
        State s = this.getState();
        ChainState cs = ChainState.create(s, this.chainState.txContext, this.getAddress(), address, 0L, NULL_SCOPE);
        if (cs == null) {
            return this.withError(ErrorCodes.NOBODY, "Address does not exist: " + String.valueOf(address));
        }
        Context ctx = Context.create(cs, this.juice, this.juiceLimit, EMPTY_BINDINGS, NO_RESULT, this.depth, this.log, NO_COMPILER_STATE);
        ctx = ctx.eval(form);
        return this.handleStateResults(ctx, true);
    }

    public Context compileAll(ASequence<ACell> forms) {
        Context rctx = Compiler.compileAll(forms, this);
        return rctx;
    }

    public Context withDepth(int newDepth) {
        if (newDepth == this.depth) {
            return this;
        }
        if (newDepth < 0 || newDepth > 256) {
            return this.withError(ErrorCodes.DEPTH, "Invalid depth: " + newDepth);
        }
        this.depth = newDepth;
        return this;
    }

    public Context withJuice(long newJuice) {
        this.juice = newJuice;
        return this;
    }

    public Context withJuiceLimit(long newJuiceLimit) {
        this.juiceLimit = newJuiceLimit;
        return this;
    }

    public Context withCompilerState(CompilerState comp) {
        this.compilerState = comp;
        return this;
    }

    public boolean isExceptional() {
        return this.exception != null;
    }

    public boolean isError() {
        return this.exception != null && this.exception instanceof ErrorValue;
    }

    public boolean isValidAccount(Address address) {
        if (address == null) {
            return false;
        }
        return this.getAccountStatus(address) != null;
    }

    public Context transfer(Address target, long amount) {
        Address source;
        long sourceIndex;
        if (amount < 0L) {
            return this.withError(ErrorCodes.ARGUMENT, "Can't transfer a negative amount");
        }
        if (amount > 1000000000000000000L) {
            return this.withError(ErrorCodes.ARGUMENT, "Can't transfer an amount beyond maximum limit");
        }
        ASequence accounts = this.getState().getAccounts();
        AccountStatus sourceAccount = ((AVector)accounts).get(sourceIndex = (source = this.getAddress()).longValue());
        long currentBalance = sourceAccount.getBalance();
        if (currentBalance < amount) {
            return this.withFundsError(ErrorMessages.insufficientFunds(source, amount));
        }
        long newSourceBalance = currentBalance - amount;
        AccountStatus newSourceAccount = sourceAccount.withBalance(newSourceBalance);
        accounts = ((AVector)accounts).assoc(sourceIndex, (ACell)newSourceAccount);
        long targetIndex = target.longValue();
        if (targetIndex >= accounts.count()) {
            return this.withError(ErrorCodes.NOBODY, "Target account for transfer " + String.valueOf(target) + " does not exist");
        }
        AccountStatus targetAccount = (AccountStatus)((AVector)accounts).get(targetIndex);
        if (targetAccount.isActor() && target.longValue() != 0L) {
            Context actx = this.fork();
            actx = this.actorCall((ACell)target, amount, Symbols.RECEIVE_COIN, source, CVMLong.create(amount), null);
            if (actx.isExceptional()) {
                return actx;
            }
            long sent = currentBalance - actx.getBalance(source);
            return actx.withResult(CVMLong.create(sent));
        }
        long oldTargetBalance = targetAccount.getBalance();
        long newTargetBalance = oldTargetBalance + amount;
        AccountStatus newTargetAccount = targetAccount.withBalance(newTargetBalance);
        accounts = ((AVector)accounts).assoc(targetIndex, (ACell)newTargetAccount);
        Context result = this.withChainState(this.chainState.withAccounts((AVector<AccountStatus>)accounts)).withResult(CVMLong.create(amount));
        return result;
    }

    public Context transferMemoryAllowance(Address target, CVMLong amountToSend) {
        Address source;
        long sourceIndex;
        long amount = amountToSend.longValue();
        if (amount < 0L) {
            return this.withError(ErrorCodes.ARGUMENT, "Can't transfer a negative allowance amount");
        }
        if (amount > 1000000000000000000L) {
            return this.withError(ErrorCodes.ARGUMENT, "Can't transfer an allowance amount beyond maximum limit");
        }
        ASequence accounts = this.getState().getAccounts();
        AccountStatus sourceAccount = ((AVector)accounts).get(sourceIndex = (source = this.getAddress()).longValue());
        long currentBalance = sourceAccount.getMemory();
        if (currentBalance < amount) {
            return this.withError(ErrorCodes.MEMORY, "Insufficient memory allowance for transfer");
        }
        long newSourceBalance = currentBalance - amount;
        AccountStatus newSourceAccount = sourceAccount.withMemory(newSourceBalance);
        accounts = ((AVector)accounts).assoc(sourceIndex, (ACell)newSourceAccount);
        long targetIndex = target.longValue();
        if (targetIndex >= accounts.count()) {
            return this.withError(ErrorCodes.NOBODY, "Cannot transfer memory allowance to non-existent account: " + String.valueOf(target));
        }
        AccountStatus targetAccount = (AccountStatus)((AVector)accounts).get(targetIndex);
        long newTargetBalance = targetAccount.getMemory() + amount;
        AccountStatus newTargetAccount = targetAccount.withMemory(newTargetBalance);
        accounts = ((AVector)accounts).assoc(targetIndex, (ACell)newTargetAccount);
        Context result = this.withChainState(this.chainState.withAccounts((AVector<AccountStatus>)accounts)).withResult(amountToSend);
        return result;
    }

    public Context setMemory(long allowance) {
        State state = this.getState();
        AVector<AccountStatus> accounts = state.getAccounts();
        if (allowance < 0L) {
            return this.withError(ErrorCodes.ARGUMENT, "Can't transfer a negative allowance amount");
        }
        Address source = this.getAddress();
        long sourceIndex = source.longValue();
        AccountStatus sourceAccount = accounts.get(sourceIndex);
        long current = sourceAccount.getMemory();
        long balance = sourceAccount.getBalance();
        long delta = allowance - current;
        if (delta == 0L) {
            return this.withResult(CVMLong.ZERO);
        }
        try {
            long poolAllowance = state.getGlobalMemoryPool().longValue();
            long poolBalance = state.getGlobalMemoryValue().longValue();
            long price = Economics.swapPrice(delta, poolAllowance, poolBalance);
            if (price > balance) {
                return this.withError(ErrorCodes.FUNDS, "Cannot afford allowance, would cost: " + price);
            }
            sourceAccount = sourceAccount.withBalances(balance - price, allowance);
            state = state.updateMemoryPool(poolBalance + price, poolAllowance - delta);
            ASequence newAccounts = accounts.assoc(sourceIndex, (ACell)sourceAccount);
            state = state.withAccounts((AVector<AccountStatus>)newAccounts);
            return this.withState(state).withResult(200L, CVMLong.create(price));
        }
        catch (IllegalArgumentException e) {
            return this.withError(ErrorCodes.FUNDS, "Cannot trade allowance: " + e.getMessage());
        }
    }

    public Context acceptFunds(long amount) {
        if (amount < 0L) {
            return this.withError(ErrorCodes.ARGUMENT, "Negative accept argument");
        }
        if (amount == 0L) {
            return this.withResult(200L, CVMLong.ZERO);
        }
        long offer = this.getOffer();
        if (amount > offer) {
            return this.withError(ErrorCodes.STATE, "Insufficient offered funds");
        }
        State state = this.getState();
        Address addr = this.getAddress();
        long balance = state.getBalance(addr);
        state = state.withBalance(addr, balance + amount);
        ChainState cs = this.chainState.withStateOffer(state, offer - amount);
        Context ctx = this.withChainState(cs);
        return ctx.withResult(200L, CVMLong.create(amount));
    }

    public Context actorCall(ACell target, long offer, String functionName, ACell ... args) {
        return this.actorCall(target, offer, Symbol.create(functionName), args);
    }

    public Context actorCall(ACell target, long offer, ACell functionName, ACell ... args) {
        Address targetAddress;
        State state = this.getState();
        Symbol sym = RT.ensureSymbol(functionName);
        Object scope = null;
        if (target instanceof Address) {
            targetAddress = (Address)target;
        } else {
            if (!(target instanceof AVector)) {
                return this.withCastError(target, "call target must be an Address or [Address *scope*] vector");
            }
            AVector v = (AVector)target;
            if (v.count() != 2L) {
                return this.withCastError(target, "call target vector must have length 2");
            }
            targetAddress = RT.ensureAddress((ACell)v.get(0));
            if (targetAddress == null) {
                return this.withCastError(target, "call target vector must start with an Address");
            }
            scope = v.get(1);
        }
        AccountStatus as = state.getAccount(targetAddress);
        if (as == null) {
            return this.withError(ErrorCodes.NOBODY, "Call target Account does not exist: " + String.valueOf(target));
        }
        if (offer > 0L) {
            Address senderAddress = this.getAddress();
            AccountStatus cas = state.getAccount(senderAddress);
            long balance = cas.getBalance();
            if (balance < offer) {
                return this.withFundsError("Insufficient funds for offer: " + offer + " trying to call Actor " + String.valueOf(target) + " function (" + String.valueOf(sym) + " ...)");
            }
            cas = cas.withBalance(balance - offer);
            state = state.putAccount(senderAddress, cas);
        } else if (offer < 0L) {
            return this.withError(ErrorCodes.ARGUMENT, "Cannot make negative offer in Actor call: " + offer);
        }
        AFn fn = as.getCallableFunction(sym);
        if (fn == null) {
            if (as.getEnvironmentEntry(sym) == null) {
                return this.withError(ErrorCodes.STATE, "Account " + String.valueOf(targetAddress) + " does not define Symbol: " + String.valueOf(sym));
            }
            return this.withError(ErrorCodes.STATE, "Value defined in account " + String.valueOf(targetAddress) + " is not a callable function: " + String.valueOf(sym));
        }
        Context exContext = this.forkActorCall(state, targetAddress, offer, (ACell)scope);
        Context rctx = exContext.invoke(fn, args);
        ErrorValue ev = rctx.getError();
        if (ev != null) {
            ev.addTrace("Calling Actor " + String.valueOf(target) + " with function (" + String.valueOf(sym) + " ...)");
        }
        return this.handleStateResults(rctx, false);
    }

    private Context forkActorCall(State state, Address target, long offer, ACell scope) {
        Context fctx = Context.create(state, this.getTransactionContext(), this.juice, this.juiceLimit, EMPTY_BINDINGS, NO_RESULT, this.depth + 1, this.getOrigin(), this.getAddress(), target, offer, this.log, NO_COMPILER_STATE);
        if (scope != null) {
            fctx.chainState = fctx.chainState.withScope(scope);
        }
        return fctx;
    }

    private TransactionContext getTransactionContext() {
        return this.chainState.getTransactionContext();
    }

    public Context handleStateResults(Context returnContext, boolean rollback) {
        State returnState;
        Object rv;
        if (returnContext.isExceptional()) {
            AExceptional ex = returnContext.getExceptional();
            if (ex instanceof RollbackValue) {
                rollback = true;
                rv = ((RollbackValue)ex).getValue();
            } else if (ex instanceof HaltValue) {
                rv = ((HaltValue)ex).getValue();
            } else if (ex instanceof ErrorValue) {
                rollback = true;
                rv = ex;
            } else if (ex instanceof ReturnValue) {
                rv = ((ReturnValue)ex).getValue();
            } else {
                rollback = true;
                if (ex instanceof Failure) {
                    rv = ex;
                } else {
                    if (ex instanceof ATrampoline) {
                        String string = "attempt to recur or tail call outside of a function body";
                    }
                    Object msg = ex instanceof ReducedValue ? "reduced used outside of a reduce operation" : "Unhandled Exception with Code:" + String.valueOf(ex.getCode());
                    rv = ErrorValue.create(ErrorCodes.EXCEPTION, (String)msg);
                }
            }
        } else {
            rv = returnContext.getResult();
        }
        Address address = this.getAddress();
        if (rollback) {
            returnState = this.getState();
        } else {
            returnState = returnContext.getState();
            this.log = returnContext.getLog();
            long refund = returnContext.getOffer();
            if (refund > 0L) {
                AccountStatus cas = returnState.getAccount(address);
                long balance = cas.getBalance();
                cas = cas.withBalance(balance + refund);
                returnState = returnState.putAccount(address, cas);
            }
        }
        Context result = this.withState(returnState);
        result.juice = returnContext.juice;
        result = this.withValue(rv);
        return result;
    }

    public Context deploy(ACell ... code) {
        int n = code.length;
        State initialState = this.getState();
        Address address = initialState.nextAddress();
        State stateSetup = initialState.addActor();
        Context ctx = Context.create(stateSetup, this.getTransactionContext(), this.juice, this.juiceLimit, EMPTY_BINDINGS, NO_RESULT, this.depth + 1, this.getOrigin(), this.getAddress(), address, 0L, this.log, NO_COMPILER_STATE);
        for (int i = 0; i < n && !(ctx = ctx.eval(code[i])).isExceptional(); ++i) {
        }
        Context result = this.handleStateResults(ctx, false);
        if (result.isExceptional()) {
            return result;
        }
        return result.withResult(1000L, address);
    }

    public Context withError(Keyword error) {
        return this.withError(ErrorValue.create(error));
    }

    public Context withError(Keyword errorCode, String message) {
        return this.withError(ErrorValue.create(errorCode, Strings.create(message)));
    }

    public Context withError(Keyword errorCode, AString message) {
        return this.withError(ErrorValue.create(errorCode, message));
    }

    public Context withError(Keyword errorCode, ACell rs) {
        return this.withError(ErrorValue.createRaw(errorCode, rs));
    }

    public Context withError(ErrorValue error) {
        error.addLog(this.log);
        error.setAddress(this.getAddress());
        return this.withException(error);
    }

    public Context withArityError(String message) {
        return this.withError(ErrorCodes.ARITY, message);
    }

    public Context withCompileError(String message) {
        return this.withError(ErrorCodes.COMPILE, message);
    }

    public Context withSyntaxError(String message) {
        return this.withError(ErrorCodes.SYNTAX, message);
    }

    public Context withUndeclaredError(Symbol sym) {
        return this.withError(ErrorCodes.UNDECLARED, sym.getName());
    }

    public Context withBoundsError(long index) {
        return this.withError(ErrorCodes.BOUNDS, "Index: " + index);
    }

    public Context withCastError(int argIndex, AType klass) {
        return this.withError(ErrorCodes.CAST, "Can't convert argument at position " + (argIndex + 1) + " to type " + String.valueOf(klass));
    }

    public Context withCastError(int argIndex, ACell[] args, AType klass) {
        return this.withError(ErrorCodes.CAST, "Can't convert argument at position " + (argIndex + 1) + " (with type " + String.valueOf(RT.getType(args[argIndex])) + ") to type " + String.valueOf(klass));
    }

    public Context withCastError(ACell a, AType klass) {
        return this.withError(ErrorCodes.CAST, "Can't convert value of type " + String.valueOf(RT.getType(a)) + " to type " + String.valueOf(klass));
    }

    public Context withCastError(AType klass) {
        return this.withError(ErrorCodes.CAST, "Can't convert value(s) to type " + String.valueOf(klass));
    }

    public Context withCastError(ACell a, String message) {
        return this.withError(ErrorCodes.CAST, message);
    }

    public ACell getErrorCode() {
        if (this.exception != null) {
            return this.exception.getCode();
        }
        return null;
    }

    public ErrorValue getError() {
        if (this.exception instanceof ErrorValue) {
            return (ErrorValue)this.exception;
        }
        return null;
    }

    public Context withAssertError(String message) {
        return this.withError(ErrorCodes.ASSERT, message);
    }

    public Context withFundsError(String message) {
        return this.withError(ErrorCodes.FUNDS, message);
    }

    public Context withArgumentError(String message) {
        return this.withError(ErrorCodes.ARGUMENT, message);
    }

    public CVMLong getTimeStamp() {
        return this.getState().getTimestamp();
    }

    public Context schedule(long time, AOp<?> op) {
        long juiceNeeded;
        long timestamp = this.getTimeStamp().longValue();
        if (timestamp < 0L) {
            return this.withError(ErrorCodes.STATE);
        }
        if (time < timestamp) {
            time = timestamp;
        }
        if (!this.checkJuice(juiceNeeded = (time - timestamp) / 360000L)) {
            return this.withJuiceError();
        }
        State s = this.getState().scheduleOp(time, this.getAddress(), op);
        Context ctx = this.withChainState(this.chainState.withState(s));
        return ctx.withResult(juiceNeeded, CVMLong.create(time));
    }

    public Context setDelegatedStake(AccountKey peerKey, long newStake) {
        return this.setDelegatedStake(peerKey, this.getAddress(), newStake);
    }

    public Context setDelegatedStake(AccountKey peerKey, Address staker, long newStake) {
        State s = this.getState();
        PeerStatus ps = s.getPeer(peerKey);
        if (ps == null) {
            return this.withError(ErrorCodes.STATE, "Peer does not exist for account key: " + String.valueOf(peerKey));
        }
        if (newStake < 0L) {
            return this.withArgumentError("Cannot set a negative stake");
        }
        if (newStake > 1000000000000000000L) {
            return this.withArgumentError("Target stake out of valid Amount range");
        }
        long balance = this.getBalance(staker);
        long currentStake = ps.getDelegatedStake(staker);
        long delta = newStake - currentStake;
        if (delta == 0L) {
            return this;
        }
        if (delta > balance) {
            return this.withFundsError("Insufficient balance (" + balance + ") to increase Delegated Stake to " + newStake);
        }
        PeerStatus updatedPeer = ps.withDelegatedStake(staker, newStake);
        s = s.withBalance(staker, balance - delta);
        s = s.withPeer(peerKey, updatedPeer);
        return this.withState(s).withResult(CVMLong.create(delta));
    }

    public Context setPeerStake(AccountKey peerKey, long newStake) {
        return this.setPeerStake(peerKey, this.getAddress(), newStake);
    }

    public Context setPeerStake(AccountKey peerKey, Address controller, long newStake) {
        State s = this.getState();
        PeerStatus ps = s.getPeer(peerKey);
        if (ps == null) {
            return this.withError(ErrorCodes.STATE, "Peer does not exist for account key: " + String.valueOf(peerKey));
        }
        if (newStake < 0L) {
            return this.withArgumentError("Cannot set a negative stake");
        }
        if (newStake > 1000000000000000000L) {
            return this.withArgumentError("Target stake out of valid Amount range");
        }
        if (!ps.getController().equals(controller)) {
            return this.withError(ErrorCodes.STATE, "Address " + String.valueOf(controller) + " is not the controller of this peer account");
        }
        long balance = this.getBalance(controller);
        long currentStake = ps.getPeerStake();
        long delta = newStake - currentStake;
        if (delta == 0L) {
            return this;
        }
        if (delta > balance) {
            return this.withFundsError("Insufficient balance (" + balance + ") to increase Peer Stake to " + newStake);
        }
        PeerStatus updatedPeer = ps.withPeerStake(newStake);
        s = s.withBalance(controller, balance - delta);
        s = s.withPeer(peerKey, updatedPeer);
        return this.withState(s).withResult(CVMLong.create(delta));
    }

    public Context createPeer(AccountKey accountKey, long initialStake) {
        State s = this.getState();
        PeerStatus ps = s.getPeer(accountKey);
        if (ps != null) {
            return this.withError(ErrorCodes.STATE, "Peer already exists for this account key: " + accountKey.toChecksumHex());
        }
        if (initialStake == 0L) {
            return this.withArgumentError("Cannot create a peer with zero stake");
        }
        if (!Coin.isValidAmount(initialStake)) {
            return this.withArgumentError("Target stake out of valid Amount range: " + initialStake);
        }
        Address myAddress = this.getAddress();
        long balance = this.getBalance(myAddress);
        if (initialStake > balance) {
            return this.withFundsError("Insufficient balance (" + balance + ") to assign an initial stake of " + initialStake);
        }
        PeerStatus newPeerStatus = PeerStatus.create(myAddress, initialStake);
        s = s.withBalance(myAddress, balance - initialStake);
        s = s.withPeer(accountKey, newPeerStatus);
        return this.withState(s);
    }

    public Context evictPeer(AccountKey peerKey) {
        Context ctx = this;
        Index<AArrayBlob, PeerStatus> peers = ctx.getState().getPeers();
        PeerStatus ps = peers.get(peerKey);
        if (ps == null) {
            return this;
        }
        Address controller = ps.getController();
        if (!Utils.equals(ctx.getAddress(), ps.getController()) && ps.getPeerStake() >= 1000000000000L) {
            return ctx.withError(ErrorCodes.STATE, "Peer has too much stake to be evicted");
        }
        if (peers.count() == 1L) {
            return ctx.withError(ErrorCodes.STATE, "Cannot evict last peer");
        }
        Index<Address, CVMLong> stakes = ps.getStakes();
        long ns = stakes.count();
        int i = 0;
        while ((long)i < ns) {
            MapEntry<Address, CVMLong> staked = stakes.entryAt(i);
            ctx = ctx.withJuiceLimit(this.getJuiceLimit() + 200L);
            ctx = ctx.consumeJuice(200L);
            Address stakedAddress = (Address)staked.getKey();
            if ((ctx = ctx.setDelegatedStake(peerKey, stakedAddress, 0L)).isExceptional()) {
                return ctx;
            }
            ++i;
        }
        if ((ctx = ctx.setPeerStake(peerKey, controller, 0L)).isExceptional()) {
            return ctx;
        }
        Object peerStake = ctx.getResult();
        State s = ctx.getState();
        ctx = ctx.withState(s.withPeers((Index<AArrayBlob, PeerStatus>)s.getPeers().dissoc((ABlobLike)peerKey)));
        return ctx.withResult((ACell)peerStake);
    }

    public Context setPeerData(AccountKey peerKey, AHashMap<ACell, ACell> data) {
        AHashMap<ACell, ACell> newMeta;
        PeerStatus updatedPeer;
        State s = this.getState();
        Address address = this.getAddress();
        AccountStatus as = this.getAccountStatus(address);
        AccountKey ak = as.getAccountKey();
        if (ak == null) {
            return this.withError(ErrorCodes.STATE, "The account signing this transaction must have a public key");
        }
        PeerStatus ps = s.getPeer(ak);
        if (ps == null) {
            return this.withError(ErrorCodes.STATE, "Peer does not exist for this account and account key: " + ak.toChecksumHex());
        }
        if (!ps.getController().equals(address)) {
            return this.withError(ErrorCodes.STATE, "Current address " + String.valueOf(address) + " is not the controller of this peer account");
        }
        Hash lastStateHash = s.getHash();
        if (lastStateHash.equals((s = s.withPeer(ak, updatedPeer = ps.withPeerData(newMeta = data))).getHash())) {
            return this;
        }
        return this.withState(s);
    }

    public Context setHolding(Address targetAddress, ACell value) {
        AccountStatus as = this.getAccountStatus();
        as = as.withHolding(targetAddress, value);
        return this.withAccountStatus(this.getAddress(), as);
    }

    public Context setController(ACell address) {
        AccountStatus as = this.getAccountStatus();
        as = as.withController(address);
        return this.withAccountStatus(this.getAddress(), as);
    }

    public Context setParent(Address address) {
        AccountStatus as = this.getAccountStatus();
        as = as.withParent(address);
        return this.withAccountStatus(this.getAddress(), as);
    }

    public Context setAccountKey(AccountKey publicKey) {
        AccountStatus as = this.getAccountStatus();
        as = as.withAccountKey(publicKey);
        return this.withAccountStatus(this.getAddress(), as);
    }

    protected Context withAccountStatus(Address target, AccountStatus accountStatus) {
        return this.withState(this.getState().putAccount(target, accountStatus));
    }

    public Context forkWithAddress(Address newAddress) {
        return Context.create(this.getState(), newAddress);
    }

    public Context fork() {
        return new Context(this.chainState, this.juice, this.juiceLimit, this.localBindings, this.result, this.depth, NO_EXCEPTION, this.log, this.compilerState);
    }

    public Context appendLog(AVector<ACell> values) {
        Address addr = this.getAddress();
        ACell scope = this.getScope();
        ASequence log = this.log;
        if (log == null) {
            log = Vectors.empty();
        }
        AVector<CVMLong> location = this.getLocation();
        AVector entry = Vectors.of(addr, scope, location, values);
        this.log = log = log.conj(entry);
        return this;
    }

    public AVector<AVector<ACell>> getLog() {
        if (this.log == null) {
            return Vectors.empty();
        }
        return this.log;
    }

    public Context lookupCNS(Symbol name) {
        Context ctx = this.fork();
        ctx = this.actorCall((ACell)Init.REGISTRY_ADDRESS, 0L, Symbols.RESOLVE, name);
        return ctx;
    }

    public Context lookupCNSRecord(Symbol name) {
        Context ctx = this.fork();
        ctx = this.actorCall((ACell)Init.REGISTRY_ADDRESS, 0L, Symbols.READ, name);
        return ctx;
    }

    public Context expand(ACell form) {
        return this.expand(Core.INITIAL_EXPANDER, form, Core.INITIAL_EXPANDER);
    }

    public Context expand(AFn<?> expander, ACell form, AFn<?> cont) {
        int savedDepth = this.getDepth();
        Context ctx = this.withDepth(savedDepth + 1);
        if (ctx.isExceptional()) {
            return ctx;
        }
        Context rctx = this.invoke(expander, form, cont);
        rctx = rctx.withDepth(savedDepth);
        return rctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AFn<ACell> lookupExpander(ACell form) {
        ACell v;
        AFn<ACell> expander;
        Address addr;
        Symbol sym;
        AHashMap<ACell, ACell> me = null;
        if (form instanceof Symbol) {
            sym = (Symbol)form;
            me = this.lookupMeta(sym);
            addr = null;
        } else {
            if (!(form instanceof AList)) return null;
            AList listForm = (AList)form;
            int n = listForm.size();
            if (n <= 1) {
                return null;
            }
            if (!Symbols.LOOKUP.equals((ACell)listForm.get(0))) {
                return null;
            }
            Object maybeSym = listForm.get(n - 1);
            if (!(maybeSym instanceof Symbol)) {
                return null;
            }
            sym = (Symbol)maybeSym;
            if (n == 2) {
                addr = null;
                me = this.lookupMeta(sym);
            } else {
                if (n != 3) return null;
                Object maybeAddress = listForm.get(1);
                if (maybeAddress instanceof Symbol) {
                    maybeAddress = this.lookupValue((Symbol)maybeAddress);
                }
                if (!(maybeAddress instanceof Address)) {
                    return null;
                }
                addr = (Address)maybeAddress;
                me = this.lookupMeta((Address)maybeAddress, sym);
            }
        }
        if (me == null) {
            return null;
        }
        Object expBool = me.get(Keywords.EXPANDER_META);
        if (!RT.bool(expBool) || (expander = RT.castFunction(v = this.lookupValue(addr, sym))) == null) return null;
        return expander;
    }

    public AccountKey getPeer() {
        return this.chainState.getPeer();
    }

    public AVector<ACell> lastLog() {
        AVector<AVector<ACell>> log = this.getLog();
        long n = log.count();
        if (n == 0L) {
            return null;
        }
        return log.get(n - 1L);
    }

    public Context withTransactionContext(TransactionContext tctx) {
        return this.withChainState(this.chainState.withTransactionContext(tctx));
    }

    public AVector<CVMLong> getLocation() {
        return this.chainState.txContext.getLocation();
    }

    public AccountKey getSigner() {
        SignedData<ATransaction> sd = this.chainState.getTransactionContext().tx;
        if (sd == null) {
            return null;
        }
        return sd.getAccountKey();
    }

    protected static final class ChainState {
        private final State state;
        private final TransactionContext txContext;
        private final Address caller;
        private final Address address;
        private final ACell scope;
        private final long offer;
        private final AccountStatus account;

        private ChainState(State state, TransactionContext transactionContext, Address caller, Address address, AccountStatus account, long offer, ACell scope) {
            this.state = state;
            this.txContext = transactionContext;
            this.caller = caller;
            this.address = address;
            this.account = account;
            this.offer = offer;
            this.scope = scope;
        }

        public static ChainState create(State state, TransactionContext tContext, Address caller, Address address, long offer, ACell scope) {
            AccountStatus as = state.getAccount(address);
            if (as == null) {
                return null;
            }
            return new ChainState(state, tContext, caller, address, as, offer, scope);
        }

        public ChainState withStateOffer(State newState, long newOffer) {
            if (this.state == newState && this.offer == newOffer) {
                return this;
            }
            return ChainState.create(newState, this.txContext, this.caller, this.address, newOffer, this.scope);
        }

        private ChainState withState(State newState) {
            if (this.state == newState) {
                return this;
            }
            return ChainState.create(newState, this.txContext, this.caller, this.address, this.offer, this.scope);
        }

        protected long getOffer() {
            return this.offer;
        }

        protected ACell getScope() {
            return this.scope;
        }

        private AHashMap<Symbol, ACell> getEnvironment() {
            return RT.ensureHashMap(this.account.getEnvironment());
        }

        private ChainState withEnvironment(AHashMap<Symbol, ACell> newEnvironment) {
            if (this.account.getEnvironment() == newEnvironment) {
                return this;
            }
            AccountStatus nas = this.account.withEnvironment(newEnvironment);
            State newState = this.state.putAccount(this.address, nas);
            return this.withState(newState);
        }

        public ChainState withEnvironment(AHashMap<Symbol, ACell> newEnvironment, AHashMap<Symbol, AHashMap<ACell, ACell>> newMeta) {
            if (this.account.getEnvironment() == newEnvironment && this.account.getMetadata() == newMeta) {
                return this;
            }
            AccountStatus nas = this.account.withEnvironment(newEnvironment).withMetadata(newMeta);
            State newState = this.state.putAccount(this.address, nas);
            return this.withState(newState);
        }

        private ChainState withAccounts(AVector<AccountStatus> newAccounts) {
            return this.withState(this.state.withAccounts(newAccounts));
        }

        public AHashMap<Symbol, AHashMap<ACell, ACell>> getMetadata() {
            return RT.ensureHashMap(this.account.getMetadata());
        }

        public ChainState withScope(ACell newScope) {
            if (this.scope == newScope) {
                return this;
            }
            return ChainState.create(this.state, this.txContext, this.caller, this.address, this.offer, newScope);
        }

        public AccountStatus getAccount() {
            return this.account;
        }

        public Address getOrigin() {
            return this.txContext.getOrigin();
        }

        public AccountStatus getOriginAccount() {
            Address o = this.getOrigin();
            if (this.address.equals(o)) {
                return this.account;
            }
            return this.state.getAccount(o);
        }

        public AccountKey getPeer() {
            return this.txContext.getPeer();
        }

        public ChainState withTransactionContext(TransactionContext tctx) {
            if (this.txContext == tctx) {
                return this;
            }
            return ChainState.create(this.state, tctx, this.caller, this.address, this.offer, this.scope);
        }

        public TransactionContext getTransactionContext() {
            return this.txContext;
        }
    }

    public static final class CompilerState {
        public static final CompilerState EMPTY = new CompilerState(Vectors.empty(), (AHashMap<Symbol, CVMLong>)Maps.empty());
        private AVector<Syntax> definitions;
        private AHashMap<Symbol, CVMLong> mappings;

        private CompilerState(AVector<Syntax> definitions, AHashMap<Symbol, CVMLong> mappings) {
            this.definitions = definitions;
            this.mappings = mappings;
        }

        public CompilerState define(Symbol sym, Syntax syn) {
            long position = this.definitions.count();
            ASequence newDefs = this.definitions.conj(syn);
            AMap newMaps = this.mappings.assoc(sym, CVMLong.create(position));
            return new CompilerState((AVector<Syntax>)newDefs, (AHashMap<Symbol, CVMLong>)newMaps);
        }

        public CVMLong getPosition(Symbol sym) {
            return (CVMLong)this.mappings.get(sym);
        }
    }
}

