/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.Coin;
import convex.core.cvm.AFn;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AHashMap;
import convex.core.data.AIndex;
import convex.core.data.ASequence;
import convex.core.data.ASet;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.Sets;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import java.util.Map;

public class AccountStatus
extends ARecordGeneric {
    private final long sequence;
    private final AccountKey publicKey;
    private final long balance;
    private final long memory;
    private Index<Address, ACell> holdings;
    private ACell controller;
    private AHashMap<Symbol, ACell> environment;
    private AHashMap<Symbol, AHashMap<ACell, ACell>> metadata;
    private final Address parent;
    public static final Keyword[] ACCOUNT_KEYS = new Keyword[]{Keywords.SEQUENCE, Keywords.KEY, Keywords.BALANCE, Keywords.ALLOWANCE, Keywords.HOLDINGS, Keywords.CONTROLLER, Keywords.ENVIRONMENT, Keywords.METADATA, Keywords.PARENT};
    protected static final Index<Address, ACell> EMPTY_HOLDINGS = Index.none();
    private static final RecordFormat FORMAT = RecordFormat.of(ACCOUNT_KEYS);
    private static final long IX_SEQUENCE = FORMAT.indexFor(Keywords.SEQUENCE);
    private static final long IX_KEY = FORMAT.indexFor(Keywords.KEY);
    private static final long IX_BALANCE = FORMAT.indexFor(Keywords.BALANCE);
    private static final long IX_ALLOWANCE = FORMAT.indexFor(Keywords.ALLOWANCE);
    private static final long IX_HOLDINGS = FORMAT.indexFor(Keywords.HOLDINGS);
    private static final long IX_CONTROLLER = FORMAT.indexFor(Keywords.CONTROLLER);
    private static final long IX_ENVIRONMENT = FORMAT.indexFor(Keywords.ENVIRONMENT);
    private static final long IX_METADATA = FORMAT.indexFor(Keywords.METADATA);
    private static final long IX_PARENT = FORMAT.indexFor(Keywords.PARENT);

    private AccountStatus(long sequence, AccountKey publicKey, long balance, long memory, Index<Address, ACell> holdings, ACell controller, AHashMap<Symbol, ACell> environment, AHashMap<Symbol, AHashMap<ACell, ACell>> metadata, Address parent) {
        super((byte)-40, FORMAT, Vectors.create(CVMLong.create(sequence), publicKey, CVMLong.create(balance), CVMLong.create(memory), holdings, controller, environment, metadata, parent));
        this.sequence = sequence;
        this.publicKey = publicKey;
        this.balance = balance;
        this.memory = memory;
        this.holdings = holdings;
        this.controller = controller;
        this.environment = environment;
        this.metadata = metadata;
        this.parent = parent;
    }

    private AccountStatus(AVector<ACell> values) {
        super((byte)-40, FORMAT, values);
        this.sequence = RT.ensureLong(values.get(IX_SEQUENCE)).longValue();
        this.publicKey = RT.ensureAccountKey(values.get(IX_KEY));
        this.balance = RT.ensureLong(values.get(IX_BALANCE)).longValue();
        this.memory = RT.ensureLong(values.get(IX_ALLOWANCE)).longValue();
        this.parent = RT.ensureAddress(values.get(IX_PARENT));
    }

    public static AccountStatus create(long sequence, long balance, AccountKey key) {
        if (sequence < 0L) {
            throw new IllegalArgumentException("negative sequence");
        }
        if (balance < 0L) {
            throw new IllegalArgumentException("negative balance");
        }
        return new AccountStatus(sequence, key, balance, 0L, null, null, null, null, null);
    }

    public static AccountStatus createUnsafe(long sequence, long balance, AccountKey key) {
        return new AccountStatus(sequence, key, balance, 0L, null, null, null, null, null);
    }

    public static AccountStatus createActor() {
        return new AccountStatus(0L, null, 0L, 0L, null, null, null, null, null);
    }

    public static AccountStatus create(long balance, AccountKey key) {
        return AccountStatus.create(0L, balance, key);
    }

    public static AccountStatus create() {
        return AccountStatus.create(0L, 0L, null);
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getBalance() {
        return this.balance;
    }

    public static AccountStatus read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        AccountStatus result = new AccountStatus(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return 30 + Format.estimateEncodingSize(this.environment) + Format.estimateEncodingSize(this.holdings) + Format.estimateEncodingSize(this.controller) + 33;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public boolean isActor() {
        return this.publicKey == null;
    }

    public AccountStatus withAccountKey(AccountKey newKey) {
        if (newKey == this.publicKey) {
            return this;
        }
        return new AccountStatus((AVector<ACell>)this.values.assoc(IX_KEY, (ACell)newKey));
    }

    public AccountStatus withBalance(long newBalance) {
        if (this.balance == newBalance) {
            return this;
        }
        return new AccountStatus((AVector<ACell>)this.values.assoc(IX_BALANCE, (ACell)CVMLong.create(newBalance)));
    }

    public AccountStatus withMemory(long newMemory) {
        if (this.memory == newMemory) {
            return this;
        }
        return new AccountStatus((AVector<ACell>)this.values.assoc(IX_ALLOWANCE, (ACell)CVMLong.create(newMemory)));
    }

    public AccountStatus withBalances(long newBalance, long newAllowance) {
        if (this.balance == newBalance && this.memory == newAllowance) {
            return this;
        }
        ASequence nv = this.values;
        nv = ((AVector)nv).assoc(IX_BALANCE, (ACell)CVMLong.create(newBalance));
        nv = ((AVector)nv).assoc(IX_ALLOWANCE, (ACell)CVMLong.create(newAllowance));
        return new AccountStatus((AVector<ACell>)nv);
    }

    private AccountStatus withHoldings(Index<Address, ACell> newHoldings) {
        if (this.getHoldings() == newHoldings) {
            return this;
        }
        return new AccountStatus((AVector<ACell>)this.values.assoc(IX_HOLDINGS, (ACell)newHoldings));
    }

    public AccountStatus withController(ACell newController) {
        if (this.getController() == newController) {
            return this;
        }
        return new AccountStatus((AVector<ACell>)this.values.assoc(IX_CONTROLLER, newController));
    }

    public AccountStatus withEnvironment(AHashMap<Symbol, ACell> newEnvironment) {
        if (this.getEnvironment() == newEnvironment) {
            return this;
        }
        return new AccountStatus((AVector<ACell>)this.values.assoc(IX_ENVIRONMENT, (ACell)newEnvironment));
    }

    public AccountStatus withMetadata(AHashMap<Symbol, AHashMap<ACell, ACell>> newMeta) {
        if (this.getMetadata() == newMeta) {
            return this;
        }
        return new AccountStatus((AVector<ACell>)this.values.assoc(IX_METADATA, (ACell)newMeta));
    }

    public AccountStatus withParent(Address newParent) {
        if (this.parent == newParent) {
            return this;
        }
        return new AccountStatus((AVector<ACell>)this.values.assoc(IX_PARENT, (ACell)newParent));
    }

    @Override
    public boolean equals(ACell o) {
        if (o instanceof AccountStatus) {
            AccountStatus as = (AccountStatus)o;
            return this.equals(as);
        }
        return Cells.equalsGeneric(this, o);
    }

    public boolean equals(AccountStatus a) {
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (this.balance != a.balance) {
            return false;
        }
        if (this.sequence != a.sequence) {
            return false;
        }
        if (this.memory != a.memory) {
            return false;
        }
        return Cells.equals(this.values, a.values);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.sequence < 0L) {
            throw new InvalidDataException("Neagitive sequence: " + this.sequence, this);
        }
        if (!Coin.isValidAmount(this.balance)) {
            throw new InvalidDataException("Illegal balance: " + this.balance, this);
        }
    }

    public <R extends ACell> R getEnvironmentValue(Symbol symbol) {
        AHashMap<Symbol, ACell> env = this.getEnvironment();
        if (env == null) {
            return null;
        }
        Object value = env.get(symbol);
        return (R)value;
    }

    public ACell getHolding(Address addr) {
        Index<Address, ACell> hodls = this.getHoldings();
        if (hodls == null) {
            return null;
        }
        return hodls.get(addr);
    }

    public AccountStatus withHolding(Address addr, ACell value) {
        AIndex hodls = this.getHoldings();
        if (hodls == null) {
            hodls = value == null ? null : Index.of((Object)addr, (Object)value);
        } else if (value == null) {
            if ((hodls = hodls.dissoc(addr)).isEmpty()) {
                hodls = null;
            }
        } else {
            hodls = hodls.assoc(addr, value);
        }
        return this.withHoldings((Index<Address, ACell>)hodls);
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.SEQUENCE.equals(key)) {
            return CVMLong.create(this.sequence);
        }
        if (Keywords.KEY.equals(key)) {
            return this.publicKey;
        }
        if (Keywords.BALANCE.equals(key)) {
            return CVMLong.create(this.balance);
        }
        if (Keywords.ALLOWANCE.equals(key)) {
            return CVMLong.create(this.memory);
        }
        if (Keywords.HOLDINGS.equals(key)) {
            return this.values.get(IX_HOLDINGS);
        }
        if (Keywords.CONTROLLER.equals(key)) {
            return this.getController();
        }
        if (Keywords.ENVIRONMENT.equals(key)) {
            return this.getEnvironment();
        }
        if (Keywords.METADATA.equals(key)) {
            return this.getMetadata();
        }
        if (Keywords.PARENT.equals(key)) {
            return this.parent;
        }
        return null;
    }

    public long getMemory() {
        return this.memory;
    }

    public long getMemoryUsage() {
        return this.getMemorySize();
    }

    public AccountStatus addBalanceAndSequence(long delta) {
        ASequence nv = this.values;
        nv = ((AVector)nv).assoc(IX_SEQUENCE, (ACell)CVMLong.create(this.sequence + 1L));
        nv = ((AVector)nv).assoc(IX_BALANCE, (ACell)CVMLong.create(this.balance + delta));
        return new AccountStatus((AVector<ACell>)nv);
    }

    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    public Address getParent() {
        return this.parent;
    }

    public Index<Address, ACell> getHoldings() {
        if (this.holdings == null) {
            this.holdings = RT.ensureIndex(this.values.get(IX_HOLDINGS));
        }
        if (this.holdings == null) {
            return EMPTY_HOLDINGS;
        }
        return this.holdings;
    }

    public ACell getController() {
        if (this.controller == null) {
            this.controller = this.values.get(IX_CONTROLLER);
        }
        return this.controller;
    }

    public AHashMap<Symbol, ACell> getEnvironment() {
        AHashMap result = this.environment;
        if (result == null) {
            this.environment = result = (AHashMap)this.values.get(IX_ENVIRONMENT);
        }
        return result;
    }

    public AHashMap<Symbol, AHashMap<ACell, ACell>> getMetadata() {
        AHashMap result = this.metadata;
        if (result == null) {
            this.metadata = result = (AHashMap)this.values.get(IX_METADATA);
        }
        return result;
    }

    public ASet<Symbol> getCallableFunctions() {
        ACollection results = Sets.empty();
        if (this.metadata == null) {
            return results;
        }
        for (Map.Entry me : this.metadata.entrySet()) {
            Symbol sym;
            Object callVal = ((AHashMap)me.getValue()).get(Keywords.CALLABLE_META);
            if (!RT.bool(callVal) || RT.ensureFunction(this.getEnvironmentValue(sym = (Symbol)me.getKey())) == null) continue;
            results = ((ASet)results).conj(sym);
        }
        return results;
    }

    public <R extends ACell> AFn<R> getCallableFunction(Symbol sym) {
        R exported = this.getEnvironmentValue(sym);
        AFn fn = RT.ensureFunction(exported);
        if (fn == null) {
            return null;
        }
        AHashMap md = (AHashMap)this.getMetadata().get(sym);
        if (RT.bool(md.get(Keywords.CALLABLE_META))) {
            return fn;
        }
        return null;
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new AccountStatus(newValues);
    }

    public AHashMap<ACell, ACell> getMetadata(Symbol sym) {
        AHashMap<Symbol, AHashMap<ACell, ACell>> meta = this.getMetadata();
        if (meta == null) {
            return Maps.empty();
        }
        return (AHashMap)meta.get(sym, (ACell)Maps.empty());
    }

    public MapEntry<Symbol, ACell> getEnvironmentEntry(Symbol sym) {
        AHashMap<Symbol, ACell> env = this.getEnvironment();
        if (env == null) {
            return null;
        }
        MapEntry<Symbol, ACell> entry = env.getEntry(sym);
        return entry;
    }
}

