/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.cvm.ACVMRecord;
import convex.core.cvm.RecordFormat;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.exceptions.InvalidDataException;

public abstract class ARecordGeneric
extends ACVMRecord {
    protected final AVector<ACell> values;
    protected final RecordFormat format;

    protected ARecordGeneric(byte tag, RecordFormat format, AVector<ACell> values) {
        super(tag, format.count());
        if (values.count() != format.count()) {
            throw new IllegalArgumentException("Wrong number of field values for record: " + values.count());
        }
        this.format = format;
        this.values = values;
    }

    @Override
    public MapEntry<Keyword, ACell> entryAt(long i) {
        if (i < 0L || i > this.values.count()) {
            throw new IndexOutOfBoundsException(i);
        }
        return MapEntry.create(this.format.getKey((int)i), this.values.get(i));
    }

    @Override
    public ACell get(Keyword key) {
        Long ix = this.format.indexFor(key);
        if (ix == null) {
            return null;
        }
        return this.values.get(ix);
    }

    @Override
    public final RecordFormat getFormat() {
        return this.format;
    }

    @Override
    public final int getRefCount() {
        return this.values.getRefCount();
    }

    @Override
    public int estimatedEncodingSize() {
        return this.values.estimatedEncodingSize();
    }

    @Override
    public final int encode(byte[] bs, int pos) {
        bs[pos++] = this.tag;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public final int encodeRaw(byte[] bs, int pos) {
        return this.values.encodeRaw(bs, pos);
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof ARecordGeneric) {
            return this.equals((ARecordGeneric)a);
        }
        return Cells.equalsGeneric(this, a);
    }

    protected boolean equals(ARecordGeneric a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a.getTag() != this.getTag()) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return h.equals(ha);
        }
        return this.values.equals(a.values);
    }

    @Override
    public final <R extends ACell> Ref<R> getRef(int index) {
        return this.values.getRef(index);
    }

    @Override
    public final ARecordGeneric updateRefs(IRefFunction func) {
        ACell newValues = this.values.updateRefs(func);
        if (newValues == this.values) {
            return this;
        }
        return this.withValues((AVector<ACell>)newValues);
    }

    @Override
    public AVector<ACell> values() {
        return this.values;
    }

    protected abstract ARecordGeneric withValues(AVector<ACell> var1);

    @Override
    protected void validateCell() throws InvalidDataException {
        Cells.validateCell(this.values);
    }

    @Override
    public void validateStructure() throws InvalidDataException {
        super.validateStructure();
        if (this.values.count() != this.format.count()) {
            throw new InvalidDataException("Expected " + this.format.count() + "Record values but was: " + this.values.count(), this);
        }
    }
}

