/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto.util;

import convex.core.crypto.util.Base58;
import convex.core.data.AString;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Strings;

public class Multikey {
    public static AString encodePublicKey(AccountKey ak) {
        byte[] bs = new byte[34];
        bs[0] = -19;
        bs[1] = 1;
        ak.getBytes(bs, 2);
        return Strings.create("z" + Base58.encode(bs));
    }

    public static AString encodeSecretKeey(Blob seed) {
        byte[] bs = new byte[34];
        bs[0] = -128;
        bs[1] = 38;
        seed.getBytes(bs, 2);
        return Strings.create("z" + Base58.encode(bs));
    }

    public static Blob decodeSecretKey(AString sk) {
        return Multikey.decodeSecretKey(sk.toString());
    }

    public static Blob decodeSecretKey(String sk) {
        if (sk.charAt(0) != 'z') {
            throw new IllegalArgumentException("Expected 'z' at start of multibase key");
        }
        byte[] bs = Base58.decode(sk.substring(1));
        if (bs.length != 34) {
            throw new IllegalArgumentException("Invalid Ed25519 secret key encoding length:" + bs.length);
        }
        if (bs[0] != -128 || bs[1] != 38) {
            throw new IllegalArgumentException("Invalid Ed25519 secret key header");
        }
        return Blob.wrap(bs, 2, 32);
    }

    public static AccountKey decodePublicKey(String pk) {
        if (pk.charAt(0) != 'z') {
            throw new IllegalArgumentException("Expected 'z' at start of multibase key");
        }
        byte[] bs = Base58.decode(pk.substring(1));
        if (bs.length != 34) {
            throw new IllegalArgumentException("Invalid Ed25519 public key encoding length:" + bs.length);
        }
        if (bs[0] != -19 || bs[1] != 1) {
            throw new IllegalArgumentException("Invalid Ed25519 public key header");
        }
        return AccountKey.wrap(bs, 2);
    }
}

