/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto.bc;

import convex.core.crypto.AProvider;
import convex.core.crypto.ASignature;
import convex.core.crypto.bc.BCKeyPair;
import convex.core.data.AArrayBlob;
import convex.core.data.AccountKey;
import convex.core.util.Utils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.rfc8032.Ed25519;

public class BCProvider
extends AProvider {
    public static long verificationCount = 0L;
    public static final BouncyCastleProvider BC = new BouncyCastleProvider();

    public BCProvider() {
        super("Convex-BC", "1.0", "BouncyCastle crypto integration for Convex");
    }

    @Override
    public boolean verify(ASignature signature, AArrayBlob message, AccountKey publicKey) {
        int mlength = Utils.checkedInt(message.count());
        byte[] sigBytes = signature.getBytes();
        boolean verified = Ed25519.verify((byte[])sigBytes, (int)0, (byte[])publicKey.getInternalArray(), (int)publicKey.getInternalOffset(), (byte[])message.getInternalArray(), (int)message.getInternalOffset(), (int)mlength);
        ++verificationCount;
        return verified;
    }

    @Override
    public BCKeyPair create(AArrayBlob seed) {
        return BCKeyPair.create(seed);
    }
}

