/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto.bc;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.SignedData;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.math.ec.rfc8032.Ed25519;

public class BCKeyPair
extends AKeyPair {
    private final AccountKey publicKey;
    private final Blob seed;
    protected final Ed25519PrivateKeyParameters priv;
    public static long signatureCount;

    private BCKeyPair(AccountKey pk, AArrayBlob seed, Ed25519PrivateKeyParameters priv) {
        this.publicKey = pk;
        this.seed = seed.toFlatBlob();
        this.priv = priv;
    }

    public static BCKeyPair create(AArrayBlob seed) {
        long n = seed.count();
        if (seed.count() != 32L) {
            throw new IllegalArgumentException("32 bytes private key material expected as seed but got: " + n);
        }
        Ed25519PrivateKeyParameters priv = new Ed25519PrivateKeyParameters(Blobs.ensureZeroBasedArray(seed), 0);
        byte[] publicBytes = priv.generatePublicKey().getEncoded();
        AccountKey publicKey = AccountKey.wrap(publicBytes);
        return new BCKeyPair(publicKey, seed, priv);
    }

    @Override
    public Blob getSeed() {
        return this.seed;
    }

    @Override
    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    @Override
    public <R extends ACell> SignedData<R> signData(R value) {
        return SignedData.sign(this, value);
    }

    @Override
    public ASignature sign(AArrayBlob hash) {
        byte[] sigBytes = new byte[64];
        Ed25519.sign((byte[])this.seed.getInternalArray(), (int)this.seed.getInternalOffset(), (byte[])hash.getInternalArray(), (int)hash.getInternalOffset(), (int)((int)hash.count()), (byte[])sigBytes, (int)0);
        ++signatureCount;
        return Ed25519Signature.wrap(sigBytes);
    }

    @Override
    public boolean equals(AKeyPair kp) {
        if (!(kp instanceof BCKeyPair)) {
            return false;
        }
        return this.equals((BCKeyPair)kp);
    }

    public boolean equals(BCKeyPair other) {
        if (!this.seed.equals(other.seed)) {
            return false;
        }
        return this.publicKey.equals(other.publicKey);
    }
}

