/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.Providers;
import convex.core.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PFXTools {
    public static final String KEYSTORE_TYPE = "PKCS12";

    public static KeyStore createStore(File keyFile, char[] storePassword) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
        Providers.init();
        ks.load(null, storePassword);
        ks = PFXTools.saveStore(ks, keyFile, storePassword);
        return ks;
    }

    public static KeyStore loadStore(File keyFile, char[] storePassword) throws IOException, GeneralSecurityException {
        Providers.init();
        if (!keyFile.exists()) {
            throw new FileNotFoundException();
        }
        KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
        try (FileInputStream fis = new FileInputStream(keyFile);){
            ks.load(fis, storePassword);
        }
        return ks;
    }

    public static KeyStore saveStore(KeyStore ks, File keyFile, char[] storePassword) throws GeneralSecurityException, IOException {
        FileUtils.ensureFilePath(keyFile);
        try (FileOutputStream fos = new FileOutputStream(keyFile);){
            ks.store(fos, storePassword);
        }
        return ks;
    }

    public static AKeyPair getKeyPair(KeyStore ks, String alias, char[] keyPassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        Key sk = ks.getKey(alias, keyPassword);
        return AKeyPair.create(sk.getEncoded());
    }

    public static KeyStore setKeyPair(KeyStore ks, AKeyPair kp, char[] keyPassword) throws IOException, GeneralSecurityException {
        return PFXTools.setKeyPair(ks, kp.getAccountKey().toHexString(), kp, keyPassword);
    }

    public static KeyStore setKeyPair(KeyStore ks, String alias, AKeyPair kp, char[] keyPassword) throws IOException, GeneralSecurityException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("Password is mandatory for private key");
        }
        byte[] bs = kp.getSeed().getBytes();
        SecretKeySpec secretKeySeed = new SecretKeySpec(bs, "Ed25519");
        KeyStore.SecretKeyEntry keyEntry = new KeyStore.SecretKeyEntry(secretKeySeed);
        byte[] salt = new byte[20];
        KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(keyPassword, "PBEWithHmacSHA512AndAES_128", new PBEParameterSpec(salt, 100000));
        ks.setEntry(alias, keyEntry, protection);
        return ks;
    }
}

