/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.Providers;
import convex.core.exceptions.BadFormatException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PEMTools {
    private static final int PBE_ITERATIONS = 65536;

    public static String encryptPrivateKeyToPEM(AKeyPair keyPair, char[] password) throws GeneralSecurityException {
        PrivateKey privateKey = keyPair.getPrivate();
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter writer = new JcaPEMWriter((Writer)stringWriter);
        try {
            JcePKCSPBEOutputEncryptorBuilder builder = new JcePKCSPBEOutputEncryptorBuilder(PKCS8Generator.PBE_SHA1_RC2_128);
            builder.setIterationCount(65536);
            OutputEncryptor encryptor = builder.build(password);
            JcaPKCS8Generator generator = new JcaPKCS8Generator(privateKey, encryptor);
            writer.writeObject((PemObjectGenerator)generator);
            writer.close();
        }
        catch (IOException | OperatorCreationException e) {
            throw new GeneralSecurityException("cannot encrypt private key to PEM: " + String.valueOf(e));
        }
        return stringWriter.toString();
    }

    public static AKeyPair decryptPrivateKeyFromPEM(String pemText, char[] password) throws BadFormatException {
        PemObject pemObject = PEMTools.readPEMObject(pemText, "ENCRYPTED PRIVATE KEY");
        if (pemObject == null) {
            throw new Error("no encrypted private key found in pem text");
        }
        try {
            PKCS8EncryptedPrivateKeyInfo encryptedInfo = new PKCS8EncryptedPrivateKeyInfo(pemObject.getContent());
            JcePKCSPBEInputDecryptorProviderBuilder inputBuilder = new JcePKCSPBEInputDecryptorProviderBuilder();
            InputDecryptorProvider decryptor = inputBuilder.build(password);
            PrivateKeyInfo privateKeyInfo = encryptedInfo.decryptPrivateKeyInfo(decryptor);
            byte[] data = privateKeyInfo.getEncoded();
            AKeyPair kp = AKeyPair.create(data);
            return kp;
        }
        catch (IOException | PKCSException e) {
            throw new BadFormatException("cannot decrypt password from PEM ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PemObject readPEMObject(String pemText, String type) throws BadFormatException {
        StringReader stringReader = new StringReader(pemText);
        try (PEMParser pemParser = new PEMParser((Reader)stringReader);){
            PemObject pemObject = pemParser.readPemObject();
            while (pemObject != null) {
                if (pemObject.getType().equals(type)) {
                    PemObject pemObject2 = pemObject;
                    return pemObject2;
                }
                pemObject = pemParser.readPemObject();
            }
            PemObject pemObject3 = null;
            return pemObject3;
        }
        catch (IOException e) {
            throw new BadFormatException("cannot read PEM", e);
        }
    }

    static {
        Providers.init();
    }
}

