/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.data.AArrayBlob;

public class IdenticonBuilder {
    public static final int SIZE = 7;

    public static int[] createColours(AArrayBlob data) {
        int[] cols = new int[4];
        long n = data.count();
        if (n == 0L) {
            return cols;
        }
        for (int i = 0; i < 4; ++i) {
            int r = 0xFF & data.byteAt(Math.floorMod(n - 12L + (long)(i * 3) + 0L, n));
            int g = 0xFF & data.byteAt(Math.floorMod(n - 12L + (long)(i * 3) + 1L, n));
            int b = 0xFF & data.byteAt(Math.floorMod(n - 12L + (long)(i * 3) + 2L, n));
            int col = 0x800000 ^ (r << 16 | g << 8 | b);
            cols[i] = 0xFF000000 | col;
        }
        return cols;
    }

    public static int[] build(AArrayBlob data) {
        int[] result = new int[49];
        int[] cols = IdenticonBuilder.createColours(data);
        int width = 4;
        for (int y = 0; y < 7; ++y) {
            int i;
            int byteIndex;
            for (int x = 0; x <= width && (long)(byteIndex = (i = x + y * width) / 4) < data.count(); ++x) {
                int rgb;
                byte b = data.byteAt(byteIndex);
                int bits = 3 & b >> 2 * (3 - i % 4);
                result[x + y * 7] = rgb = cols[bits];
                result[7 - x - 1 + y * 7] = rgb;
            }
        }
        return result;
    }
}

