/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cpos;

import convex.core.cpos.Belief;
import convex.core.cpos.Block;
import convex.core.cpos.BlockResult;
import convex.core.cpos.Order;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.State;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Index;
import convex.core.data.MapEntry;
import convex.core.data.SignedData;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Counters;
import convex.core.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;

public class BeliefMerge {
    private final Belief initialBelief;
    private final AccountKey publicKey;
    private final State state;
    private final AKeyPair keyPair;
    private final long timestamp;
    private final Index<AArrayBlob, PeerStatus> peers;

    private BeliefMerge(Belief belief, AKeyPair peerKeyPair, long mergeTimestamp, State consensusState) {
        this.initialBelief = belief;
        this.state = consensusState;
        this.publicKey = peerKeyPair.getAccountKey();
        this.keyPair = peerKeyPair;
        this.timestamp = mergeTimestamp;
        this.peers = this.state.getPeers();
    }

    public static BeliefMerge create(Belief belief, AKeyPair kp, long timestamp, State s) {
        return new BeliefMerge(belief, kp, timestamp, s);
    }

    public Belief merge(Belief ... beliefs) throws InvalidDataException {
        ++Counters.beliefMerge;
        Index<AccountKey, SignedData<Order>> accOrders = this.accumulateOrders(beliefs);
        Index<AccountKey, SignedData<Order>> resultOrders = this.vote(accOrders);
        if (resultOrders == null) {
            return this.initialBelief;
        }
        if (this.initialBelief.getOrders() == resultOrders) {
            return this.initialBelief;
        }
        Belief result = Belief.create(resultOrders);
        return result;
    }

    public Belief mergeOrders(Belief b) {
        Index<AccountKey, SignedData<Order>> orders = this.initialBelief.getOrders();
        Index<AccountKey, SignedData<Order>> newOrders = this.accumulateOrders(orders, b);
        return this.initialBelief.withOrders(newOrders);
    }

    Index<AccountKey, SignedData<Order>> accumulateOrders(Index<AccountKey, SignedData<Order>> orders, Belief belief) {
        AMap result = orders;
        Index<AccountKey, SignedData<Order>> bOrders = belief.getOrders();
        long bcount = bOrders.count();
        for (long i = 0L; i < bcount; ++i) {
            Order ac;
            boolean shouldReplace;
            Order bc;
            SignedData b;
            MapEntry<AccountKey, SignedData<Order>> be = bOrders.entryAt(i);
            ABlob key = (ABlob)be.getKey();
            if (!this.isValidPeer(key) || (b = (SignedData)be.getValue()) == null || (bc = (Order)b.getValue()).getTimestamp() > this.getTimestamp()) continue;
            SignedData<Order> a = ((Index)result).get((AccountKey)key);
            if (a == null) {
                result = ((Index)result).assocEntry((MapEntry)be);
                continue;
            }
            if (a.equals(b) || !(shouldReplace = BeliefMerge.compareOrders(ac = a.getValue(), bc))) continue;
            result = ((Index)result).assocEntry((MapEntry)be);
        }
        return result;
    }

    private boolean isValidPeer(ABlob key) {
        PeerStatus ps = this.peers.get((AArrayBlob)key);
        if (ps == null) {
            return false;
        }
        return ps.getPeerStake() >= 1000000000000L;
    }

    Index<AccountKey, SignedData<Order>> vote(Index<AccountKey, SignedData<Order>> accOrders) {
        double consideredStake;
        AccountKey myAddress = this.getAccountKey();
        Order myOrder = this.getMyOrder();
        assert (myOrder != null);
        AMap filteredOrders = accOrders;
        filteredOrders = accOrders.filterValues(signedOrder -> {
            Order otherOrder = (Order)signedOrder.getValue();
            return myOrder.checkConsistent(otherOrder);
        });
        long consensusPoint = myOrder.getConsensusPoint();
        HashMap<AccountKey, Double> weightedStakes = this.state.computeStakes();
        double totalStake = weightedStakes.get(null);
        HashMap<Order, Double> stakedOrders = new HashMap<Order, Double>(this.peers.size());
        AVector<SignedData<Block>> winningBlocks = this.computeWinningOrder(stakedOrders, consensusPoint, consideredStake = BeliefMerge.prepareStakedOrders(filteredOrders, weightedStakes, stakedOrders));
        if (winningBlocks == null) {
            return null;
        }
        winningBlocks = this.filterBlocks(winningBlocks, consensusPoint);
        Order winningOrder = myOrder.withBlocks(winningBlocks);
        Order consensusOrder = this.updateConsensus(winningOrder, stakedOrders, totalStake);
        AMap resultOrders = filteredOrders;
        if (!consensusOrder.consensusEquals(myOrder)) {
            boolean shouldReplace;
            long match = consensusOrder.getBlocks().commonPrefixLength(myOrder.getBlocks());
            boolean bl = shouldReplace = match >= myOrder.getProposalPoint();
            if (!shouldReplace) {
                long keepProposalTime = 100L;
                if (this.getTimestamp() > myOrder.getTimestamp() + keepProposalTime) {
                    shouldReplace = true;
                }
            }
            if (shouldReplace) {
                long ts = this.getTimestamp();
                Order myNewOrder = consensusOrder.withTimestamp(ts);
                SignedData<Order> signedOrder2 = this.sign(myNewOrder);
                resultOrders = ((Index)resultOrders).assoc(myAddress, signedOrder2);
            }
        }
        return resultOrders;
    }

    public static double prepareStakedOrders(AMap<AccountKey, SignedData<Order>> peerOrders, HashMap<AccountKey, Double> peerStakes, HashMap<Order, Double> dest) {
        return peerOrders.reduceValues((acc, signedOrder) -> {
            Order order = (Order)signedOrder.getValue();
            AccountKey cAddress = signedOrder.getAccountKey();
            Double cStake = (Double)peerStakes.get(cAddress);
            if (cStake == null || cStake == 0.0) {
                return acc;
            }
            Double stake = (Double)dest.get(order);
            if (stake == null) {
                dest.put(order, cStake);
            } else {
                dest.put(order, stake + cStake);
            }
            return acc + cStake;
        }, 0.0);
    }

    private ArrayList<SignedData<Block>> collectNewBlocks(Collection<AVector<SignedData<Block>>> orders, long consensusPoint) {
        HashSet<SignedData> newBlocks = new HashSet<SignedData>();
        ArrayList<SignedData<Block>> newBlocksOrdered = new ArrayList<SignedData<Block>>();
        for (AVector<SignedData<Block>> blks : orders) {
            if (blks.count() <= consensusPoint) continue;
            ListIterator<SignedData<Block>> it = blks.listIterator(consensusPoint);
            while (it.hasNext()) {
                SignedData b = (SignedData)it.next();
                if (newBlocks.contains(b)) continue;
                newBlocks.add(b);
                newBlocksOrdered.add(b);
            }
        }
        return newBlocksOrdered;
    }

    public AVector<SignedData<Block>> computeWinningOrder(HashMap<Order, Double> stakedOrders, long consensusPoint, double initialTotalStake) {
        assert (!stakedOrders.isEmpty());
        HashMap votingSet = BeliefMerge.combineToBlocks(stakedOrders);
        ArrayList<SignedData<Block>> newBlocksOrdered = this.collectNewBlocks(votingSet.keySet(), consensusPoint);
        double totalStake = initialTotalStake;
        long point = consensusPoint;
        block0: while (votingSet.size() > 1) {
            HashMap blockVotes = new HashMap();
            for (Map.Entry<AVector<SignedData<Block>>, Double> me : votingSet.entrySet()) {
                AVector<SignedData<Block>> blocks = me.getKey();
                long cCount = blocks.count();
                if (cCount <= point) continue;
                SignedData<Block> b = blocks.get(point);
                HashMap<AVector<SignedData<Block>>, Double> agreedOrders = (HashMap<AVector<SignedData<Block>>, Double>)blockVotes.get(b);
                if (agreedOrders == null) {
                    agreedOrders = new HashMap<AVector<SignedData<Block>>, Double>();
                    blockVotes.put(b, agreedOrders);
                }
                Double stake = me.getValue();
                agreedOrders.put(blocks, stake);
                if (!(stake > totalStake * 0.5)) continue;
                votingSet.clear();
                votingSet.put(blocks, stake);
                break block0;
            }
            if (blockVotes.size() == 0) break;
            Map.Entry winningResult = null;
            double winningVote = Double.NEGATIVE_INFINITY;
            for (Map.Entry me : blockVotes.entrySet()) {
                HashMap agreedChains = (HashMap)me.getValue();
                double blockVote = BeliefMerge.computeTotalVote(agreedChains);
                if (winningResult == null || blockVote > winningVote) {
                    winningVote = blockVote;
                    winningResult = me;
                    continue;
                }
                if (blockVote != winningVote || ((SignedData)me.getKey()).getHash().compareTo(((SignedData)winningResult.getKey()).getHash()) >= 0) continue;
                winningResult = me;
            }
            if (winningResult == null) {
                throw new Error("null winning Order shouldn't happen!");
            }
            votingSet = (HashMap)winningResult.getValue();
            totalStake = winningVote;
            ++point;
        }
        if (votingSet.size() == 0) {
            return null;
        }
        AVector<SignedData<Block>> winningBlocks = votingSet.keySet().iterator().next();
        winningBlocks = this.appendNewBlocks(winningBlocks, newBlocksOrdered, consensusPoint);
        return winningBlocks;
    }

    private AVector<SignedData<Block>> filterBlocks(AVector<SignedData<Block>> blks, long cp) {
        return blks;
    }

    private static HashMap<AVector<SignedData<Block>>, Double> combineToBlocks(HashMap<Order, Double> stakedOrders) {
        HashMap<AVector<SignedData<Block>>, Double> result = new HashMap<AVector<SignedData<Block>>, Double>();
        for (Map.Entry<Order, Double> e : stakedOrders.entrySet()) {
            Order c = e.getKey();
            Double stake = e.getValue();
            AVector<SignedData<Block>> blocks = c.getBlocks();
            Double acc = result.get(blocks);
            if (acc == null) {
                result.put(blocks, stake);
                continue;
            }
            result.put(blocks, acc + stake);
        }
        return result;
    }

    private final AVector<SignedData<Block>> appendNewBlocks(AVector<SignedData<Block>> blocks, ArrayList<SignedData<Block>> newBlocksOrdered, long consensusPoint) {
        HashSet<SignedData<Block>> newBlocks = new HashSet<SignedData<Block>>();
        newBlocks.addAll(newBlocksOrdered);
        long scanStart = Math.min(blocks.count(), consensusPoint);
        ListIterator<SignedData<Block>> it = blocks.listIterator(scanStart);
        while (it.hasNext()) {
            newBlocks.remove(it.next());
        }
        newBlocksOrdered.removeIf(sb -> {
            BlockResult br = this.state.checkBlock((SignedData<Block>)sb);
            if (br != null) {
                return true;
            }
            return !newBlocks.contains(sb);
        });
        newBlocksOrdered.sort(Block.TIMESTAMP_COMPARATOR);
        AVector<SignedData<Block>> fullBlocks = blocks.appendAll(newBlocksOrdered);
        return fullBlocks;
    }

    private Order updateConsensus(Order order, HashMap<Order, Double> stakedOrders, double totalStake) {
        double THRESHOLD = totalStake * 0.67;
        for (int level = 1; level < 4; ++level) {
            order = this.updateLevel(order, level, stakedOrders, THRESHOLD);
        }
        return order;
    }

    private Order updateLevel(final Order winnningOrder, final int level, HashMap<Order, Double> stakedOrders, double THRESHOLD) {
        Order c;
        Double chainStake;
        int i;
        final AVector<SignedData<Block>> proposedBlocks = winnningOrder.getBlocks();
        ArrayList<Order> agreedChains = Utils.sortListBy(new Function<Order, Long>(){

            @Override
            public Long apply(Order c) {
                long blockMatch = proposedBlocks.commonPrefixLength(c.getBlocks());
                int prevLevel = level - 1;
                long minPrevious = Math.min(winnningOrder.getConsensusPoint(prevLevel), c.getConsensusPoint(prevLevel));
                long match = Math.min(blockMatch, minPrevious);
                return -match;
            }
        }, stakedOrders.keySet());
        int numAgreed = agreedChains.size();
        double accumulatedStake = 0.0;
        for (i = 0; i < numAgreed && !((accumulatedStake += (chainStake = stakedOrders.get(c = agreedChains.get(i))).doubleValue()) > THRESHOLD); ++i) {
        }
        if (i < numAgreed) {
            Order lastAgreed = agreedChains.get(i);
            long prefixMatch = winnningOrder.getBlocks().commonPrefixLength(lastAgreed.getBlocks());
            long previousLevel = Math.min(winnningOrder.getConsensusPoint(level - 1), lastAgreed.getConsensusPoint(level - 1));
            long newPoint = Math.min(prefixMatch, previousLevel);
            return winnningOrder.withConsensusPoint(level, newPoint);
        }
        return winnningOrder;
    }

    public static <V> double computeTotalVote(HashMap<V, Double> m) {
        double result = 0.0;
        for (Map.Entry<V, Double> me : m.entrySet()) {
            result += me.getValue().doubleValue();
        }
        return result;
    }

    private Order getMyOrder() {
        Index<AccountKey, SignedData<Order>> orders = this.initialBelief.getOrders();
        SignedData<Order> signed = orders.get(this.publicKey);
        if (signed == null) {
            return null;
        }
        return signed.getValue();
    }

    public static boolean compareOrders(Order oldOrder, Order newOrder) {
        if (newOrder == null) {
            return false;
        }
        if (oldOrder == null) {
            return true;
        }
        int tsComp = Long.compare(oldOrder.getTimestamp(), newOrder.getTimestamp());
        if (tsComp > 0) {
            return false;
        }
        if (tsComp < 0) {
            return true;
        }
        if (oldOrder.equals(newOrder)) {
            return false;
        }
        for (int level = 0; level < 4; ++level) {
            if (newOrder.getConsensusPoint(level) <= oldOrder.getConsensusPoint(level)) continue;
            return true;
        }
        return false;
    }

    private Index<AccountKey, SignedData<Order>> accumulateOrders(Belief[] beliefs) {
        Index<AccountKey, SignedData<Order>> result = this.initialBelief.getOrders();
        for (Belief belief : beliefs) {
            if (belief == null) continue;
            result = this.accumulateOrders(result, belief);
        }
        return result;
    }

    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    public <T extends ACell> SignedData<T> sign(T value) {
        return SignedData.sign(this.keyPair, value);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BeliefMerge withTimestamp(long newTimestamp) {
        if (this.timestamp == newTimestamp) {
            return this;
        }
        return new BeliefMerge(this.initialBelief, this.keyPair, newTimestamp, this.state);
    }

    public State getConsensusState() {
        return this.state;
    }
}

