/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cpos;

import convex.core.cpos.Block;
import convex.core.cpos.Order;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.data.ACell;
import convex.core.data.AIndex;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class Belief
extends ARecordGeneric {
    private static final RecordFormat BELIEF_FORMAT = RecordFormat.of(Keywords.ORDERS);
    private static final long IX_ORDERS = BELIEF_FORMAT.indexFor(Keywords.ORDERS);
    private static final Index<AccountKey, SignedData<Order>> EMPTY_ORDERS = Index.none();
    private Index<AccountKey, SignedData<Order>> orders;

    private Belief(Index<AccountKey, SignedData<Order>> orders) {
        super((byte)-44, BELIEF_FORMAT, Vectors.create(orders));
    }

    private Belief(AVector<ACell> newValues) {
        super((byte)-44, BELIEF_FORMAT, newValues);
    }

    @Override
    public ACell get(Keyword k) {
        if (Keywords.ORDERS.equals(k)) {
            return this.getOrders();
        }
        return null;
    }

    public static Belief initial() {
        return Belief.create(EMPTY_ORDERS);
    }

    public static Belief create(AKeyPair kp, Order order) {
        Index<AccountKey, SignedData<Order>> orders = Index.of((Object)kp.getAccountKey(), kp.signData(order));
        return Belief.create(orders);
    }

    public static Belief fromOrders(ACell source) {
        if ((source = RT.cvm(source)) instanceof Index) {
            return Belief.create((Index)source);
        }
        return null;
    }

    public static Belief create(SignedData<Order> ... orders) {
        AIndex newOrders = EMPTY_ORDERS;
        for (SignedData<Order> so : orders) {
            newOrders = newOrders.assoc(so.getAccountKey(), so);
        }
        return new Belief((Index<AccountKey, SignedData<Order>>)newOrders);
    }

    public static Belief create(HashMap<AccountKey, SignedData<Order>> orderMap) {
        Index orders = (Index)Index.create(orderMap);
        return new Belief(orders);
    }

    public static Belief create(Index<AccountKey, SignedData<Order>> orders) {
        return new Belief(orders);
    }

    public static Belief createSingleOrder(AKeyPair kp) {
        AccountKey address = kp.getAccountKey();
        SignedData<Order> order = kp.signData(Order.create());
        return Belief.create(Index.of((Object)address, order));
    }

    public Belief withOrders(Index<AccountKey, SignedData<Order>> newOrders) {
        if (newOrders == this.getOrders()) {
            return this;
        }
        return Belief.create(newOrders);
    }

    public static Belief read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        if (values.count() != 1L) {
            throw new BadFormatException("Wrong number of values for Belief");
        }
        Belief result = new Belief(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    public Order getOrder(AccountKey address) {
        SignedData<Order> sc = this.getOrders().get(address);
        if (sc == null) {
            return null;
        }
        return sc.getValue();
    }

    public Index<AccountKey, SignedData<Order>> getOrders() {
        if (this.orders == null) {
            this.orders = (Index)this.values.get(0);
        }
        return this.orders;
    }

    public HashMap<AccountKey, SignedData<Order>> getOrdersHashMap() {
        return this.getOrders().toHashMap();
    }

    public static Collection<SignedData<Order>> extractOrders(ACell payload) {
        ArrayList<SignedData<Order>> result = new ArrayList<SignedData<Order>>();
        if (payload instanceof SignedData) {
            SignedData sd = (SignedData)payload;
            if (sd.getValue() instanceof Order) {
                result.add(sd);
            }
        } else if (payload instanceof Belief) {
            Belief b = (Belief)payload;
            Index<AccountKey, SignedData<Order>> porders = b.getOrders();
            int n = porders.size();
            for (int i = 0; i < n; ++i) {
                result.add((SignedData)porders.entryAt(i).getValue());
            }
        }
        return result;
    }

    @Override
    public void validateStructure() throws InvalidDataException {
        super.validateStructure();
        if (!(this.values.get(IX_ORDERS) instanceof Index)) {
            throw new InvalidDataException("Orders should be an Index", this);
        }
    }

    public Belief proposeBlock(AKeyPair kp, SignedData<Block> ... signedBlocks) {
        Order myOrder;
        AccountKey peerKey = kp.getAccountKey();
        Index<AccountKey, SignedData<Order>> orders = this.getOrders();
        SignedData<Order> mySO = orders.get(peerKey);
        if (mySO == null) {
            throw new IllegalStateException("Trying to propose block without a current ordering for peer " + String.valueOf(peerKey));
        }
        Order newOrder = myOrder = mySO.getValue();
        int n = signedBlocks.length;
        for (int i = 0; i < n; ++i) {
            newOrder = newOrder.append(signedBlocks[i]);
        }
        SignedData<Order> newSignedOrder = kp.signData(newOrder);
        AIndex newOrders = orders.assoc(peerKey, newSignedOrder);
        Belief newBelief = this.withOrders((Index<AccountKey, SignedData<Order>>)newOrders);
        return newBelief;
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Belief(newValues);
    }
}

