/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Keyword;
import java.util.HashMap;
import java.util.Map;

public class ErrorCodes {
    public static final Keyword SEQUENCE = Keyword.intern("SEQUENCE");
    public static final Keyword FUNDS = Keyword.intern("FUNDS");
    public static final Keyword JUICE = Keyword.intern("JUICE");
    public static final Keyword DEPTH = Keyword.intern("DEPTH");
    public static final Keyword MEMORY = Keyword.intern("MEMORY");
    public static final Keyword NOBODY = Keyword.intern("NOBODY");
    public static final Keyword ARITY = Keyword.intern("ARITY");
    public static final Keyword UNDECLARED = Keyword.intern("UNDECLARED");
    public static final Keyword CAST = Keyword.intern("CAST");
    public static final Keyword BOUNDS = Keyword.intern("BOUNDS");
    public static final Keyword ARGUMENT = Keyword.intern("ARGUMENT");
    public static final Keyword STATE = Keyword.intern("STATE");
    public static final Keyword COMPILE = Keyword.intern("COMPILE");
    public static final Keyword EXPAND = Keyword.intern("EXPAND");
    public static final Keyword ASSERT = Keyword.intern("ASSERT");
    public static final Keyword TRUST = Keyword.intern("TRUST");
    public static final Keyword UNEXPECTED = Keyword.intern("UNEXPECTED");
    public static final Keyword EXCEPTION = Keyword.intern("EXCEPTION");
    public static final Keyword HALT = Keyword.intern("HALT");
    public static final Keyword RECUR = Keyword.intern("RECUR");
    public static final Keyword TAILCALL = Keyword.intern("TAILCALL");
    public static final Keyword RETURN = Keyword.intern("RETURN");
    public static final Keyword REDUCED = Keyword.intern("REDUCED");
    public static final Keyword ROLLBACK = Keyword.intern("ROLLBACK");
    public static final Keyword SIGNATURE = Keyword.intern("SIGNATURE");
    public static final Keyword TODO = Keyword.intern("TODO");
    public static final Keyword FATAL = Keyword.intern("FATAL");
    public static final Keyword FORMAT = Keyword.intern("FORMAT");
    public static final Keyword LOAD = Keyword.intern("LOAD");
    public static final Keyword CHILD = Keyword.intern("CHILD");
    public static final Keyword TIMEOUT = Keyword.intern("TIMEOUT");
    public static final Keyword PEER = Keyword.intern("PEER");
    public static final Keyword SYNTAX = Keyword.intern("SYNTAX");
    public static final Keyword LIQUIDITY = Keyword.intern("LIQUIDITY");
    public static final Keyword INTERRUPTED = Keyword.intern("INTERRUPTED");
    public static final Keyword CLOSED = Keyword.intern("CLOSED");
    public static final Keyword IO = Keyword.intern("IO");
    public static final Keyword MISSING = Keyword.intern("MISSING");
    public static final Keyword LIMIT = Keyword.intern("LIMIT");
    public static final Keyword CONNECT = Keyword.intern("CONNECT");
    private static final Map<Keyword, String> DESCRIPTIONS = new HashMap<Keyword, String>();

    public static String getDescription(Keyword errorCode) {
        if (errorCode == null) {
            return null;
        }
        return DESCRIPTIONS.get(errorCode);
    }

    public static String getDescription(String errorCode) {
        if (errorCode == null) {
            return null;
        }
        return ErrorCodes.getDescription(Keyword.create(errorCode));
    }

    public static String getDescription(AString errorCode) {
        if (errorCode == null) {
            return null;
        }
        return ErrorCodes.getDescription(errorCode.toString());
    }

    public static String getDescription(ACell errorCode) {
        if (errorCode == null) {
            return null;
        }
        if (errorCode instanceof Keyword) {
            Keyword k = (Keyword)errorCode;
            return ErrorCodes.getDescription(k);
        }
        if (errorCode instanceof AString) {
            AString s = (AString)errorCode;
            return ErrorCodes.getDescription(s);
        }
        return ErrorCodes.getDescription(errorCode.toString());
    }

    static {
        DESCRIPTIONS.put(SEQUENCE, "Bad sequence number - must be one greater than the current sequence");
        DESCRIPTIONS.put(FUNDS, "Insufficient funds to perform the operation");
        DESCRIPTIONS.put(JUICE, "Transaction ran out of available juice (computational resources)");
        DESCRIPTIONS.put(DEPTH, "Execution depth limit exceeded - typically indicates infinite recursion");
        DESCRIPTIONS.put(MEMORY, "Insufficient memory allowance to complete transaction");
        DESCRIPTIONS.put(NOBODY, "Attempting to access a non-existent account");
        DESCRIPTIONS.put(ARITY, "Function or expander has inappropriate number of arguments");
        DESCRIPTIONS.put(UNDECLARED, "Accessed an undeclared symbol");
        DESCRIPTIONS.put(CAST, "Argument cannot be cast to the required type");
        DESCRIPTIONS.put(BOUNDS, "Index out of bounds for sequential object");
        DESCRIPTIONS.put(ARGUMENT, "Argument is of correct type but not an allowable value");
        DESCRIPTIONS.put(STATE, "Operation failed due to invalid state - check pre-conditions");
        DESCRIPTIONS.put(COMPILE, "Compilation failure with invalid AST");
        DESCRIPTIONS.put(EXPAND, "AST expansion failure");
        DESCRIPTIONS.put(ASSERT, "Asserted condition was not met");
        DESCRIPTIONS.put(TRUST, "Trust condition violated - unauthorised operation");
        DESCRIPTIONS.put(UNEXPECTED, "Unexpected error occurred");
        DESCRIPTIONS.put(EXCEPTION, "Unhandled exception");
        DESCRIPTIONS.put(HALT, "Halt operation executed");
        DESCRIPTIONS.put(RECUR, "Recur operation executed");
        DESCRIPTIONS.put(TAILCALL, "Tailcall operation executed");
        DESCRIPTIONS.put(RETURN, "Return operation executed");
        DESCRIPTIONS.put(REDUCED, "Reduced result");
        DESCRIPTIONS.put(ROLLBACK, "Rollback operation executed - state changes reverted");
        DESCRIPTIONS.put(SIGNATURE, "Invalid signature on transaction");
        DESCRIPTIONS.put(TODO, "Not yet implemented");
        DESCRIPTIONS.put(FATAL, "Fatal error - STOP everything now!");
        DESCRIPTIONS.put(FORMAT, "Message format error");
        DESCRIPTIONS.put(LOAD, "Rejected due to load limits");
        DESCRIPTIONS.put(CHILD, "Child transaction failed");
        DESCRIPTIONS.put(TIMEOUT, "Operation timed out");
        DESCRIPTIONS.put(PEER, "Peer-specific error");
        DESCRIPTIONS.put(SYNTAX, "Syntax problem in code");
        DESCRIPTIONS.put(LIQUIDITY, "Insufficient liquidity for trade");
        DESCRIPTIONS.put(INTERRUPTED, "Operation was interrupted");
        DESCRIPTIONS.put(CLOSED, "IO channel or resource is closed");
        DESCRIPTIONS.put(IO, "General IO exception");
        DESCRIPTIONS.put(MISSING, "Missing data");
        DESCRIPTIONS.put(LIMIT, "Resource limit exceeded");
        DESCRIPTIONS.put(CONNECT, "Connection failure");
    }
}

