/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class SoftCache<K, V>
extends AbstractMap<K, V> {
    private WeakHashMap<K, SoftReference<V>> cache = new WeakHashMap();

    @Override
    public V get(Object key) {
        SoftReference<V> sr = this.getSoftReference(key);
        if (sr == null) {
            return null;
        }
        return sr.get();
    }

    public SoftReference<V> getSoftReference(Object key) {
        return this.cache.get(key);
    }

    @Override
    public V put(K key, V value) {
        SoftReference<V> sr = new SoftReference<V>(value);
        this.cache.put(key, sr);
        return null;
    }

    public SoftReference<V> putReference(K key, SoftReference<V> valueRef) {
        return this.cache.put(key, valueRef);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, SoftReference<V>> e : this.cache.entrySet()) {
            V val = e.getValue().get();
            if (val == null) continue;
            result.add(new AbstractMap.SimpleEntry<K, V>(e.getKey(), val));
        }
        return result;
    }
}

