/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import java.security.SecureRandom;

public class Bits {
    private static final long SALT = new SecureRandom().nextLong();

    public static int indexForDigit(int digit, short mask) {
        if ((mask & 1 << digit) == 0) {
            return -1;
        }
        return Bits.positionForDigit(digit, mask);
    }

    public static int positionForDigit(int digit, short mask) {
        return Integer.bitCount(mask & (1 << digit) - 1);
    }

    public static int leadingZeros(int x) {
        if (x == 0) {
            return 32;
        }
        int result = 0;
        if ((x & 0xFFFF0000) == 0) {
            result += 16;
        } else {
            x >>>= 16;
        }
        if ((x & 0xFF00) == 0) {
            result += 8;
        } else {
            x >>>= 8;
        }
        if ((x & 0xF0) == 0) {
            result += 4;
        } else {
            x >>>= 4;
        }
        if ((x & 0xC) == 0) {
            result += 2;
        } else {
            x >>>= 2;
        }
        if ((x & 2) == 0) {
            ++result;
        }
        return result;
    }

    public static int leadingZeros(long x) {
        int z = Bits.leadingZeros((int)(x >>> 32));
        if (z < 32) {
            return z;
        }
        return z + Bits.leadingZeros((int)x);
    }

    public static int lowBitMask(int numBits) {
        return (1 << numBits) - 1;
    }

    public static int lowBits(int numBits, int val) {
        return val & Bits.lowBitMask(numBits);
    }

    public static int leadingOnes(long value) {
        return Long.numberOfLeadingZeros(value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long xorshift64(long x) {
        x ^= x << 13;
        x ^= x >> 7;
        x ^= x << 17;
        return x;
    }

    public static final long hash64(long x) {
        return SALT ^ Bits.xorshift64(x ^ SALT);
    }

    public static final int hash32(long x) {
        return (int)(SALT ^ Bits.xorshift64(x ^ SALT));
    }
}

