/*
 * Decompiled with CFR 0.152.
 */
package convex.core.text;

import convex.core.Coin;
import convex.core.data.prim.CVMDouble;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.TODOException;
import convex.core.util.Utils;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;

public class Text {
    private static final int WHITESPACE_LENGTH = 32;
    private static final String ZEROS_9 = "000000000";
    private static String WHITESPACE_32 = "                                ";
    private static DecimalFormatSymbols symbols = new DecimalFormatSymbols();
    static DecimalFormat balanceFormatter;
    static DecimalFormat percentFormatter;
    static DecimalFormat decimalFormatter;
    static final DateTimeFormatter formatter;

    public static boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static String whiteSpace(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative whitespace requested!");
        }
        if (length == 0) {
            return "";
        }
        if (length <= 32) {
            return WHITESPACE_32.substring(0, length);
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 32; i <= length; i += 32) {
            sb.append(WHITESPACE_32);
        }
        sb.append(Text.whiteSpace(length & 0x1F));
        return sb.toString();
    }

    public static String leftPad(String s, int length) {
        int spaces;
        if (s == null) {
            s = "";
        }
        if ((spaces = length - s.length()) < 0) {
            return s.substring(0, length);
        }
        return Text.whiteSpace(spaces) + s;
    }

    public static String leftPad(long value, int length) {
        return Text.leftPad(Long.toString(value), length);
    }

    public static String rightPad(String s, int length) {
        int spaces;
        if (s == null) {
            s = "";
        }
        if ((spaces = length - s.length()) < 0) {
            throw new IllegalArgumentException("String [" + s + "] too long for pad length: " + length);
        }
        return s + Text.whiteSpace(spaces);
    }

    public static String rightPad(long value, int length) {
        return Text.rightPad(Long.toString(value), length);
    }

    public static String toFriendlyNumber(long value) {
        return balanceFormatter.format(value);
    }

    public static String toPercentString(double value) {
        return percentFormatter.format(value);
    }

    public static String toFriendlyDecimal(double value) {
        if (!Double.isFinite(value)) {
            return CVMDouble.create(value).toString();
        }
        return decimalFormatter.format(value);
    }

    public static String toFriendlyIntString(double value) {
        return Text.toFriendlyNumber((long)value);
    }

    public static String toFriendlyBalance(long balance) {
        return Text.toFriendlyBalance(balance, 9);
    }

    public static String toFriendlyBalance(long balance, int decimals) {
        if (!Coin.isValidAmount(balance)) {
            throw new IllegalArgumentException("Invalid balance)");
        }
        long gold = balance / 1000000000L;
        long copper = balance % 1000000000L;
        String goldString = Text.toFriendlyNumber(gold);
        if (decimals <= 0) {
            return goldString;
        }
        Object copperString = Long.toString(copper);
        int cn = ((String)copperString).length();
        if (cn < 9) {
            copperString = ZEROS_9.substring(cn, 9) + (String)copperString;
        }
        copperString = ((String)copperString).substring(0, decimals);
        return goldString + "." + (String)copperString;
    }

    public static String dateFormat(long timestamp) {
        return formatter.format(Instant.ofEpochMilli(timestamp));
    }

    public static void writeEscapedByte(BlobBuilder sb, byte b) {
        char c = (char)b;
        switch (c) {
            case '\"': {
                sb.append('\\');
                sb.append('\"');
                return;
            }
            case '\\': {
                sb.append('\\');
                sb.append('\\');
                return;
            }
            case '\t': {
                sb.append('\\');
                sb.append('t');
                return;
            }
            case '\b': {
                sb.append('\\');
                sb.append('b');
                return;
            }
            case '\n': {
                sb.append('\\');
                sb.append('n');
                return;
            }
            case '\r': {
                sb.append('\\');
                sb.append('r');
                return;
            }
            case '\f': {
                sb.append('\\');
                sb.append('f');
                return;
            }
        }
        sb.append(b);
    }

    public static int lineCount(String text) {
        if (text == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    public static int columnCount(String text) {
        if (text == null) {
            return 0;
        }
        int result = 0;
        int n = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                n = 0;
                continue;
            }
            if (++n <= result) continue;
            result = n;
        }
        return result;
    }

    public static String zeroPad(BigInteger b, int digits) {
        if (digits > 9) {
            throw new IllegalArgumentException("Too many digits!!");
        }
        if (b.signum() < 0) {
            throw new IllegalArgumentException("Negative number!");
        }
        Object s = b.toString();
        int n = ((String)s).length();
        if (n < digits) {
            s = ZEROS_9.substring(0, digits - n) + (String)s;
        }
        return s;
    }

    public static String repeat(char c, int count) {
        char[] cs = new char[count];
        Arrays.fill(cs, c);
        return new String(cs);
    }

    public static String escapeJava(String s) {
        throw new TODOException();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeJava(String st) {
        StringBuilder sb = null;
        int n = st.length();
        int i = 0;
        while (true) {
            block23: {
                int ch;
                int startPos;
                block20: {
                    block24: {
                        int v;
                        int j;
                        int code;
                        block22: {
                            String string;
                            block19: {
                                char nextChar;
                                block21: {
                                    if (i >= n) break block19;
                                    startPos = i;
                                    ch = st.charAt(i);
                                    if (ch != 92 || i + 1 >= n) break block20;
                                    nextChar = st.charAt(i + 1);
                                    if (nextChar < '0' || nextChar > '7') break block21;
                                    code = Utils.octalVal(nextChar);
                                    break block22;
                                }
                                switch (nextChar) {
                                    case '\\': {
                                        ch = 92;
                                        break;
                                    }
                                    case 'b': {
                                        ch = 8;
                                        break;
                                    }
                                    case 'f': {
                                        ch = 12;
                                        break;
                                    }
                                    case 'n': {
                                        ch = 10;
                                        break;
                                    }
                                    case 'r': {
                                        ch = 13;
                                        break;
                                    }
                                    case 't': {
                                        ch = 9;
                                        break;
                                    }
                                    case '\"': {
                                        ch = 34;
                                        break;
                                    }
                                    case '\'': {
                                        ch = 39;
                                        break;
                                    }
                                    case 'u': {
                                        if (i + 6 > n) {
                                            return null;
                                        }
                                        int cp = 0;
                                        for (j = 0; j < 4; ++j) {
                                            v = Utils.hexVal(st.charAt(i + j + 2));
                                            if (v < 0) {
                                                return null;
                                            }
                                            cp = cp * 16 + Utils.hexVal(st.charAt(i + j + 2));
                                        }
                                        if (sb == null) {
                                            sb = new StringBuilder(st.substring(0, startPos));
                                        }
                                        sb.append(Character.toChars(cp));
                                        i += 5;
                                        break block23;
                                    }
                                }
                                break block24;
                            }
                            if (sb == null) {
                                string = st;
                                return string;
                            }
                            string = sb.toString();
                            return string;
                        }
                        for (j = i + 2; j < i + 4 && j < n && (v = Utils.octalVal(st.charAt(j))) >= 0 && code < 32; ++i, ++j) {
                            code = code * 8 + v;
                        }
                        ch = (char)code;
                    }
                    ++i;
                }
                if (sb == null) {
                    sb = new StringBuilder(st.substring(0, startPos));
                }
                sb.append((char)ch);
            }
            ++i;
        }
    }

    static {
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(',');
        balanceFormatter = new DecimalFormat("#,###", symbols);
        percentFormatter = new DecimalFormat("##.###%", symbols);
        decimalFormatter = new DecimalFormat("#,##0.####", symbols);
        formatter = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();
    }
}

