/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.store.AStore;
import convex.core.store.MemoryStore;
import convex.core.util.UnsafeRunnable;
import convex.core.util.Utils;
import convex.etch.EtchStore;
import java.io.IOException;
import java.util.concurrent.Callable;

public class Stores {
    private static AStore defaultStore = null;
    private static AStore globalStore = null;
    private static final ThreadLocal<AStore> currentStore = new ThreadLocal<AStore>(){

        @Override
        protected AStore initialValue() {
            return Stores.getGlobalStore();
        }
    };

    public static AStore current() {
        return currentStore.get();
    }

    public static void setCurrent(AStore store) {
        currentStore.set(store);
    }

    private static synchronized AStore getDefaultStore() {
        if (defaultStore == null) {
            try {
                defaultStore = EtchStore.createTemp("convex-db");
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return defaultStore;
    }

    public static AStore getGlobalStore() {
        if (globalStore == null) {
            globalStore = Stores.getDefaultStore();
        }
        return globalStore;
    }

    public static void setGlobalStore(EtchStore store) {
        if (store == null) {
            throw new IllegalArgumentException("Cannot set global store to null)");
        }
        globalStore = store;
    }

    public static void runWithMemoryStore(UnsafeRunnable r) {
        AStore saved = Stores.current();
        try {
            Stores.setCurrent(new MemoryStore());
            r.run();
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
        finally {
            Stores.setCurrent(saved);
        }
    }

    public static <V> V runWithMemoryStore(Callable<V> r) {
        AStore saved = Stores.current();
        try {
            Stores.setCurrent(new MemoryStore());
            V v = r.call();
            return v;
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
        finally {
            Stores.setCurrent(saved);
        }
    }
}

