/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.cvm.CVMEncoder;
import convex.core.data.ACell;
import convex.core.data.AEncoder;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.store.AStore;
import convex.core.store.RefCache;
import convex.core.store.Stores;

public abstract class ACachedStore
extends AStore {
    protected final RefCache refCache = RefCache.create(10000);
    protected static final CVMEncoder encoder = new CVMEncoder();

    @Override
    public AEncoder<ACell> getEncoder() {
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends ACell> T decode(Blob encoding) throws BadFormatException {
        ACell decoded;
        Hash hash = encoding.getContentHash();
        Ref<?> cached = this.refCache.getCell(hash);
        if (cached != null) {
            return (T)cached.getValue();
        }
        AStore tempStore = Stores.current();
        if (tempStore == this) {
            decoded = encoder.decode(encoding);
        } else {
            try {
                Stores.setCurrent(this);
                decoded = encoder.decode(encoding);
            }
            finally {
                Stores.setCurrent(tempStore);
            }
        }
        this.refCache.putCell(decoded);
        return (T)decoded;
    }

    @Override
    public <T extends ACell> Ref<T> checkCache(Hash h) {
        return this.refCache.getCell(h);
    }
}

