/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.cvm.Context;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.AClosure;
import convex.core.lang.impl.Fn;

public class MultiFn<T extends ACell>
extends AClosure<T> {
    private final int num;

    private MultiFn(AVector<?> fns) {
        super(fns);
        this.num = fns.size();
    }

    public static <R extends ACell> MultiFn<R> create(AVector<?> data) {
        return new MultiFn(data);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public MultiFn<T> toCanonical() {
        return this;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("(fn ");
        if (!this.printInternal(bb, limit)) {
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    @Override
    public boolean printInternal(BlobBuilder bb, long limit) {
        AVector<AClosure<T>> fns = this.getFunctions();
        for (long i = 0L; i < (long)this.num; ++i) {
            AClosure fn;
            if (i > 0L) {
                bb.append(' ');
            }
            if ((fn = Fn.ensureFunction(fns.get(i))) == null) {
                bb.append("nil");
                if (bb.check(limit)) continue;
                return false;
            }
            bb.append('(');
            if (!fn.printInternal(bb, limit)) {
                return false;
            }
            bb.append(')');
        }
        return bb.check(limit);
    }

    private AVector<AClosure<T>> getFunctions() {
        return this.data;
    }

    @Override
    public Context invoke(Context context, ACell[] args) {
        AVector<AClosure<T>> fns = this.getFunctions();
        for (int i = 0; i < this.num; ++i) {
            AClosure fn = Fn.ensureFunction((ACell)fns.get(i));
            if (fn == null || !fn.supportsArgs(args)) continue;
            return fn.invoke(context, args);
        }
        return context.withArityError("No matching function arity found for arity " + args.length);
    }

    @Override
    public boolean hasArity(int n) {
        AVector<AClosure<T>> fns = this.getFunctions();
        for (int i = 0; i < this.num; ++i) {
            AClosure fn = Fn.ensureFunction((ACell)fns.get(i));
            if (fn == null || !fn.hasArity(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    public static <T extends ACell> MultiFn<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        AVector fns = (AVector)Format.read(b, epos);
        if (fns == null) {
            throw new BadFormatException("Null fns!");
        }
        MultiFn<T> result = new MultiFn<T>((AVector<?>)fns);
        result.attachEncoding(b.slice(pos, epos += Cells.getEncodingLength(fns)));
        return result;
    }

    @Override
    public <F extends AClosure<T>> F withEnvironment(AVector<ACell> env) {
        return (F)new MultiFn<T>((AVector<?>)this.data.map(a -> {
            AClosure fn = Fn.ensureFunction(a);
            if (fn == null) {
                return null;
            }
            return fn.withEnvironment(env);
        }));
    }

    @Override
    protected MultiFn<T> recreate(AVector<ACell> newData) {
        if (this.data == newData) {
            return this;
        }
        return new MultiFn<T>((AVector<?>)newData);
    }
}

