/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.cvm.AFn;
import convex.core.cvm.Context;
import convex.core.data.ACell;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Symbol;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.ICoreDef;
import convex.core.util.Bits;

public abstract class CoreFn<T extends ACell>
extends AFn<T>
implements ICoreDef {
    private Symbol symbol;
    private int arity;
    private int code;
    private boolean variadic;

    protected CoreFn(Symbol symbol, int code) {
        this.symbol = symbol;
        this.arity = 0;
        this.code = code;
        this.variadic = true;
    }

    @Override
    public abstract Context invoke(Context var1, ACell[] var2);

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public Symbol getIntrinsicSymbol() {
        return this.symbol;
    }

    @Override
    public byte getTag() {
        return -19;
    }

    protected String name() {
        return this.symbol.getName().toString();
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public CoreFn<T> toCanonical() {
        return this;
    }

    protected String minArityMessage(int minArity, int actual) {
        return this.name() + " requires minimum arity " + minArity + " but called with: " + actual;
    }

    protected String maxArityMessage(int maxArity, int actual) {
        return this.name() + " requires maximum arity " + maxArity + " but called with: " + actual;
    }

    protected String rangeArityMessage(int minArity, int maxArity, int actual) {
        return this.name() + " requires arity between " + minArity + " and " + maxArity + " but called with: " + actual;
    }

    protected String exactArityMessage(int arity, int actual) {
        return this.name() + " requires arity " + arity + " but called with: " + actual;
    }

    @Override
    public boolean hasArity(int n) {
        if (n == this.arity) {
            return true;
        }
        if (n < this.arity) {
            return false;
        }
        return this.variadic;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return this.symbol.print(sb, limit);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -19;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLQCount(bs, pos, this.code);
        return pos;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public final int hashCode() {
        return Bits.hash32(this.code);
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        throw new IndexOutOfBoundsException("Bad ref index: " + i);
    }

    @Override
    public CoreFn<T> updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public int estimatedEncodingSize() {
        return 5;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.symbol.validateCell();
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    protected final long calcMemorySize() {
        return 0L;
    }

    @Override
    public boolean equals(ACell o) {
        if (o instanceof CoreFn) {
            return o == this;
        }
        return Cells.equalsGeneric(this, o);
    }

    @Override
    public int getCoreCode() {
        return this.code;
    }
}

