/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.cvm.AFn;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;

public abstract class AClosure<T extends ACell>
extends AFn<T> {
    protected static final AVector<ACell> EMPTY_BINDINGS = Vectors.empty();
    protected final AVector<ACell> data;

    protected AClosure(AVector<ACell> data) {
        this.data = data;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.data.encodeRaw(bs, pos);
    }

    @Override
    public final byte getTag() {
        return -33;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.data.estimatedEncodingSize();
    }

    @Override
    public int getRefCount() {
        return this.data.getRefCount();
    }

    public Ref<ACell> getRef(int i) {
        return this.data.getRef(i);
    }

    @Override
    public AFn<T> updateRefs(IRefFunction func) {
        ACell newData = this.data.updateRefs(func);
        if (this.data == newData) {
            return this;
        }
        return this.recreate((AVector<ACell>)newData);
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    protected abstract AFn<T> recreate(AVector<ACell> var1);

    public abstract <F extends AClosure<T>> F withEnvironment(AVector<ACell> var1);

    public abstract boolean printInternal(BlobBuilder var1, long var2);
}

