/*
 * Decompiled with CFR 0.152.
 */
package convex.core.json;

import convex.core.data.ACell;
import convex.core.data.Cells;
import convex.core.data.Maps;
import convex.core.data.Vectors;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMDouble;
import convex.core.exceptions.ParseException;
import convex.core.json.reader.antlr.JSONBaseListener;
import convex.core.json.reader.antlr.JSONLexer;
import convex.core.json.reader.antlr.JSONParser;
import convex.core.lang.reader.ConvexErrorListener;
import convex.core.util.JSONUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

public class JSONReader {
    private static final ConvexErrorListener ERROR_LISTENER = new ConvexErrorListener();

    public static ACell read(String s) {
        return JSONReader.read((CharStream)CharStreams.fromString((String)s));
    }

    public static ACell read(Reader r) throws IOException {
        return JSONReader.read((CharStream)CharStreams.fromReader((Reader)r));
    }

    static JSONParser getParser(CharStream cs, JSONListener listener) {
        JSONLexer lexer = new JSONLexer(cs);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JSONParser parser = new JSONParser((TokenStream)tokens);
        parser.setBuildParseTree(false);
        parser.removeErrorListeners();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        parser.addParseListener(listener);
        return parser;
    }

    static ACell read(CharStream cs) {
        JSONListener listener = new JSONListener();
        JSONParser parser = JSONReader.getParser(cs, listener);
        parser.json();
        ArrayList<ACell> top = listener.popList();
        if (top.size() != 1) {
            throw new ParseException("Bad parse output: " + String.valueOf(top));
        }
        return top.get(0);
    }

    protected static class JSONListener
    extends JSONBaseListener {
        ArrayList<ArrayList<ACell>> stack = new ArrayList();

        public JSONListener() {
            this.stack.add(new ArrayList());
        }

        protected void push(ACell a) {
            ArrayList<ACell> top = this.stack.getLast();
            top.add(a);
        }

        protected <R extends ACell> R pop() {
            ArrayList<ACell> top = this.stack.getLast();
            ACell cell = top.removeLast();
            return (R)cell;
        }

        protected void pushList() {
            this.stack.add(new ArrayList());
        }

        protected ArrayList<ACell> popList() {
            ArrayList<ACell> top = this.stack.removeLast();
            return top;
        }

        @Override
        public void exitNil(JSONParser.NilContext ctx) {
            this.push(null);
        }

        @Override
        public void exitBool(JSONParser.BoolContext ctx) {
            boolean value = ctx.getText().equals("true");
            this.push(CVMBool.create(value));
        }

        @Override
        public void enterArray(JSONParser.ArrayContext ctx) {
            this.pushList();
        }

        @Override
        public void exitArray(JSONParser.ArrayContext ctx) {
            ArrayList<ACell> arr = this.popList();
            this.push(Vectors.create(arr));
        }

        @Override
        public void exitNumber(JSONParser.NumberContext ctx) {
            String num = ctx.getText();
            AInteger intv = AInteger.parse(num);
            if (intv != null) {
                this.push(intv);
                return;
            }
            try {
                CVMDouble dv = CVMDouble.parse(num);
                if (dv != null) {
                    this.push(dv);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ParseException("Can't parse as number: " + num);
        }

        @Override
        public void exitString(JSONParser.StringContext ctx) {
            String text = ctx.getText();
            String content = text.substring(1, text.length() - 1);
            this.push(JSONUtils.unescape(content));
        }

        @Override
        public void enterObj(JSONParser.ObjContext ctx) {
            this.pushList();
        }

        @Override
        public void exitObj(JSONParser.ObjContext ctx) {
            ArrayList<ACell> arr = this.popList();
            ACell[] kvs = arr.toArray(Cells.EMPTY_ARRAY);
            this.push((ACell)Maps.create(kvs));
        }
    }
}

