/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ACell;
import convex.core.data.Cells;
import convex.core.data.prim.AByteFlag;
import convex.core.data.util.BlobBuilder;
import convex.core.lang.RT;

public class ByteFlag
extends AByteFlag {
    private static final ByteFlag[] cache = new ByteFlag[16];
    protected final byte tag;

    public ByteFlag(byte tag) {
        this.tag = tag;
    }

    public static ByteFlag create(long value) {
        int m = (int)(value & 0xFL);
        if ((long)m != value) {
            return null;
        }
        return ByteFlag.unsafeCreate(m);
    }

    public static ByteFlag forTag(byte tag) {
        if ((tag & 0xF0) != -80) {
            return null;
        }
        return new ByteFlag(tag);
    }

    static ByteFlag unsafeCreate(int value) {
        return cache[value];
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.tag;
        return pos;
    }

    @Override
    public boolean isCVMValue() {
        return this.tag == -79 || this.tag == -80;
    }

    @Override
    public long longValue() {
        return (long)this.tag - -80L;
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public byte getTag() {
        return this.tag;
    }

    @Override
    public boolean equals(ACell a) {
        if (a == null) {
            return false;
        }
        return this.tag == a.getTag();
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return RT.printCAD3(sb, limit, this);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            byte tag = (byte)(-80 + i);
            ByteFlag.cache[i] = Cells.intern(new ByteFlag(tag));
        }
    }
}

