/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.cvm.RecordFormat;
import convex.core.data.ACAD3Record;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.Tag;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import java.util.Set;

public class DenseRecord
extends ACAD3Record {
    protected final AVector<ACell> data;

    protected DenseRecord(byte tag, AVector<ACell> data) {
        super(tag, data.count());
        this.data = data;
    }

    public static DenseRecord create(int tag, AVector<?> data) {
        if (data == null) {
            return null;
        }
        if (Tag.category(tag) != -48) {
            return null;
        }
        return new DenseRecord((byte)tag, data);
    }

    @Override
    public int estimatedEncodingSize() {
        return this.data.estimatedEncodingSize();
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.data.encodeRaw(bs, pos);
    }

    public static DenseRecord read(byte tag, Blob b, int pos) throws BadFormatException {
        AVector data = Vectors.read(b, pos);
        Blob enc = data.cachedEncoding();
        data.attachEncoding(null);
        DenseRecord dr = DenseRecord.create(tag, data);
        if (enc != null && enc.byteAt(0L) == tag) {
            dr.attachEncoding(enc);
        }
        return dr;
    }

    @Override
    public AType getType() {
        return Types.CAD3;
    }

    @Override
    public int getRefCount() {
        return this.data.getRefCount();
    }

    @Override
    public Ref<ACell> getRef(int i) {
        return this.data.getRef(i);
    }

    @Override
    public ACell updateRefs(IRefFunction func) {
        ACell newData = this.data.updateRefs(func);
        if (newData == this.data) {
            return this;
        }
        DenseRecord dr = new DenseRecord(this.tag, (AVector<ACell>)newData);
        dr.attachEncoding(this.getEncoding());
        return dr;
    }

    @Override
    public AVector<ACell> values() {
        return this.data;
    }

    @Override
    public ACell get(Keyword key) {
        return null;
    }

    @Override
    public RecordFormat getFormat() {
        return null;
    }

    @Override
    public MapEntry<CVMLong, ACell> entryAt(long i) {
        if (i < 0L || i >= this.count) {
            return null;
        }
        return MapEntry.create(CVMLong.create(i), this.data.get(i));
    }

    @Override
    public AVector<CVMLong> getKeys() {
        return null;
    }

    @Override
    public Set<CVMLong> keySet() {
        return Sets.empty();
    }

    @Override
    public ACell get(ACell key) {
        return null;
    }
}

