/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.Panic;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class BlobTree
extends ABlob {
    public static final int BIT_SHIFT_PER_LEVEL = 4;
    public static final int FANOUT = 16;
    private final Ref<ABlob>[] children;
    private final int shift;
    public static final int MAX_ENCODING_SIZE = 645;

    private BlobTree(Ref<ABlob>[] children, int shift, long count) {
        super(count);
        this.children = children;
        this.shift = shift;
    }

    public static BlobTree create(ABlob blob) {
        if (blob instanceof BlobTree) {
            return (BlobTree)blob;
        }
        long length = blob.count();
        if (length <= 4096L) {
            throw new IllegalArgumentException("Can't make BlobTree for too small length: " + length);
        }
        int chunks = Utils.checkedInt(BlobTree.calcChunks(length));
        Blob[] blobs = new Blob[chunks];
        for (int i = 0; i < chunks; ++i) {
            int offset = i * 4096;
            long take = Math.min(4096L, length - (long)offset);
            blobs[i] = blob.slice(offset, (long)offset + take).toFlatBlob();
        }
        return BlobTree.create(blobs);
    }

    public static BlobTree createWithChildren(ABlob[] children) {
        int n = children.length;
        long count = 0L;
        Ref[] cs = new Ref[n];
        for (int i = 0; i < n; ++i) {
            ABlob child = children[i];
            cs[i] = child.getRef();
            count += child.count();
        }
        int shift = BlobTree.calcShift(BlobTree.calcChunks(count));
        return new BlobTree(cs, shift, count);
    }

    static BlobTree create(Blob ... blobs) {
        return BlobTree.create(blobs, 0, blobs.length);
    }

    static int calcShift(long chunkCount) {
        int shift = 0;
        while (16L << shift < chunkCount) {
            shift += 4;
        }
        return shift;
    }

    public static long calcChunks(long length) {
        return (length - 1L >> 12) + 1L;
    }

    private static BlobTree createSmall(Blob[] blobs, int offset, int chunkCount) {
        long length = 0L;
        if (chunkCount < 2) {
            throw new IllegalArgumentException("Cannot create BlobTree without at least 2 Blobs");
        }
        Ref[] children = new Ref[chunkCount];
        for (int i = 0; i < chunkCount; ++i) {
            Ref child;
            Blob blob = blobs[offset + i];
            long childLength = blob.count();
            if (childLength > 4096L) {
                throw new IllegalArgumentException("BlobTree chunk too large: " + childLength);
            }
            if (i < chunkCount - 1 && childLength != 4096L) {
                throw new IllegalArgumentException("Illegal internediate chunk size: " + childLength);
            }
            children[i] = child = blob.getRef();
            length += childLength;
        }
        return new BlobTree(children, 0, length);
    }

    private static BlobTree create(Blob[] blobs, int offset, int chunkCount) {
        if (chunkCount <= 16) {
            return BlobTree.createSmall(blobs, offset, chunkCount);
        }
        int shift = BlobTree.calcShift(chunkCount);
        int childChunks = 1 << shift;
        int numChildren = (chunkCount - 1 >> shift) + 1;
        Ref[] children = new Ref[numChildren];
        long length = 0L;
        for (int i = 0; i < numChildren; ++i) {
            int childOffset = i * childChunks;
            int chunks = Math.min(childChunks, chunkCount - childOffset);
            ABlob child = chunks == 1 ? blobs[offset + childOffset] : BlobTree.create(blobs, offset + childOffset, chunks);
            children[i] = child.getRef();
            length += child.count();
        }
        return new BlobTree(children, shift, length);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public int getBytes(byte[] dest, int pos) {
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            pos = this.getChild(i).getBytes(dest, pos);
        }
        return pos;
    }

    @Override
    public ABlob slice(long start, long end) {
        int cilast;
        if (start < 0L) {
            return null;
        }
        if (end > this.count) {
            return null;
        }
        long length = end - start;
        if (length < 0L) {
            return null;
        }
        if (start == end) {
            return Blob.EMPTY;
        }
        if (start == 0L && length == this.count) {
            return this;
        }
        long csize = this.childLength();
        int ci = (int)(start / csize);
        if (ci == (cilast = (int)((end - 1L) / csize))) {
            long coffset = (long)ci * csize;
            return this.getChild(ci).slice(start - coffset, end - coffset);
        }
        BlobBuilder bb = new BlobBuilder();
        for (int i = ci; i <= cilast; ++i) {
            ABlob child = this.getChild(i);
            long coff = (long)i * csize;
            long cstart = Math.max(start - coff, 0L);
            long cend = Math.min(end - coff, child.count());
            bb.append(child.slice(cstart, cend));
        }
        return bb.toBlob();
    }

    private ABlob getChild(int childIndex) {
        return this.children[childIndex].getValue();
    }

    private ABlob lastChild() {
        return this.children[this.children.length - 1].getValue();
    }

    @Override
    public Blob toFlatBlob() {
        int len = Utils.checkedInt(this.count());
        byte[] data = new byte[len];
        this.getBytes(data, 0);
        return Blob.wrap(data);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            this.getChild(i).updateDigest(digest);
        }
    }

    @Override
    public byte byteAtUnchecked(long i) {
        long childLength = this.childLength();
        int ci = (int)(i >> this.shift + 12);
        return this.getChild(ci).byteAtUnchecked(i - (long)ci * childLength);
    }

    private long childLength() {
        return 1L << this.shift + 12;
    }

    @Override
    public boolean equals(ABlob a) {
        if (a.count() != this.count) {
            return false;
        }
        BlobTree other = (BlobTree)a.getCanonical();
        return this.equals(other);
    }

    public boolean equals(BlobTree b) {
        if (b == this) {
            return true;
        }
        if (b.count != this.count) {
            return false;
        }
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            if (this.children[i].equals(b.children[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsBytes(byte[] bytes, long byteOffset) {
        long clen = this.childLength();
        for (int i = 0; i < this.children.length; ++i) {
            if (this.getChild(i).equalsBytes(bytes, byteOffset + (long)i * clen)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsBytes(ABlob b) {
        if (b.count() != this.count) {
            return false;
        }
        if (b instanceof BlobTree) {
            BlobTree bb = (BlobTree)b;
            return this.equals(bb);
        }
        assert (!b.isCanonical()) : "Canonical Blob of this size should be a BlobTree?";
        if (b instanceof AArrayBlob) {
            AArrayBlob ab = (AArrayBlob)b;
            return this.equalsBytes(ab.getInternalArray(), ab.getInternalOffset());
        }
        return this.equalsBytes((ABlob)b.getCanonical());
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLQCount(bs, pos, this.count);
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            pos = this.children[i].encode(bs, pos);
        }
        return pos;
    }

    public static BlobTree read(long count, Blob src, int pos) throws BadFormatException {
        int headerLength = 1 + Format.getVLQCountLength(count);
        long chunks = BlobTree.calcChunks(count);
        int shift = BlobTree.calcShift(chunks);
        int numChildren = Utils.checkedInt((chunks - 1L >> shift) + 1L);
        Ref[] children = new Ref[numChildren];
        int rpos = pos + headerLength;
        for (int i = 0; i < numChildren; ++i) {
            Ref ref = Format.readRef(src, rpos);
            if (ref == Ref.NULL_VALUE) {
                throw new BadFormatException("Null BlobTree child");
            }
            children[i] = ref;
            rpos = (int)((long)rpos + ref.getEncodingLength());
        }
        BlobTree result = new BlobTree(children, shift, count);
        Blob enc = src.slice(pos, rpos);
        result.attachEncoding(enc);
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return 11 + 33 * this.children.length;
    }

    @Override
    public ABlob append(ABlob d) {
        long take;
        BlobTree acc = this;
        long dlen = d.count();
        for (long off = 0L; off < dlen; off += take) {
            BlobTree nextLevel;
            long csize = acc.childLength();
            ABlob lastChild = acc.lastChild();
            long clen = lastChild.count();
            if (clen != csize) {
                long spare = csize - clen;
                long take2 = Math.min(spare, dlen);
                ABlob newChild = lastChild.append(d.slice(0L, take2));
                acc = acc.withChild(acc.children.length - 1, newChild);
                off += take2;
            }
            if (off >= dlen) {
                return acc;
            }
            if (!acc.isFullyPacked()) {
                for (int i = acc.childCount(); i < 16; ++i) {
                    long take3 = Math.min(csize, dlen - off);
                    ABlob newChild = d.slice(off, off + take3);
                    acc = acc.appendChild(newChild);
                    if ((off += take3) < dlen) continue;
                    return acc;
                }
            }
            take = Math.min(acc.count(), dlen - off);
            acc = nextLevel = BlobTree.createWithChildren(new ABlob[]{acc, d.slice(off, off + take)});
        }
        return acc;
    }

    private int childCount() {
        return this.children.length;
    }

    @Override
    public boolean isFullyPacked() {
        return this.count == this.childLength() * 16L;
    }

    @Override
    public Blob getChunk(long chunkIndex) {
        long childSize = 1 << this.shift;
        int child = Utils.checkedInt(chunkIndex >> this.shift);
        return this.getChild(child).getChunk(chunkIndex - (long)child * childSize);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        int n = this.children.length;
        if (n < 2 | n > 16) {
            throw new InvalidDataException("Illegal number of BlobTree children: " + n, this);
        }
    }

    @Override
    public void validateStructure() throws InvalidDataException {
        long clen = this.childLength();
        long total = 0L;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            ABlob child = this.getChild(i);
            long cl = child.count();
            total += cl;
            if (i == n - 1) {
                if (cl <= clen) continue;
                throw new InvalidDataException("Illegal last child length: " + cl + " expected less than or equal to " + clen, this);
            }
            if (cl == clen) continue;
            throw new InvalidDataException("Illegal child length: " + cl + " expected " + clen, this);
        }
        if (total != this.count) {
            throw new InvalidDataException("Incorrect total child count: " + total, this);
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.toFlatBlob().getByteBuffer();
    }

    @Override
    public boolean appendHex(BlobBuilder bb, long length) {
        for (int i = 0; i < this.children.length; ++i) {
            ABlob child = this.children[i].getValue();
            if (!child.appendHex(bb, length)) {
                return false;
            }
            if ((length -= child.count() * 2L) >= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public long hexMatch(ABlobLike<?> b) {
        if (b instanceof ABlob) {
            return this.commonHexPrefixLength((ABlob)b);
        }
        return b.hexMatch(this);
    }

    public long commonHexPrefixLength(ABlob b) {
        long cpl = 0L;
        long DIGITS_PER_CHUNK = 8192L;
        long maxChunk = (Math.min(this.count(), b.count()) - 1L) / 4096L;
        for (long i = 0L; i <= maxChunk; ++i) {
            long cl = this.getChunk(i).hexMatch(b.getChunk(i));
            if (cl < DIGITS_PER_CHUNK) {
                return cpl + cl;
            }
            cpl += DIGITS_PER_CHUNK;
        }
        return cpl;
    }

    @Override
    public long hexMatch(ABlobLike<?> b, long start, long length) {
        long HEX_CHUNK_LENGTH = 8192L;
        long end = start + length;
        long endChunk = (end - 1L) / HEX_CHUNK_LENGTH;
        for (long ci = start / HEX_CHUNK_LENGTH; ci < endChunk; ++ci) {
            long cpos = ci * HEX_CHUNK_LENGTH;
            long cs = Math.max(0L, start - cpos);
            long ce = Math.min(HEX_CHUNK_LENGTH, end - cpos);
            long clen = ce - cs;
            long match = this.getChunk(ci).hexMatch(b.toBlob().getChunk(ci), cs, clen);
            if (match >= clen) continue;
            return cpos + cs + match;
        }
        return length;
    }

    @Override
    public long longValue() {
        return this.slice(this.count - 8L, this.count).longValue();
    }

    @Override
    public int getRefCount() {
        return this.children.length;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.children[i];
    }

    @Override
    public BlobTree updateRefs(IRefFunction func) {
        Ref<ABlob>[] newChildren = Ref.updateRefs(this.children, func);
        return this.withChildren(newChildren);
    }

    private BlobTree withChildren(Ref<ABlob>[] newChildren) {
        if (this.children == newChildren) {
            return this;
        }
        return new BlobTree(newChildren, this.shift, this.count);
    }

    private BlobTree withChild(int i, ABlob newChild) {
        ABlob oldChild = this.children[i].getValue();
        if (oldChild == newChild) {
            return this;
        }
        Ref[] newChildren = (Ref[])this.children.clone();
        newChildren[i] = newChild.getRef();
        long newCount = this.count;
        if (i == this.children.length - 1) {
            newCount += newChild.count() - oldChild.count();
        }
        return new BlobTree(newChildren, this.shift, newCount);
    }

    private BlobTree appendChild(ABlob newChild) {
        int ch = this.children.length;
        if (ch >= 16) {
            throw new Panic("Trying to add a child beyond allowable fanout!");
        }
        Ref[] newChildren = new Ref[ch + 1];
        System.arraycopy(this.children, 0, newChildren, 0, ch);
        newChildren[ch] = newChild.getRef();
        long newCount = (long)ch * this.childLength() + newChild.count();
        return new BlobTree(newChildren, this.shift, newCount);
    }

    public static long childSize(long length) {
        long chunks = BlobTree.calcChunks(length);
        int shift = BlobTree.calcShift(chunks);
        return 4096L << shift;
    }

    public static int childCount(long length) {
        return Utils.checkedInt(1L + (length - 1L) / BlobTree.childSize(length));
    }

    @Override
    public ABlob toCanonical() {
        return this;
    }

    @Override
    public int toByteBuffer(long offset, long count, ByteBuffer dest) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count");
        }
        if (offset < 0L || offset + count > this.count) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        int childcount = this.childCount();
        long csize = this.childLength();
        for (int i = 0; i < childcount; ++i) {
            if (offset < csize) {
                long n = Math.min(count, csize - offset);
                if (n > 0L) {
                    result += this.getChild(i).toByteBuffer(offset, n, dest);
                }
                count -= n;
                offset = 0L;
            } else {
                offset -= csize;
            }
            if (count <= 0L) break;
        }
        return result;
    }
}

