/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ACountable;
import convex.core.data.AList;
import convex.core.data.AVector;
import convex.core.data.IAssociative;
import convex.core.data.Ref;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMLong;
import convex.core.data.util.SequenceSpliterator;
import convex.core.lang.RT;
import convex.core.util.ErrorMessages;
import convex.core.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class ASequence<T extends ACell>
extends ACollection<T>
implements List<T>,
IAssociative<CVMLong, T> {
    public ASequence(long count) {
        super(count);
    }

    @Override
    public boolean contains(Object o) {
        if (o != null && !(o instanceof ACell)) {
            return false;
        }
        return this.longIndexOf((ACell)o) >= 0L;
    }

    @Override
    public int indexOf(Object o) {
        if (o != null && !(o instanceof ACell)) {
            return -1;
        }
        long pos = this.longIndexOf((ACell)o);
        if (pos < 0L) {
            return -1;
        }
        return Utils.checkedInt(pos);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o != null && !(o instanceof ACell)) {
            return -1;
        }
        long pos = this.longLastIndexOf((ACell)o);
        if (pos < 0L) {
            return -1;
        }
        return Utils.checkedInt(pos);
    }

    public abstract long longIndexOf(ACell var1);

    public abstract long longLastIndexOf(ACell var1);

    @Override
    public abstract <R extends ACell> ASequence<R> map(Function<? super T, ? extends R> var1);

    @Override
    public abstract void forEach(Consumer<? super T> var1);

    public abstract void visitElementRefs(Consumer<Ref<T>> var1);

    public <R extends ACell> ASequence<R> flatMap(Function<? super T, ? extends ASequence<R>> mapper) {
        ACollection vals = this.map(mapper);
        ASequence<T> result = this.empty();
        for (ASequence seq : vals) {
            result = result.concat(seq);
        }
        return result;
    }

    public abstract ASequence<T> concat(ASequence<? extends T> var1);

    @Override
    public final boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    public abstract ASequence<T> next();

    @Override
    public abstract ASequence<T> empty();

    @Override
    public T get(int index) {
        return this.get((long)index);
    }

    @Override
    public abstract T get(long var1);

    public T get(ACell key) {
        if (key instanceof AInteger) {
            CVMLong longix = RT.ensureLong(key);
            if (longix == null) {
                return null;
            }
            long ix = longix.longValue();
            if (ix >= 0L && ix < this.count()) {
                return this.get(ix);
            }
        }
        return null;
    }

    @Override
    public ACell get(ACell key, ACell notFound) {
        long ix;
        if (key instanceof CVMLong && (ix = ((CVMLong)key).longValue()) >= 0L && ix < this.count()) {
            return this.get(ix);
        }
        return notFound;
    }

    @Override
    public boolean containsKey(ACell key) {
        long ix;
        CVMLong index = RT.ensureLong(key);
        return index != null && (ix = index.longValue()) >= 0L && ix < this.count();
    }

    @Override
    public abstract Ref<T> getElementRef(long var1);

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public ASequence<T> assoc(ACell key, ACell value) {
        CVMLong ix = RT.ensureLong(key);
        if (ix == null) {
            return null;
        }
        return this.assoc(ix.longValue(), value);
    }

    public abstract ASequence<T> assoc(long var1, T var3);

    protected boolean checkRange(long start, long end) {
        if (start < 0L) {
            return false;
        }
        if (start > end) {
            return false;
        }
        return end <= this.count();
    }

    @Override
    public final void add(int index, T element) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public final T remove(int index) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public ACell[] toCellArray() {
        int n = Utils.checkedInt(this.count());
        ACell[] cells = new ACell[n];
        for (int i = 0; i < n; ++i) {
            cells[i] = this.get(i);
        }
        return cells;
    }

    @Override
    public abstract ASequence<T> conj(ACell var1);

    @Override
    public abstract ASequence<T> slice(long var1, long var3);

    public abstract AList<T> cons(T var1);

    public abstract AVector<T> subVector(long var1, long var3);

    @Override
    public final List<T> subList(int fromIndex, int toIndex) {
        long start = fromIndex;
        long end = toIndex;
        ACountable result = this.slice(start, end);
        if (result == null) {
            throw new IndexOutOfBoundsException(ErrorMessages.badRange(start, end));
        }
        return result;
    }

    protected abstract ListIterator<T> listIterator(long var1);

    @Override
    public Spliterator<T> spliterator() {
        return this.spliterator(0L, this.count);
    }

    public Spliterator<T> spliterator(long start, long end) {
        return new SequenceSpliterator(this, start, end);
    }

    public abstract ASequence<T> reverse();
}

