/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.cpos.Block;
import convex.core.cvm.RecordFormat;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.lang.RT;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public abstract class ARecord<K extends ACell, V extends ACell>
extends AMap<K, V> {
    public static final ARecord<Keyword, ACell> DEFAULT_VALUE = Block.create(0L, Vectors.empty());
    protected final byte tag;

    protected ARecord(byte tag, long n) {
        super(n);
        this.tag = tag;
    }

    @Override
    public byte getTag() {
        return this.tag;
    }

    @Override
    public AType getType() {
        return Types.RECORD;
    }

    @Override
    public int estimatedEncodingSize() {
        return (int)(140L * this.count);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    protected ARecord<K, V> toCanonical() {
        return this;
    }

    @Override
    public abstract AVector<K> getKeys();

    @Override
    public abstract AVector<V> values();

    @Override
    public abstract V get(ACell var1);

    public abstract ACell get(Keyword var1);

    public ACell[] getValuesArray() {
        return ((ASequence)this.values()).toCellArray();
    }

    @Override
    public boolean containsKey(ACell key) {
        RecordFormat format = this.getFormat();
        if (format == null) {
            return false;
        }
        return format.containsKey(key);
    }

    @Override
    public boolean containsValue(ACell value) {
        return ((ASequence)this.values()).contains(value);
    }

    @Override
    public abstract Set<K> keySet();

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.toHashMap().entrySet();
    }

    @Override
    public AMap<K, V> assoc(ACell key, ACell value) {
        return this.toHashMap().assoc(key, value);
    }

    public AMap<K, V> dissoc(Keyword key) {
        if (!this.containsKey(key)) {
            return this;
        }
        return this.toHashMap().dissoc(key);
    }

    @Override
    public final AMap<K, V> dissoc(ACell key) {
        if (!this.containsKey(key)) {
            return this;
        }
        return this.toHashMap().dissoc(key);
    }

    @Override
    public MapEntry<K, V> getKeyRefEntry(Ref<ACell> keyRef) {
        return this.getEntry(keyRef.getValue());
    }

    @Override
    protected void accumulateEntries(Collection<Map.Entry<K, V>> h) {
        for (long i = 0L; i < this.count; ++i) {
            h.add(this.entryAt(i));
        }
    }

    @Override
    protected void accumulateKeySet(Set<K> h) {
        AVector<K> keys = this.getKeys();
        for (long i = 0L; i < this.count; ++i) {
            h.add(keys.get(i));
        }
    }

    @Override
    protected void accumulateValues(List<V> al) {
        this.toHashMap().accumulateValues(al);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AMap<K, V> assocEntry(MapEntry<K, V> e) {
        return this.assoc((ACell)e.getKey(), (ACell)e.getValue());
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        AString tag = this.getType().getTag();
        if (tag != null) {
            sb.append(tag);
            sb.append(' ');
        }
        sb.append('{');
        long n = this.count();
        RecordFormat format = this.getFormat();
        ACell[] vs = this.getValuesArray();
        for (long i = 0L; i < n; ++i) {
            Keyword k = format.getKey(i);
            if (!RT.print(sb, k, limit)) {
                return false;
            }
            sb.append(' ');
            ACell v = vs[(int)i];
            if (!RT.print(sb, v, limit)) {
                return false;
            }
            if (i >= n - 1L) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.check(limit);
    }

    @Override
    public MapEntry<K, V> getEntry(ACell k) {
        V v = this.get(k);
        if (v == null && !this.containsKey(k)) {
            return null;
        }
        return MapEntry.create(k, v);
    }

    @Override
    public V get(ACell key, ACell notFound) {
        V v = this.get(key);
        if (v == null && !this.containsKey(key)) {
            return (V)notFound;
        }
        return v;
    }

    @Override
    public <R> R reduceValues(BiFunction<? super R, ? super V, ? extends R> func, R initial) {
        int i = 0;
        while ((long)i < this.count) {
            initial = func.apply(initial, this.entryAt(i).getValue());
            ++i;
        }
        return initial;
    }

    @Override
    public <R> R reduceEntries(BiFunction<? super R, MapEntry<K, V>, ? extends R> func, R initial) {
        int i = 0;
        while ((long)i < this.count) {
            initial = func.apply(initial, this.entryAt(i));
            ++i;
        }
        return initial;
    }

    protected AHashMap<K, V> toHashMap() {
        Object m = Maps.empty();
        int i = 0;
        while ((long)i < this.count) {
            m = ((AHashMap)m).assocEntry(this.entryAt(i));
            ++i;
        }
        return m;
    }

    @Override
    protected MapEntry<K, V> getEntryByHash(Hash hash) {
        return this.toHashMap().getEntryByHash(hash);
    }

    @Override
    public AMap<K, V> empty() {
        return Maps.empty();
    }

    public abstract RecordFormat getFormat();
}

