/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.transactions;

import convex.core.Coin;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Keyword;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;

public class Transfer
extends ATransaction {
    protected final Address target;
    protected final long amount;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.ORIGIN, Keywords.SEQUENCE, Keywords.TARGET, Keywords.AMOUNT};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);

    protected Transfer(Address origin, long sequence, Address target, long amount) {
        super((byte)-47, FORMAT, Vectors.create(origin, CVMLong.create(sequence), target, CVMLong.create(amount)));
        this.target = target;
        this.amount = amount;
    }

    protected Transfer(AVector<ACell> values) {
        super((byte)-47, FORMAT, values);
        this.target = RT.ensureAddress((ACell)values.get(2));
        this.amount = RT.ensureLong((ACell)values.get(3)).longValue();
    }

    public static Transfer create(Address origin, long sequence, Address target, long amount) {
        if (!Coin.isValidAmount(amount)) {
            throw new IllegalArgumentException("Illegal Convex Coin amount");
        }
        return new Transfer(origin, sequence, target, amount);
    }

    public static ATransaction read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        if (values.count() != (long)KEYS.length) {
            throw new BadFormatException("Wrong number of record values");
        }
        Transfer result = new Transfer(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public Context apply(Context ctx) {
        if (!(ctx = ctx.consumeJuice(200L)).isExceptional()) {
            ctx = ctx.transfer(this.target, this.amount);
        }
        return ctx;
    }

    @Override
    public int estimatedEncodingSize() {
        return 56;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (!Coin.isValidAmount(this.amount)) {
            throw new InvalidDataException("Invalid amount", this);
        }
        if (this.target == null) {
            throw new InvalidDataException("Null Address", this);
        }
    }

    public Address getTarget() {
        return this.target;
    }

    public long getAmount() {
        return this.amount;
    }

    @Override
    public Transfer withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Transfer.create(this.origin, newSequence, this.target, this.amount);
    }

    @Override
    public Transfer withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return Transfer.create(newAddress, this.sequence, this.target, this.amount);
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.TARGET.equals(key)) {
            return RT.ensureAddress((ACell)this.values.get(2));
        }
        if (Keywords.AMOUNT.equals(key)) {
            return RT.ensureLong((ACell)this.values.get(3));
        }
        return super.get(key);
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Transfer(newValues);
    }
}

