/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.transactions;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Keyword;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;

public class Multi
extends ATransaction {
    protected AVector<ATransaction> txs;
    private final int mode;
    public static final int MODE_ANY = 0;
    public static final int MODE_ALL = 1;
    public static final int MODE_FIRST = 2;
    public static final int MODE_UNTIL = 3;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.ORIGIN, Keywords.SEQUENCE, Keywords.MODE, Keywords.TXS};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);
    protected static final int IX_MODE = 2;
    protected static final int IX_TXS = 3;

    protected Multi(Address origin, long sequence, int mode, AVector<ATransaction> txs) {
        super((byte)-45, FORMAT, Vectors.create(origin, CVMLong.create(sequence), CVMLong.create(mode), txs));
        this.mode = mode;
        this.txs = txs;
    }

    protected Multi(AVector<ACell> values) {
        super((byte)-45, FORMAT, values);
        this.mode = Utils.checkedInt(RT.ensureLong((ACell)values.get(2)).longValue());
        if (!Multi.isValidMode(this.mode)) {
            throw new IllegalArgumentException("Bad mode");
        }
    }

    public static Multi create(Address origin, long sequence, int mode, ATransaction ... txs) {
        AVector<ATransaction> v = Vectors.create((ACell[])txs);
        return new Multi(origin, sequence, mode, v);
    }

    public int getMode() {
        return this.mode;
    }

    public static Multi read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        if (values.count() != (long)KEYS.length) {
            throw new BadFormatException("Wrong number of record values");
        }
        Multi result = new Multi(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    private static boolean isValidMode(long mode) {
        return mode >= 0L && mode <= 3L;
    }

    @Override
    public Context apply(Context ctx) {
        Context rctx;
        Context ictx = ctx.fork();
        AVector<ATransaction> ts = this.getTransactions();
        long n = ts.count();
        ASequence rs = Vectors.empty();
        int i = 0;
        while ((long)i < n) {
            ATransaction t = (ATransaction)ts.get(i);
            ctx = this.applySubTransaction(ctx, t);
            Result r = Result.fromContext(ctx);
            rs = rs.conj(r);
            if (r.isError() ? this.mode == 3 || this.mode == 1 : this.mode == 2) break;
            ++i;
        }
        if (ctx.isError() && this.mode == 1) {
            ctx = ictx.handleStateResults(ctx, true);
            rctx = ctx.withError(ErrorCodes.CHILD, rs);
        } else {
            rctx = ctx.withResult(rs);
        }
        return rctx;
    }

    private AVector<ATransaction> getTransactions() {
        if (this.txs == null) {
            this.txs = RT.ensureVector((ACell)this.values.get(3));
        }
        return this.txs;
    }

    private Context applySubTransaction(Context ctx, ATransaction t) {
        Address torigin = t.origin;
        if (!this.origin.equals(torigin)) {
            AccountStatus as = ctx.getAccountStatus(torigin);
            if (as == null) {
                return ctx.withError(ErrorCodes.NOBODY, "Child transaction origin account does not exist");
            }
            ACell cont = as.getController();
            if (cont == null || !this.origin.equals(cont)) {
                return ctx.withError(ErrorCodes.TRUST, "Account control not available");
            }
        }
        Context childContext = ctx.forkWithAddress(torigin);
        childContext = t.apply(childContext);
        ctx = ctx.handleStateResults(childContext, false);
        return ctx;
    }

    @Override
    public ATransaction withSequence(long newSequence) {
        if (this.sequence == newSequence) {
            return this;
        }
        return new Multi(this.origin, newSequence, this.mode, this.txs);
    }

    @Override
    public ATransaction withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return new Multi(newAddress, this.sequence, this.mode, this.txs);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.mode < 0 || this.mode > 3) {
            throw new InvalidDataException("Illegal mode: " + this.mode, this);
        }
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.MODE.equals(key)) {
            return this.values.get(2);
        }
        if (Keywords.TXS.equals(key)) {
            return this.getTransactions();
        }
        return super.get(key);
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Multi(this.values);
    }
}

