/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.Ops;
import convex.core.cvm.State;
import convex.core.cvm.ops.ACodedOp;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.data.prim.ByteFlag;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;

public class Query<T extends ACell>
extends ACodedOp<T, ACell, AVector<AOp<ACell>>> {
    private static final Ref<ACell> CODE = new ByteFlag(-69).getRef();

    protected Query(Ref<ACell> code, Ref<AVector<AOp<ACell>>> ops) {
        super((byte)-64, code, ops);
    }

    protected Query(Ref<AVector<AOp<ACell>>> ops) {
        this(CODE, ops);
    }

    public static <T extends ACell> Query<T> create(AOp<?> ... ops) {
        return new Query<T>(Vectors.create((ACell[])ops).getRef());
    }

    @Override
    protected Query<T> rebuild(Ref<ACell> newCode, Ref<AVector<AOp<ACell>>> newOps) {
        if (this.code == newCode && this.value == newOps) {
            return this;
        }
        return new Query<T>(newCode, newOps);
    }

    public static <T extends ACell> Query<T> create(ASequence<AOp<ACell>> ops) {
        return new Query<T>(ops.toVector().getRef());
    }

    @Override
    public Context execute(Context context) {
        AOp op;
        State savedState = context.getState();
        AVector ops = (AVector)this.value.getValue();
        int n = ops.size();
        if (n == 0) {
            return context.withResult(10L, null);
        }
        Context ctx = context.consumeJuice(10L);
        if (ctx.isExceptional()) {
            return ctx;
        }
        AVector<ACell> savedBindings = context.getLocalBindings();
        for (int i = 0; i < n && !(ctx = ctx.execute(op = Ops.castOp((ACell)ops.get(i)))).isExceptional(); ++i) {
        }
        ctx = ctx.withState(savedState);
        ctx = ctx.withLocalBindings(savedBindings);
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        AVector ops = (AVector)this.value.getValue();
        bb.append("(query");
        int len = ops.size();
        for (int i = 0; i < len; ++i) {
            bb.append(' ');
            if (RT.print(bb, (ACell)ops.get(i), limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    public static <T extends ACell> Query<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        Ref<AVector<AOp<ACell>>> ops = Format.readRef(b, epos);
        epos = (int)((long)epos + ops.getEncodingLength());
        Query<T> result = new Query<T>(CODE, ops);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }
}

