/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.ErrorCodes;
import convex.core.cvm.AOp;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.ops.ACodedOp;
import convex.core.cvm.ops.Constant;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.Symbol;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;

public class Lookup<T extends ACell>
extends ACodedOp<T, AOp<Address>, Symbol> {
    private Lookup(Ref<AOp<Address>> address, Ref<Symbol> symbol) {
        super((byte)-63, address, symbol);
    }

    public static <T extends ACell> Lookup<T> create(AOp<Address> address, Symbol form) {
        return new Lookup<T>(Ref.get(address), form.getRef());
    }

    public static <T extends ACell> Lookup<T> create(AOp<Address> address, String name) {
        return Lookup.create(address, Symbol.create(name));
    }

    public static <T extends ACell> Lookup<T> create(Address addr, Symbol sym) {
        return Lookup.create(Constant.of(addr), sym);
    }

    public static <T extends ACell> Lookup<T> create(Symbol symbol) {
        return Lookup.create((AOp<Address>)null, symbol);
    }

    public static <T extends ACell> Lookup<T> create(String name) {
        return Lookup.create(Symbol.create(name));
    }

    @Override
    public Context execute(Context context) {
        Context rctx = context;
        Address namespaceAddress = null;
        AOp address = (AOp)this.code.getValue();
        if (address != null) {
            if ((rctx = rctx.execute(address)).isExceptional()) {
                return rctx;
            }
            Object maybeAddress = rctx.getResult();
            namespaceAddress = RT.ensureAddress(maybeAddress);
            if (namespaceAddress == null) {
                return rctx.withError(ErrorCodes.CAST, "Lookup requires Address but got: " + String.valueOf(RT.getType(maybeAddress)));
            }
        }
        namespaceAddress = address == null ? context.getAddress() : namespaceAddress;
        Symbol symbol = (Symbol)this.value.getValue();
        return rctx.lookupDynamic(namespaceAddress, symbol).consumeJuice(40L);
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        AOp address = (AOp)this.code.getValue();
        if (address != null) {
            if (!address.print(bb, limit)) {
                return false;
            }
            bb.append('/');
        }
        Symbol symbol = (Symbol)this.value.getValue();
        return symbol.print(bb, limit);
    }

    public static <T extends ACell> Lookup<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Ref<AOp<Address>> addr = Format.readRef(b, epos);
        epos = (int)((long)epos + addr.getEncodingLength());
        Ref<Symbol> sym = Format.readRef(b, epos);
        epos = (int)((long)epos + sym.getEncodingLength());
        Lookup<T> result = new Lookup<T>(addr, sym);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    public AOp<Address> getAddress() {
        return (AOp)this.code.getValue();
    }

    @Override
    protected AOp<T> rebuild(Ref<AOp<Address>> newCode, Ref<Symbol> newValue) {
        if (this.code == newCode && this.value == newValue) {
            return this;
        }
        return new Lookup<T>(newCode, newValue);
    }
}

