/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.exception.RecurValue;
import convex.core.cvm.ops.ACodedOp;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;

public class Let<T extends ACell>
extends ACodedOp<T, AVector<ACell>, AVector<AOp<ACell>>> {
    protected final boolean isLoop;

    protected Let(byte tag, Ref<AVector<ACell>> syms, Ref<AVector<AOp<ACell>>> ops) {
        super(tag, syms, ops);
        this.isLoop = tag == -61;
    }

    public static <T extends ACell> Let<T> create(AVector<ACell> syms, AVector<AOp<ACell>> ops, boolean isLoop) {
        return new Let<T>(isLoop ? (byte)-61 : -62, syms.getRef(), ops.getRef());
    }

    @Override
    protected Let<T> rebuild(Ref<AVector<ACell>> newSymbols, Ref<AVector<AOp<ACell>>> newOps) {
        if (this.code == newSymbols && this.value == newOps) {
            return this;
        }
        return new Let<T>(this.tag, newSymbols, newOps);
    }

    @Override
    public Context execute(Context context) {
        Context ctx = context.consumeJuice(30L);
        if (ctx.isExceptional()) {
            return ctx;
        }
        AVector symbols = (AVector)this.code.getValue();
        int bindingCount = symbols.size();
        AVector ops = (AVector)this.value.getValue();
        AVector<ACell> savedEnv = ctx.getLocalBindings();
        for (int i = 0; i < bindingCount; ++i) {
            AOp op = (AOp)ops.get(i);
            if (!(ctx = ctx.executeLocalBinding((ACell)symbols.get(i), op)).isExceptional()) continue;
            return ctx.withLocalBindings(savedEnv);
        }
        ctx = this.executeBody(ctx);
        if (this.isLoop && ctx.isExceptional()) {
            Object o = ctx.getExceptional();
            while (o instanceof RecurValue) {
                RecurValue rv = (RecurValue)o;
                ACell[] newArgs = rv.getValues();
                if (newArgs.length != bindingCount) {
                    String message = "Expected " + bindingCount + " value(s) for recur but got: " + newArgs.length;
                    ctx = ctx.withArityError(message);
                    break;
                }
                ctx = ctx.withLocalBindings(savedEnv);
                if ((ctx = ctx.updateBindings(symbols, newArgs)).isExceptional()) break;
                ctx = this.executeBody(ctx);
                o = ctx.getValue();
            }
        }
        return ctx.withLocalBindings(savedEnv);
    }

    public Context executeBody(Context ctx) {
        AVector ops = (AVector)this.value.getValue();
        int end = ops.size();
        int bindingCount = ((AVector)this.code.getValue()).size();
        if (bindingCount == end) {
            return ctx.withResult(null);
        }
        for (int i = bindingCount; i < end; ++i) {
            if (!(ctx = ctx.execute((AOp)ops.get(i))).isExceptional()) continue;
            return ctx;
        }
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        int i;
        AVector ops = (AVector)this.value.getValue();
        AVector symbols = (AVector)this.code.getValue();
        int bindingCount = symbols.size();
        bb.append(this.isLoop ? "(loop [" : "(let [");
        int len = ops.size();
        for (i = 0; i < bindingCount; ++i) {
            if (i > 0) {
                bb.append(' ');
            }
            if (!RT.print(bb, (ACell)symbols.get(i), limit)) {
                return false;
            }
            bb.append(' ');
            if (!((AOp)ops.get(i)).print(bb, limit)) {
                return false;
            }
            bb.append(' ');
        }
        bb.append("] ");
        for (i = bindingCount; i < len; ++i) {
            bb.append(' ');
            if (((AOp)ops.get(i)).print(bb, limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    public static <T extends ACell> Let<T> read(Blob b, int pos, boolean isLoop) throws BadFormatException {
        int epos = pos + 1;
        byte tag = isLoop ? (byte)-61 : -62;
        Ref<AVector<ACell>> syms = Format.readRef(b, epos);
        epos = (int)((long)epos + syms.getEncodingLength());
        Ref<AVector<AOp<ACell>>> ops = Format.readRef(b, epos);
        epos = (int)((long)epos + ops.getEncodingLength());
        Let<T> result = new Let<T>(tag, syms, ops);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }
}

