/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.exception;

import convex.core.ErrorCodes;
import convex.core.cvm.Address;
import convex.core.cvm.exception.AThrowable;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Keyword;
import convex.core.data.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ErrorValue
extends AThrowable {
    private static final HashMap<Keyword, ErrorValue> defaultErrors = new HashMap();
    private final ACell message;
    private final ArrayList<AString> trace = new ArrayList();
    private ACell log;
    private Address address = null;

    private ErrorValue(ACell code, ACell message) {
        super(code);
        this.message = message;
    }

    private static void addDefaultError(Keyword code, String message) {
        defaultErrors.put(code, ErrorValue.create(code, message));
    }

    public static ErrorValue create(Keyword code) {
        if (defaultErrors.containsKey(code)) {
            return defaultErrors.get(code);
        }
        return new ErrorValue(code, null);
    }

    public static ErrorValue create(Keyword code, AString message) {
        return new ErrorValue(code, message);
    }

    public static ErrorValue createRaw(ACell code, ACell message) {
        return new ErrorValue(code, message);
    }

    public static ErrorValue create(Keyword code, String message) {
        return new ErrorValue(code, Strings.create(message));
    }

    @Override
    public void addTrace(String traceMessage) {
        this.trace.add(Strings.create(traceMessage));
    }

    public void addLog(ACell log) {
        this.log = log;
    }

    @Override
    public boolean isCatchable() {
        return true;
    }

    public void setAddress(Address a) {
        this.address = a;
    }

    public Address getAddress() {
        return this.address;
    }

    @Override
    public ACell getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorValue[" + String.valueOf(this.code) + "]" + (String)(this.message == null ? "" : " : " + String.valueOf(this.message)));
        if (this.trace != null) {
            for (AString o : this.trace) {
                sb.append("\n");
                sb.append(((Object)o).toString());
            }
        }
        return sb.toString();
    }

    public List<AString> getTrace() {
        return this.trace;
    }

    public ACell getLog() {
        return this.log;
    }

    static {
        ErrorValue.addDefaultError(ErrorCodes.ARGUMENT, "Invalid argument");
        ErrorValue.addDefaultError(ErrorCodes.NOBODY, "Account does not exist");
        ErrorValue.addDefaultError(ErrorCodes.FUNDS, "Funds not available");
        ErrorValue.addDefaultError(ErrorCodes.JUICE, "Out of juice");
        ErrorValue.addDefaultError(ErrorCodes.CAST, "Illegal type cast");
        ErrorValue.addDefaultError(ErrorCodes.ASSERT, "Assertion failed");
        ErrorValue.addDefaultError(ErrorCodes.ARITY, "Wrong number of arguments");
        ErrorValue.addDefaultError(ErrorCodes.BOUNDS, "Out of bounds");
        ErrorValue.addDefaultError(ErrorCodes.TODO, "Not implemented");
        ErrorValue.addDefaultError(ErrorCodes.MEMORY, "Out of memory");
    }
}

