/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AExtensionValue;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Strings;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;

public final class Address
extends AExtensionValue {
    public static final int LENGTH = 8;
    private static final int CACHE_SIZE = 256;
    private static Address[] CACHE = new Address[256];
    public static final Address ZERO;
    public static final Address MAX_VALUE;
    public static final int MAX_ENCODING_LENGTH = 10;

    private Address(long value) {
        super(value);
    }

    public static Address create(long number) {
        if (number < 256L) {
            if (number < 0L) {
                return null;
            }
            return CACHE[(int)number];
        }
        return new Address(number);
    }

    public static Address unsafeCreate(long number) {
        return new Address(number);
    }

    public static Address create(ABlobLike<?> b) {
        if (b.count() > 8L) {
            return null;
        }
        return Address.create(b.longValue());
    }

    @Override
    public AType getType() {
        return Types.ADDRESS;
    }

    @Override
    public boolean equals(ACell o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Address) {
            return this.value == ((Address)o).value;
        }
        return Cells.equalsGeneric(this, o);
    }

    public final boolean equals(Address o) {
        if (o == null) {
            return false;
        }
        return this.value == o.value;
    }

    public static Address fromHex(String hexString) {
        if (hexString == null) {
            return null;
        }
        if ((hexString.length() & 1) != 0) {
            return null;
        }
        if (hexString.length() > 16) {
            return null;
        }
        Blob b = Blob.fromHex(hexString);
        if (b == null) {
            return null;
        }
        return Address.create(b.longValue());
    }

    public static Address parse(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("#")) {
            s = s.substring(1);
        }
        if (s.startsWith("0x")) {
            s = s.substring(2);
            return Address.fromHex(s);
        }
        try {
            long l = Long.parseLong(s);
            return Address.create(l);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Address parse(Object o) {
        Number n;
        long l;
        if (o == null) {
            return null;
        }
        if (o instanceof ACell) {
            Address add = RT.castAddress((ACell)o);
            if (add != null) {
                return add;
            }
            o = RT.jvm((ACell)o);
        }
        if (o instanceof String) {
            return Address.parse((String)o);
        }
        if (o instanceof Number && (double)(l = (n = (Number)o).longValue()) == n.doubleValue()) {
            return Address.create(l);
        }
        return null;
    }

    public static Address read(Blob b, int pos) throws BadFormatException {
        long value = Format.readVLQCount(b, pos + 1);
        Address a = Address.create(value);
        if (a == null) {
            throw new BadFormatException("Invalid Address: " + value);
        }
        int epos = pos + 1 + Format.getVLQCountLength(value);
        a.attachEncoding(b.slice(pos, epos));
        return a;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -22;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return Format.writeVLQCount(bs, pos, this.value);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("#");
        sb.appendLongString(this.value);
        return sb.check(limit);
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < 2L) {
            return null;
        }
        return Strings.create(this.toString());
    }

    @Override
    public String toString() {
        return "#" + this.value;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.value < 0L) {
            throw new InvalidDataException("Address must be positive", this);
        }
    }

    @Override
    public Blob toFlatBlob() {
        byte[] bs = new byte[8];
        Utils.writeLong(bs, 0, this.value);
        return Blob.wrap(bs);
    }

    @Override
    public byte getTag() {
        return -22;
    }

    @Override
    public Address toCanonical() {
        return this;
    }

    public Address offset(long offset) {
        return Address.create(this.value + offset);
    }

    @Override
    public final byte byteAt(long i) {
        Address.checkIndex(i);
        return (byte)Utils.longByteAt(this.value, i);
    }

    @Override
    public final byte byteAtUnchecked(long i) {
        return (byte)Utils.longByteAt(this.value, i);
    }

    @Override
    public final int getBytes(byte[] bs, int pos) {
        pos = Utils.writeLong(bs, pos, this.value);
        return pos;
    }

    @Override
    public boolean equalsBytes(ABlob b) {
        if (b.count() != 8L) {
            return false;
        }
        return b.longValue() == this.value;
    }

    @Override
    protected int compareTo(long bvalue) {
        return Long.compareUnsigned(this.value, bvalue);
    }

    @Override
    public boolean isCVMValue() {
        return true;
    }

    @Override
    public CVMLong get(long i) {
        Address.checkIndex(i);
        return CVMLong.create(Utils.longByteAt(this.value, i));
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Address.CACHE[i] = new Address(i);
        }
        ZERO = CACHE[0];
        MAX_VALUE = Address.create(Long.MAX_VALUE);
    }
}

