/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.BIP39;
import convex.core.data.Blob;
import convex.core.exceptions.Panic;
import convex.core.util.Utils;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SLIP10 {
    private static final String HMAC_ALGORITHM = "HmacSHA512";
    private static final byte[] ED25519_KEY = "ed25519 seed".getBytes(StandardCharsets.UTF_8);
    private static final SecretKeySpec masterKey = new SecretKeySpec(ED25519_KEY, "HmacSHA512");

    public static Blob getMaster(Blob bip39seed) {
        try {
            Mac hmac = Mac.getInstance(HMAC_ALGORITHM);
            hmac.init(masterKey);
            byte[] data = bip39seed.getBytes();
            hmac.update(data);
            Blob result = Blob.wrap(hmac.doFinal());
            return result;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new Panic(e);
        }
    }

    public static Blob derive(Blob master, int ... ixs) {
        if (ixs.length == 0) {
            return master;
        }
        if (ixs.length > 255) {
            throw new IllegalArgumentException("Maximum BIP32 path length exceeded (must be 255 or less)");
        }
        byte[] bs = master.getBytes();
        if (bs.length != 64) {
            throw new IllegalArgumentException("Invalid SLIP10 master key, must be 64 bytes");
        }
        byte[] data = new byte[37];
        try {
            Mac hmac = Mac.getInstance(HMAC_ALGORITHM);
            for (int i = 0; i < ixs.length; ++i) {
                SecretKeySpec key = new SecretKeySpec(bs, 32, 32, HMAC_ALGORITHM);
                hmac.init(key);
                System.arraycopy(bs, 0, data, 1, 32);
                Utils.writeInt(data, 33, ixs[i] | Integer.MIN_VALUE);
                hmac.update(data);
                hmac.doFinal(bs, 0);
            }
            Blob result = Blob.wrap(bs);
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new Error("Failure in SLIP-10!!!", e);
        }
    }

    public static AKeyPair deriveKeyPair(Blob bip39seed, int ... ixs) {
        Blob master = SLIP10.getMaster(bip39seed);
        Blob keySeed = SLIP10.derive(master, ixs).slice(0L, 32L);
        AKeyPair kp = AKeyPair.create(keySeed);
        return kp;
    }

    public static AKeyPair deriveKeyPair(Blob bip39seed, String path) {
        return SLIP10.deriveKeyPair(bip39seed, BIP39.parsePath(path));
    }
}

