/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.ASignature;
import convex.core.crypto.InsecureRandom;
import convex.core.crypto.Providers;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.SignedData;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.Panic;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;

public abstract class AKeyPair {
    public static final int SEED_LENGTH = 32;
    protected static final String ED25519 = "Ed25519";
    private KeyPair keyPair = null;

    public final byte[] getPublicKeyBytes() {
        return this.getAccountKey().getBytes();
    }

    public abstract AccountKey getAccountKey();

    public abstract <R extends ACell> SignedData<R> signData(R var1);

    public final boolean equals(Object a) {
        if (!(a instanceof AKeyPair)) {
            return false;
        }
        return this.equals((AKeyPair)a);
    }

    public abstract boolean equals(AKeyPair var1);

    public abstract ASignature sign(AArrayBlob var1);

    public static AKeyPair createSeeded(long seed) {
        InsecureRandom r = new InsecureRandom(seed);
        Blob seedBlob = Blob.createRandom(r, 32L);
        return AKeyPair.create(seedBlob);
    }

    public static AKeyPair generate() {
        return Providers.generate();
    }

    public static AKeyPair create(byte[] keyMaterial) {
        int n = keyMaterial.length;
        return AKeyPair.create(Blob.wrap(keyMaterial, n - 32, 32));
    }

    public static AKeyPair create(Blob ed25519seed) {
        if (ed25519seed.count() != 32L) {
            throw new IllegalArgumentException("seed must 32 bytes");
        }
        return Providers.generate(ed25519seed);
    }

    public PrivateKey getPrivate() {
        try {
            return this.getJCAKeyPair().getPrivate();
        }
        catch (BadFormatException e) {
            throw new Panic(e);
        }
    }

    public PublicKey getPublic() {
        try {
            return this.getJCAKeyPair().getPublic();
        }
        catch (BadFormatException e) {
            throw new Panic(e);
        }
    }

    public String toString() {
        return "Keypair for: " + String.valueOf(this.getAccountKey());
    }

    public KeyPair getJCAKeyPair() throws BadFormatException {
        if (this.keyPair == null) {
            PublicKey pub = AKeyPair.publicKeyFromBytes(this.getAccountKey().getBytes());
            PrivateKey priv = AKeyPair.privateKeyFromBytes(this.getSeed().getBytes());
            this.keyPair = new KeyPair(pub, priv);
        }
        return this.keyPair;
    }

    protected static Blob extractSeed(PrivateKey privateKey) {
        byte[] data = privateKey.getEncoded();
        int n = data.length;
        Blob seed = Blob.wrap(data, n - 32, 32);
        return seed;
    }

    public abstract Blob getSeed();

    public static AKeyPair create(PrivateKey privateKey) throws BadFormatException {
        Ed25519PrivateKeyParameters privateKeyParam = new Ed25519PrivateKeyParameters(privateKey.getEncoded(), 16);
        Ed25519PublicKeyParameters publicKeyParam = privateKeyParam.generatePublicKey();
        PublicKey generatedPublicKey = AKeyPair.publicKeyFromBytes(publicKeyParam.getEncoded());
        return AKeyPair.create(generatedPublicKey, privateKey);
    }

    public static AKeyPair create(PublicKey publicKey, PrivateKey privateKey) {
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return AKeyPair.create(keyPair);
    }

    public static AKeyPair create(KeyPair keyPair) {
        Blob seed = AKeyPair.extractSeed(keyPair.getPrivate());
        return Providers.generate(seed);
    }

    public static PrivateKey privateKeyFromBytes(byte[] key) throws BadFormatException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(key));
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            return privateKey;
        }
        catch (IOException e) {
            throw new BadFormatException(e);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new Panic(e);
        }
    }

    public static AccountKey extractAccountKey(PublicKey publicKey) {
        byte[] bytes = publicKey.getEncoded();
        int n = bytes.length;
        return AccountKey.wrap(bytes, n - 32);
    }

    public static PrivateKey privateKeyFromBlob(Blob encodedKey) throws BadFormatException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(encodedKey.getBytes());
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            return privateKey;
        }
        catch (InvalidKeySpecException e) {
            throw new BadFormatException("Extracting key from Blob failed", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Panic(e);
        }
    }

    public static PrivateKey privateFromBytes(byte[] privKey) throws GeneralSecurityException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(privKey));
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
            PrivateKey result = keyFactory.generatePrivate(pkcs8KeySpec);
            return result;
        }
        catch (IOException e) {
            throw new GeneralSecurityException("IO filure in secure operation", e);
        }
    }

    public static PublicKey publicKeyFromBytes(byte[] key) throws BadFormatException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            SubjectPublicKeyInfo pubKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKeyInfo.getEncoded());
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new Panic(e);
        }
        catch (IOException e) {
            throw new BadFormatException("Can't get public key from bytes", e);
        }
    }

    public static AKeyPair create(String seed) {
        Blob b = Blob.parse(seed);
        if (b == null) {
            throw new IllegalArgumentException("seed must be a valid Blob");
        }
        return AKeyPair.create(b);
    }

    static {
        Providers.init();
    }
}

