/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cpos;

import convex.core.cpos.Block;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Keyword;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;

public class Order
extends ARecordGeneric {
    private static final Keyword[] KEYS = new Keyword[]{Keywords.TIMESTAMP, Keywords.CONSENSUS, Keywords.BLOCKS};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);
    private static final int IX_TIMESTAMP = 0;
    private static final int IX_CONSENSUS = 1;
    private static final int IX_BLOCKS = 2;
    private static final long NUM_FIELDS = FORMAT.count();
    private final long timestamp;
    private final long[] consensusPoints;
    private static final long[] EMPTY_CONSENSUS_ARRAY = new long[4];

    private Order(AVector<ACell> values) {
        super((byte)-41, FORMAT, values);
        this.timestamp = RT.ensureLong((ACell)values.get(0)).longValue();
        this.consensusPoints = RT.toLongArray((AVector)values.get(1));
    }

    private Order(long timestamp, long[] consensusPoints, AVector<SignedData<Block>> blocks) {
        super((byte)-41, FORMAT, Vectors.create(CVMLong.create(timestamp), Vectors.createLongs(consensusPoints), blocks));
        this.timestamp = timestamp;
        this.consensusPoints = consensusPoints;
    }

    private static Order create(AVector<SignedData<Block>> blocks, long proposalPoint, long consensusPoint, long timestamp) {
        long[] consensusPoints = new long[4];
        consensusPoints[0] = blocks.count();
        consensusPoints[1] = proposalPoint;
        consensusPoints[2] = consensusPoint;
        return new Order(timestamp, consensusPoints, blocks);
    }

    public static Order create(long proposalPoint, long consensusPoint, SignedData<Block> ... blocks) {
        return Order.create(Vectors.create((ACell[])blocks), proposalPoint, consensusPoint, 0L);
    }

    public static Order create() {
        return new Order(0L, EMPTY_CONSENSUS_ARRAY, Vectors.empty());
    }

    public static Order read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        if (values.count() != NUM_FIELDS) {
            throw new BadFormatException("Wrong number of Order fields");
        }
        long epos = pos + values.getEncodingLength();
        Order result = new Order(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    public boolean checkConsistent(Order bc) {
        long commonPrefix = this.getBlocks().commonPrefixLength(bc.getBlocks());
        return commonPrefix >= this.getConsensusPoint();
    }

    public long getConsensusPoint(int level) {
        return this.consensusPoints[level];
    }

    public long[] getConsensusPoints() {
        long[] result = (long[])this.consensusPoints.clone();
        return result;
    }

    public long getProposalPoint() {
        return this.consensusPoints[1];
    }

    public long getConsensusPoint() {
        return this.consensusPoints[2];
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AVector<SignedData<Block>> getBlocks() {
        return (AVector)this.values.get(2);
    }

    public SignedData<Block> getBlock(long i) {
        return this.getBlocks().get(i);
    }

    public Order append(SignedData<Block> block) {
        AVector<SignedData<Block>> newBlocks = this.getBlocks().append(block);
        return this.withBlocks(newBlocks);
    }

    public Order withBlocks(AVector<SignedData<Block>> newBlocks) {
        if (this.getBlocks() == newBlocks) {
            return this;
        }
        long nblocks = newBlocks.count();
        ASequence newValues = this.values.assoc(2L, (ACell)newBlocks);
        int n = this.consensusPoints.length;
        if (nblocks != this.consensusPoints[0] || nblocks < this.consensusPoints[n - 1]) {
            long[] nc = (long[])this.consensusPoints.clone();
            nc[0] = nblocks;
            for (int i = 1; i < n; ++i) {
                nc[i] = Math.min(nc[i], nc[i - 1]);
            }
            newValues = ((AVector)newValues).assoc(1L, (ACell)Vectors.createLongs(nc));
        }
        return new Order((AVector<ACell>)newValues);
    }

    public Order withTimestamp(long newTimestamp) {
        if (this.timestamp == newTimestamp) {
            return this;
        }
        return new Order((AVector<ACell>)this.values.assoc(0L, (ACell)CVMLong.create(newTimestamp)));
    }

    public Order withConsensusPoint(int level, long newPosition) {
        if (this.consensusPoints[level] == newPosition) {
            return this;
        }
        long[] cps = (long[])this.consensusPoints.clone();
        cps[level] = newPosition;
        switch (level) {
            case 0: {
                throw new IllegalArgumentException("Can't change number of blocks");
            }
        }
        if (cps[level - 1] < newPosition) {
            throw new IllegalArgumentException("Can't set consensus level byond previous level");
        }
        return new Order((AVector<ACell>)this.values.assoc(1L, (ACell)Vectors.createLongs(cps)));
    }

    public Order withConsensusPoints(long[] newPositions) {
        long[] cps = (long[])newPositions.clone();
        cps[0] = this.getBlockCount();
        return new Order((AVector<ACell>)this.values.assoc(1L, (ACell)Vectors.createLongs(cps)));
    }

    public long getBlockCount() {
        return this.getBlocks().count();
    }

    public Order withoutConsenus() {
        long[] nc = new long[4];
        nc[0] = this.getBlocks().count();
        return new Order((AVector<ACell>)this.values.assoc(1L, (ACell)Vectors.createLongs(nc)));
    }

    @Override
    public void validateCell() throws InvalidDataException {
        super.validateCell();
        if (!this.values.getRef(1).isEmbedded()) {
            throw new InvalidDataException("Consensus values should be embedded", this);
        }
    }

    @Override
    public void validateStructure() throws InvalidDataException {
        super.validateStructure();
        long[] cps = this.getConsensusPoints();
        if (cps[0] != this.getBlockCount()) {
            throw new InvalidDataException("Mimatch of block count with conesnsus points", this);
        }
        int n = cps.length;
        if (cps[n - 1] < 0L) {
            throw new InvalidDataException("Negative final consensus point", this);
        }
        for (int i = 1; i < n; ++i) {
            if (cps[i] <= cps[i - 1]) continue;
            throw new InvalidDataException("Consensus points not in expected order: " + String.valueOf(cps), this);
        }
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.TIMESTAMP.equals(key)) {
            return this.values.get(0);
        }
        if (Keywords.CONSENSUS.equals(key)) {
            return this.values.get(1);
        }
        if (Keywords.BLOCKS.equals(key)) {
            return this.getBlocks();
        }
        return null;
    }

    public boolean consensusEquals(Order b) {
        if (b == null) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.getConsensusPoint(i) == b.getConsensusPoint(i)) continue;
            return false;
        }
        return this.getBlocks().equals(b.getBlocks());
    }

    @Override
    public boolean equals(ACell o) {
        if (o instanceof Order) {
            return this.equals((Order)o);
        }
        return Cells.equalsGeneric(this, o);
    }

    public boolean equals(Order o) {
        if (o == null) {
            return false;
        }
        return this.values.equals(o.values);
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        return new Order(this.values);
    }
}

