/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cpos;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.cpos.Block;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.cvm.State;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;

public class BlockResult
extends ARecordGeneric {
    private State state;
    private AVector<Result> results;
    private static final Keyword[] BLOCKRESULT_KEYS = new Keyword[]{Keywords.STATE, Keywords.RESULTS};
    private static final RecordFormat FORMAT = RecordFormat.of(BLOCKRESULT_KEYS);

    private BlockResult(State state, AVector<Result> results) {
        super((byte)-34, FORMAT, Vectors.create(state, results));
        this.state = state;
        this.results = results;
    }

    public BlockResult(AVector<ACell> values) {
        super((byte)-34, FORMAT, values);
    }

    public static BlockResult create(State state, Result[] results) {
        return new BlockResult(state, Vectors.create((ACell[])results));
    }

    public static BlockResult create(State state, AVector<Result> results) {
        return new BlockResult(state, results);
    }

    public State getState() {
        if (this.state == null) {
            this.state = (State)this.values.get(0);
        }
        return this.state;
    }

    public AVector<Result> getResults() {
        if (this.results == null) {
            this.results = RT.ensureVector((ACell)this.values.get(1));
        }
        return this.results;
    }

    public boolean isError(long i) {
        return this.getResult(i).isError();
    }

    public Result getResult(long i) {
        AVector<Result> results = this.getResults();
        if (i < 0L || i >= results.count()) {
            return null;
        }
        return results.get(i);
    }

    public ACell getErrorCode(long i) {
        Result result = this.getResult(i);
        return result.getErrorCode();
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.STATE.equals(key)) {
            return this.state;
        }
        if (Keywords.RESULTS.equals(key)) {
            return this.results;
        }
        return null;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        this.results.validate();
        this.state.validate();
        long n = this.results.count();
        for (long i = 0L; i < n; ++i) {
            Result r = this.results.get(i);
            if (r instanceof Result) continue;
            throw new InvalidDataException("Not a Result at position " + i + " - found " + Utils.getClassName(r), this);
        }
    }

    public static BlockResult read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        if (values.count() != (long)BLOCKRESULT_KEYS.length) {
            throw new BadFormatException("Wrong number of record values");
        }
        BlockResult result = new BlockResult(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof BlockResult) {
            return this.equals((BlockResult)a);
        }
        return Cells.equalsGeneric(this, a);
    }

    public boolean equals(BlockResult a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Cells.equals(h, ha);
        }
        if (!Cells.equals(this.results, a.results)) {
            return false;
        }
        return Cells.equals(this.state, a.state);
    }

    public static BlockResult createInvalidBlock(State state, Block block, AString message) {
        Result r = Result.create(null, message, ErrorCodes.PEER);
        AVector<Result> rs = block == null ? null : Vectors.repeat(r, block.getTransactions().size());
        return new BlockResult(state, rs);
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new BlockResult(newValues);
    }
}

