/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.State;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AObject;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.TODOException;
import convex.core.lang.RT;
import convex.core.util.Bits;
import convex.core.util.Errors;
import convex.core.util.Shutdown;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Utils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static long lastTimestamp = Instant.now().toEpochMilli();
    private static final long startupTimestamp = Utils.getCurrentTimestamp();
    private static final long startupNanos = System.nanoTime();
    private static ExecutorService executor = null;

    public static BigInteger toBigInteger(byte[] data) {
        return new BigInteger(1, data);
    }

    public static BigInteger toSignedBigInteger(byte[] data) {
        return new BigInteger(data);
    }

    public static String toHexString(int val) {
        StringBuffer sb = new StringBuffer(8);
        for (int i = 0; i < 8; ++i) {
            sb.append(Utils.toHexChar(val >> (7 - i) * 4 & 0xF));
        }
        return sb.toString();
    }

    public static String toHexString(short val) {
        StringBuffer sb = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            sb.append(Utils.toHexChar(val >> (3 - i) * 4 & 0xF));
        }
        return sb.toString();
    }

    public static String toHexString(byte value) {
        StringBuilder sb = new StringBuilder(2);
        sb.append(Utils.toHexChar((value & 0xF0) >>> 4));
        sb.append(Utils.toHexChar(value & 0xF));
        return sb.toString();
    }

    public static void appendHexByte(BlobBuilder bb, byte b) {
        bb.append(Utils.toHexChar((b & 0xF0) >>> 4));
        bb.append(Utils.toHexChar(b & 0xF));
    }

    public static String toHexString(long x) {
        StringBuffer sb = new StringBuffer(16);
        for (int i = 15; i >= 0; --i) {
            sb.append(Utils.toHexChar((int)(x >> 4 * i) & 0xF));
        }
        return sb.toString();
    }

    public static String toFriendlyHexString(String hexString, int size) {
        String cleanHexString = hexString.replaceAll("^0[Xx]", "");
        String result = cleanHexString.substring(0, size);
        return result;
    }

    public static int readInt(byte[] data, int offset) {
        int result = data[offset];
        for (int i = 1; i <= 3; ++i) {
            result = (result << 8) + (data[offset + i] & 0xFF);
        }
        return result;
    }

    public static int readIntZeroExtend(byte[] data, int offset) {
        int result = data[offset];
        for (int i = 1; i <= 3; ++i) {
            int ix = offset + i;
            result = (result << 8) + (ix < data.length ? data[offset + i] & 0xFF : 0);
        }
        return result;
    }

    public static long readLong(byte[] data, int offset) {
        long result = data[offset];
        for (int i = 1; i <= 7; ++i) {
            result = (result << 8) + (long)(data[offset + i] & 0xFF);
        }
        return result;
    }

    public static short readShort(byte[] data, int offset) {
        int result = ((data[offset] & 0xFF) << 8) + (data[offset + 1] & 0xFF);
        return (short)result;
    }

    public static int writeChar(byte[] data, int offset, char value) {
        data[offset++] = (byte)(value >> 8);
        data[offset++] = (byte)value;
        return offset;
    }

    public static int writeShort(byte[] data, int offset, short value) {
        data[offset++] = (byte)(value >> 8);
        data[offset++] = (byte)value;
        return offset;
    }

    public static int writeInt(byte[] data, int offset, int value) {
        for (int i = 0; i <= 3; ++i) {
            data[offset + i] = (byte)(value >> 8 * (3 - i) & 0xFF);
        }
        return offset + 4;
    }

    public static int writeLong(byte[] data, int offset, long value) {
        for (int i = 0; i <= 7; ++i) {
            data[offset + i] = (byte)(value >> 8 * (7 - i));
        }
        return offset + 8;
    }

    public static byte[] toByteArray(ByteBuffer bb) {
        int len = bb.remaining();
        byte[] bytes = new byte[len];
        bb.get(bytes);
        return bytes;
    }

    public static AArrayBlob toData(ByteBuffer bb) {
        return Blob.wrap(Utils.toByteArray(bb));
    }

    public static char toHexChar(int i) {
        if (i >= 0) {
            if (i <= 9) {
                return (char)(i + 48);
            }
            if (i <= 15) {
                return (char)(i + 87);
            }
        }
        throw new IllegalArgumentException("Unable to convert to single hex char: " + i);
    }

    public static byte[] hexToBytes(String hex) {
        byte[] bs = Utils.hexToBytes(hex, hex.length());
        return bs;
    }

    public static byte[] hexToBytes(String hex, int stringLength) {
        if (hex.length() != stringLength) {
            return null;
        }
        int N = stringLength / 2;
        if (N * 2 != stringLength) {
            return null;
        }
        byte[] result = new byte[N];
        for (int i = 0; i < N; ++i) {
            char high = hex.charAt(2 * i);
            char low = hex.charAt(2 * i + 1);
            int lowD = Utils.hexVal(low);
            if (lowD < 0) {
                return null;
            }
            int highD = Utils.hexVal(high);
            if (highD < 0) {
                return null;
            }
            result[i] = (byte)(highD * 16 + lowD);
        }
        return result;
    }

    public static BigInteger hexToBigInt(String hex) {
        return new BigInteger(1, Utils.hexToBytes(hex));
    }

    public static int hexVal(char c) {
        char v = c;
        if (v <= 'f') {
            if (v >= 'a') {
                return v - 87;
            }
            if (v >= 'A' && v <= 'F') {
                return v - 55;
            }
            if (v >= '0' && v <= '9') {
                return v - 48;
            }
        }
        return -1;
    }

    public static String toHexString(byte[] data) {
        return Utils.toHexString(data, 0, data.length);
    }

    public static String toHexString(byte[] data, int offset, int length) {
        char[] hexDigits = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int v = data[i + offset] & 0xFF;
            hexDigits[i * 2] = Utils.toHexChar(v >>> 4);
            hexDigits[i * 2 + 1] = Utils.toHexChar(v & 0xF);
        }
        return new String(hexDigits);
    }

    public static int hashCode(Object a) {
        if (a == null) {
            return 0;
        }
        return a.hashCode();
    }

    public static boolean arrayEquals(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        return Arrays.equals(a, aOffset, aOffset + length, b, bOffset, bOffset + length);
    }

    public static int compareByteArrays(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        for (int i = 0; i < length; ++i) {
            int ai = 0xFF & a[aOffset + i];
            int bi = 0xFF & b[bOffset + i];
            if (ai < bi) {
                return -1;
            }
            if (ai <= bi) continue;
            return 1;
        }
        return 0;
    }

    public static String toHexString(BigInteger a, int digits) {
        if (a.signum() < 0) {
            throw new IllegalArgumentException("toHexString requires a non-negative BigInteger, got :" + a);
        }
        String s = a.toString(16);
        int slen = s.length();
        if (slen > digits) {
            throw new IllegalArgumentException("toHexString number of digits exceeded, got :" + slen);
        }
        if (slen == digits) {
            return s;
        }
        StringBuffer sb = new StringBuffer(digits);
        while (slen < digits) {
            sb.append('0');
            ++slen;
        }
        sb.append(s);
        return sb.toString();
    }

    public static void writeUInt(BigInteger a, byte[] dest, int offset, int length) {
        if (a.signum() < 0) {
            throw new IllegalArgumentException("Non-negative big integer expected!");
        }
        if (offset + length > dest.length) {
            throw new IllegalArgumentException("Insufficient buffer space in byte array, available = " + (dest.length - offset));
        }
        byte[] bs = a.toByteArray();
        int bl = bs.length;
        if (bl == length) {
            System.arraycopy(bs, 0, dest, offset, length);
        } else if (bl == length + 1 && bs[0] == 0) {
            System.arraycopy(bs, 1, dest, offset, length);
        } else if (bl < length) {
            int pad = length - bl;
            Arrays.fill(dest, offset, offset + pad, (byte)0);
            System.arraycopy(bs, 0, dest, offset + pad, bl);
        } else {
            throw new IllegalArgumentException("Insufficient buffer size, was " + length + " but needed " + bl);
        }
    }

    public static byte[] toByteArray(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static Object[] toObjectArray(Object anyArray) {
        if (anyArray instanceof Object[]) {
            return (Object[])anyArray;
        }
        int n = Array.getLength(anyArray);
        Object[] result = new Object[n];
        for (int i = 0; i < n; ++i) {
            result[i] = Array.get(anyArray, i);
        }
        return result;
    }

    public static ACell[] toCellArray(Object anyArray) {
        int n = Array.getLength(anyArray);
        ACell[] result = new ACell[n];
        for (int i = 0; i < n; ++i) {
            result[i] = (ACell)Array.get(anyArray, i);
        }
        return result;
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equals(ACell a, ACell b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static Class<?> getClass(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass();
    }

    public static String getClassName(Object o) {
        Class<?> klass = Utils.getClass(o);
        return klass == null ? "null" : klass.getName();
    }

    public static int checkedInt(long a) {
        int i = (int)a;
        if (a != (long)i) {
            throw new IllegalArgumentException(Errors.sizeOutOfRange(a));
        }
        return i;
    }

    public static short checkedShort(long a) {
        short s = (short)a;
        if ((long)s != a) {
            throw new IllegalArgumentException(Errors.sizeOutOfRange(a));
        }
        return s;
    }

    public static byte checkedByte(long a) {
        byte b = (byte)a;
        if ((long)b != a) {
            throw new IllegalArgumentException(Errors.sizeOutOfRange(a));
        }
        return b;
    }

    public static ByteBuffer writeUInt256(ByteBuffer b, BigInteger v) {
        if (v.signum() < 0) {
            throw new IllegalArgumentException("Non-negative integer expected");
        }
        byte[] bs = v.toByteArray();
        byte[] buf = new byte[32];
        int blen = bs.length;
        if (blen <= 32) {
            System.arraycopy(bs, 0, buf, 32 - blen, blen);
        } else if (blen == 33 && bs[0] == 0) {
            System.arraycopy(bs, blen - 32, buf, 0, 32);
        } else {
            throw new IllegalArgumentException("BigInteger too large for UInt256, length in bytes=" + blen);
        }
        return b.put(buf);
    }

    public static BigInteger readUInt256(ByteBuffer b) {
        byte[] buf = new byte[32];
        b.get(buf);
        return new BigInteger(1, buf);
    }

    public static int bitLength(long x) {
        long ux = x >= 0L ? x : -x - 1L;
        return 1 + (64 - Bits.leadingZeros(ux));
    }

    public static int toInt(Object v) {
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            int value = (int)number.longValue();
            if ((double)value != number.doubleValue()) {
                throw new IllegalArgumentException("Cannot coerce to int without loss:");
            }
            return value;
        }
        throw new IllegalArgumentException("Can't convert to int: " + v);
    }

    public static String readResourceAsString(String path) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(path);){
            String string;
            if (inputStream == null) {
                throw new IOException("Resource not found: " + path);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return string;
        }
    }

    public static String readString(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result.toString("UTF-8");
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static int extractBits(byte[] bs, int numBits, int shift) {
        if (numBits <= 0) {
            return 0;
        }
        if (numBits > 32) {
            throw new IllegalArgumentException("Invalid number of bits: " + numBits);
        }
        if (numBits > 8) {
            return Utils.extractBits(bs, 8, shift) | Utils.extractBits(bs, numBits - 8, shift + 8) << 8;
        }
        if (shift < 0) {
            int end = Utils.extractBits(bs, numBits + shift, 0);
            return end << -shift;
        }
        int bshift = shift >> 3;
        int bslen = bs.length;
        if (bshift >= bslen) {
            return (bs[0] >= 0 ? 0 : -1) & Bits.lowBitMask(numBits);
        }
        int lowShift = shift - (bshift << 3);
        int ix = bslen - bshift - 1;
        int val = bs[ix];
        if (ix > 0) {
            val &= 0xFF;
            val |= bs[ix - 1] << 8;
        }
        return (val >>= lowShift) & Bits.lowBitMask(numBits);
    }

    public static void setBits(byte[] bs, int numBits, int shift, int bits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Invalid number of bits: " + numBits);
        }
        if (shift < 0) {
            if ((numBits += shift) <= 0) {
                return;
            }
            Utils.setBits(bs, numBits, 0, bits >> -shift);
            return;
        }
        if (numBits > 8) {
            Utils.setBits(bs, 8, shift, bits);
            Utils.setBits(bs, numBits - 8, shift + 8, bits >> 8);
            return;
        }
        int bshift = shift >> 3;
        int bslen = bs.length;
        if (bshift >= bslen) {
            return;
        }
        int ix = bslen - bshift - 1;
        int lowShift = shift - (bshift << 3);
        int lowBitMask = Bits.lowBitMask(numBits);
        int val = (bits & lowBitMask) << lowShift;
        int keepBitMask = ~(lowBitMask << lowShift);
        int keep = bs[ix] & 0xFF;
        if (ix > 0) {
            keep |= (bs[ix - 1] & 0xFF) << 8;
        }
        bs[ix] = (byte)((val |= (keep &= keepBitMask)) & 0xFF);
        if (ix > 0) {
            bs[ix - 1] = (byte)(val >> 8 & 0xFF);
        }
    }

    public static AArrayBlob readBufferData(ByteBuffer bb) {
        bb.position(0);
        int len = bb.remaining();
        byte[] bytes = new byte[len];
        bb.get(bytes);
        return Blob.wrap(bytes);
    }

    public static String print(Object v) {
        StringBuilder sb = new StringBuilder();
        Utils.print(sb, v);
        return sb.toString();
    }

    public static void print(StringBuilder sb, Object v) {
        if (v == null) {
            sb.append("nil");
        } else if (v instanceof AObject) {
            sb.append(((AObject)v).print());
        } else if (v instanceof Boolean || v instanceof Number) {
            sb.append(v.toString());
        } else if (v instanceof String) {
            sb.append('\"');
            sb.append((String)v);
            sb.append('\"');
        } else if (v instanceof Instant) {
            sb.append(((Instant)v).toEpochMilli());
        } else if (v instanceof Character) {
            sb.append(((Character)v).toString());
        } else {
            throw new TODOException("Can't print: " + Utils.getClass(v));
        }
    }

    public static InetSocketAddress toInetSocketAddress(Object o) {
        if (o instanceof InetSocketAddress) {
            return (InetSocketAddress)o;
        }
        if (o instanceof String) {
            return Utils.toInetSocketAddress((String)o);
        }
        if (o instanceof URL) {
            return Utils.toInetSocketAddress((URL)o);
        }
        return null;
    }

    public static InetSocketAddress toInetSocketAddress(String s) {
        if (s == null) {
            return null;
        }
        try {
            URL url = new URL(s);
            return Utils.toInetSocketAddress(url);
        }
        catch (MalformedURLException ex) {
            int colon = s.lastIndexOf(58);
            if (colon < 0) {
                return null;
            }
            try {
                String hostName = s.substring(0, colon);
                int port = Utils.toInt(s.substring(colon + 1));
                InetSocketAddress addr = new InetSocketAddress(hostName, port);
                return addr;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static InetSocketAddress toInetSocketAddress(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        if (port < 0) {
            port = 18888;
        }
        return new InetSocketAddress(host, port);
    }

    public static <T> T[] filterArray(T[] arr, Predicate<T> predicate) {
        if (arr.length <= 32) {
            return Utils.filterSmallArray(arr, predicate);
        }
        throw new TODOException("Filter large arrays");
    }

    public static <T> ArrayList<T> sortListBy(Function<T, Long> scorer, Collection<T> coll) {
        ArrayList<T> result = new ArrayList<T>(coll.size());
        final HashMap<T, Long> scores = new HashMap<T, Long>(coll.size());
        for (T c : coll) {
            Long score = scorer.apply(c);
            if (score == null) continue;
            scores.put(c, score);
            result.add(c);
        }
        result.sort(new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                long comp = (Long)scores.get(a) - (Long)scores.get(b);
                return Long.signum(comp);
            }
        });
        return result;
    }

    private static <T> T[] filterSmallArray(T[] arr, Predicate<T> predicate) {
        int mask = 0;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(arr[i])) continue;
            mask |= 1 << i;
        }
        return Utils.filterSmallArray(arr, mask);
    }

    public static <T> T[] filterSmallArray(T[] arr, int mask) {
        int n = arr.length;
        if (n > 32) {
            throw new IllegalArgumentException("Array too long to filter: " + n);
        }
        int fullMask = (1 << n) - 1;
        if (mask == fullMask) {
            return arr;
        }
        int nn = Integer.bitCount(mask);
        Object[] result = (Object[])Array.newInstance(arr.getClass().getComponentType(), nn);
        if (nn == 0) {
            return result;
        }
        int ix = 0;
        for (int i = 0; i < n; ++i) {
            if ((mask & 1 << i) == 0) continue;
            result[ix++] = arr[i];
        }
        assert (ix == nn);
        return result;
    }

    public static <T> short computeMask(T[] set, T[] subset) {
        int n = set.length;
        if (n > 16) {
            throw new IllegalArgumentException("Max length of 16 for mask computation, got: " + n);
        }
        int mask = 0;
        int ix = 0;
        int subsetLength = subset.length;
        for (int i = 0; i < n && ix != subsetLength; ++i) {
            if (set[i] != subset[ix]) continue;
            mask |= 1 << i;
            ++ix;
        }
        if (ix != subsetLength) {
            throw new IllegalArgumentException("Subset not all found");
        }
        return (short)mask;
    }

    public static <T extends Throwable> T sneakyThrow(Throwable t) throws T {
        throw t;
    }

    public static <T> T[] copyOfRangeExcludeNulls(T[] entries, int offset, int length) {
        int newLen = length;
        for (int i = 0; i < length; ++i) {
            if (entries[offset + i] != null) continue;
            --newLen;
        }
        if (newLen < length) {
            Object[] result = (Object[])Array.newInstance(entries.getClass().getComponentType(), newLen);
            int ix = 0;
            for (int i = 0; i < length; ++i) {
                T v = entries[offset + i];
                if (v == null) continue;
                result[ix++] = v;
            }
            assert (ix == newLen);
            return result;
        }
        return Arrays.copyOfRange(entries, offset, offset + length);
    }

    public static <T> void reverse(T[] arr) {
        Utils.reverse(arr, arr.length);
    }

    public static <T> void reverse(T[] arr, int n) {
        for (int i = 0; i < n / 2; ++i) {
            T val = arr[i];
            arr[i] = arr[n - i - 1];
            arr[n - i - 1] = val;
        }
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((bytesRead = is.read(buf)) >= 0) {
            bos.write(buf, 0, bytesRead);
        }
        return bos.toByteArray();
    }

    public static boolean isOdd(long x) {
        return (x & 1L) != 0L;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "nil";
        }
        return o.toString();
    }

    public static String stripWhiteSpace(String s) {
        return s.replaceAll("\\s+", "");
    }

    public static int refCount(ACell a) {
        if (a == null) {
            return 0;
        }
        return a.getRefCount();
    }

    public static long totalRefCount(Object a) {
        if (!(a instanceof ACell)) {
            return 0L;
        }
        ACell ra = (ACell)a;
        long[] count = new long[]{0L};
        ACell ra2 = ra.updateRefs(r -> {
            count[0] = count[0] + (1L + Utils.totalRefCount(r.getValue()));
            return r;
        });
        assert (ra == ra2);
        return count[0];
    }

    public static <R extends ACell> Ref<R> getRef(ACell o, int i) {
        if (o == null) {
            throw new IllegalArgumentException("Bad ref index: " + i + " called on null");
        }
        return o.getRef(i);
    }

    public static <T extends ACell> T updateRefs(T o, IRefFunction func) {
        if (o == null) {
            return o;
        }
        return (T)o.updateRefs(func);
    }

    public static int bitCount(short mask) {
        return Integer.bitCount(mask & 0xFFFF);
    }

    public static boolean timeout(int timeoutMillis, Supplier<Boolean> test) {
        long start = Utils.getTimeMillis();
        long end = start + (long)timeoutMillis;
        long now = start;
        while (!test.get().booleanValue()) {
            try {
                long nextInterval = (long)((double)(now - start) * 0.3 + 1.0);
                long sleepTime = Math.min(nextInterval, end - now);
                if (sleepTime < 0L) {
                    return true;
                }
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            now = Utils.getTimeMillis();
        }
        return false;
    }

    public static long getCurrentTimestamp() {
        long ts = Instant.now().toEpochMilli();
        if (ts > lastTimestamp) {
            lastTimestamp = ts;
            return ts;
        }
        return lastTimestamp;
    }

    public static long getTimeMillis() {
        long elapsedMillis = (System.nanoTime() - startupNanos) / 1000000L;
        return startupTimestamp + elapsedMillis;
    }

    public static boolean firstDigitMatch(byte a, byte b) {
        return (a & 0xF0) == (b & 0xF0);
    }

    public static <T extends ACell, U> T binarySearchLeftmost(ASequence<T> L, Function<T, U> value, Comparator<U> comparator, U target) {
        long min = 0L;
        long max = L.count();
        while (min < max) {
            long midpoint = (min + max) / 2L;
            if (comparator.compare(value.apply(L.get(midpoint)), target) < 0) {
                min = midpoint + 1L;
                continue;
            }
            max = midpoint;
        }
        if (min < L.count() && comparator.compare(value.apply(L.get(min)), target) == 0) {
            return L.get(min);
        }
        if (min - 1L == -1L) {
            return null;
        }
        return L.get(min - 1L);
    }

    public static <T> CompletableFuture<List<T>> completeAll(List<CompletableFuture<T>> futures) {
        CompletableFuture[] fs = futures.toArray(new CompletableFuture[futures.size()]);
        return CompletableFuture.allOf(fs).thenApply(e -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static State stateAsOf(AVector<State> states, CVMLong timestamp) {
        return Utils.binarySearchLeftmost(states, State::getTimeStamp, Comparator.comparingLong(CVMLong::longValue), timestamp);
    }

    public static AVector<State> statesAsOfRange(AVector<State> states, CVMLong timestamp, long interval, int count) {
        ASequence v = Vectors.empty();
        for (int i = 0; i < count; ++i) {
            v = v.conj(Utils.stateAsOf(states, timestamp));
            timestamp = CVMLong.create(timestamp.longValue() + interval);
        }
        return v;
    }

    public static boolean bool(Object a) {
        if (a == null) {
            return false;
        }
        if (a instanceof ACell) {
            return RT.bool((ACell)a);
        }
        if (a instanceof Boolean) {
            return (Boolean)a;
        }
        return true;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... values) {
        return Arrays.asList(values);
    }

    private static synchronized ExecutorService getExecutor() {
        if (executor == null) {
            ExecutorService ex = Executors.newFixedThreadPool(100);
            Shutdown.addHook(110, () -> {
                ex.shutdown();
                try {
                    if (!ex.awaitTermination(200L, TimeUnit.MILLISECONDS)) {
                        ex.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    ex.shutdownNow();
                }
            });
            executor = ex;
        }
        return executor;
    }

    public static <R, T> ArrayList<CompletableFuture<R>> futureMap(Function<T, R> func, Collection<T> items) {
        ArrayList<CompletableFuture<R>> futures = new ArrayList<CompletableFuture<R>>(items.size());
        for (Object item : items) {
            futures.add(CompletableFuture.supplyAsync(() -> func.apply(item), Utils.getExecutor()));
        }
        return futures;
    }

    public static <R> void awaitAll(Collection<CompletableFuture<R>> cfutures) throws InterruptedException, ExecutionException {
        CompletableFuture.allOf(cfutures.toArray(new CompletableFuture[cfutures.size()])).get();
    }
}

