/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AHashSet;
import convex.core.data.ASet;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.SetTree;
import convex.core.data.Sets;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.TODOException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiFunction;

public class SetLeaf<T extends ACell>
extends AHashSet<T> {
    public static final int MAX_ELEMENTS = 16;
    private final Ref<T>[] elements;
    public static int MAX_ENCODING_LENGTH = 2242;

    SetLeaf(Ref<T>[] items) {
        super(items.length);
        this.elements = items;
    }

    @SafeVarargs
    public static <V extends ACell> SetLeaf<V> create(Ref<V> ... elements) {
        return SetLeaf.create(elements, 0, elements.length);
    }

    public static <V extends ACell> SetLeaf<V> unsafeCreate(Ref<V> ... refs) {
        return new SetLeaf<V>(refs);
    }

    public static <V extends ACell> SetLeaf<V> unsafeCreate(V ... elements) {
        int n = elements.length;
        Ref[] refs = new Ref[n];
        for (int i = 0; i < n; ++i) {
            refs[i] = Ref.get(elements[i]);
        }
        return SetLeaf.unsafeCreate(refs);
    }

    protected static <V extends ACell> SetLeaf<V> create(Ref<V>[] entries, int offset, int length) {
        if (length == 0) {
            return Sets.empty();
        }
        if (length > 16) {
            throw new IllegalArgumentException("Too many elements: " + entries.length);
        }
        Object[] sorted = Utils.copyOfRangeExcludeNulls(entries, offset, offset + length);
        if (sorted.length == 0) {
            return Sets.empty();
        }
        Arrays.sort(sorted);
        return new SetLeaf((Ref<T>[])sorted);
    }

    public static <V extends ACell> SetLeaf<V> create(V item) {
        return new SetLeaf(new Ref[]{Ref.get(item)});
    }

    @Override
    public Ref<T> getValueRef(ACell k) {
        Hash h;
        Hash hash = h = k == null ? Hash.NULL_HASH : k.cachedHash();
        if (h != null) {
            return this.getRefByHash(h);
        }
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            Ref<T> e = this.elements[i];
            if (!Utils.equals(k, e.getValue())) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean containsHash(Hash hash) {
        return this.getRefByHash(hash) != null;
    }

    @Override
    protected Ref<T> getRefByHash(Hash hash) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            Ref<T> e = this.elements[i];
            if (!hash.equals(e.getHash())) continue;
            return e;
        }
        return null;
    }

    private int seek(T key) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (!Utils.equals(key, this.elements[i].getValue())) continue;
            return i;
        }
        return -1;
    }

    private int seekKeyRef(Ref<T> key) {
        Hash h = key.getHash();
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (h.compareTo(this.elements[i].getHash()) != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public SetLeaf<T> exclude(ACell key) {
        int i = this.seek(key);
        if (i < 0) {
            return this;
        }
        return this.excludeAt(i);
    }

    @Override
    public SetLeaf<T> excludeRef(Ref<T> key) {
        int i = this.seekKeyRef(key);
        if (i < 0) {
            return this;
        }
        return this.excludeAt(i);
    }

    private SetLeaf<T> excludeAt(int index) {
        int len = this.size();
        if (len == 1) {
            return Sets.empty();
        }
        Ref[] newEntries = new Ref[len - 1];
        System.arraycopy(this.elements, 0, newEntries, 0, index);
        System.arraycopy(this.elements, index + 1, newEntries, index, len - index - 1);
        return new SetLeaf<T>(newEntries);
    }

    protected void accumulateValues(ArrayList<T> al) {
        for (int i = 0; i < this.elements.length; ++i) {
            Ref<T> me = this.elements[i];
            al.add(me.getValue());
        }
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -125;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        long n = this.count();
        pos = Format.writeVLCLong(bs, pos, n);
        int i = 0;
        while ((long)i < n) {
            pos = this.elements[i].encode(bs, pos);
            ++i;
        }
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 2 + 140 * this.size();
    }

    public static <V extends ACell> SetLeaf<V> read(ByteBuffer bb, long count) throws BadFormatException {
        if (count == 0L) {
            return Sets.empty();
        }
        if (count < 0L) {
            throw new BadFormatException("Negative count of map elements!");
        }
        if (count > 16L) {
            throw new BadFormatException("SetLeaf too big: " + count);
        }
        Ref[] items = new Ref[(int)count];
        int i = 0;
        while ((long)i < count) {
            Ref ref;
            items[i] = ref = Format.readRef(bb);
            ++i;
        }
        return new SetLeaf(items);
    }

    public static <V extends ACell> SetLeaf<V> emptySet() {
        return Sets.EMPTY;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    private static <V extends ACell> boolean isValidOrder(Ref<V>[] entries) {
        long count = entries.length;
        int i = 0;
        while ((long)i < count - 1L) {
            Hash b;
            Hash a = entries[i].getHash();
            if (a.compareTo(b = entries[i + 1].getHash()) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getRefCount() {
        return this.elements.length;
    }

    public Ref<T> getRef(int i) {
        Ref<T> e = this.elements[i];
        return e;
    }

    @Override
    public Ref<T> getElementRef(long i) {
        Ref<T> e = this.elements[Utils.checkedInt(i)];
        return e;
    }

    @Override
    public SetLeaf updateRefs(IRefFunction func) {
        int n = this.elements.length;
        if (n == 0) {
            return this;
        }
        Ref<T>[] newEntries = this.elements;
        for (int i = 0; i < n; ++i) {
            Ref<T> e = newEntries[i];
            Ref<?> newEntry = func.apply(e);
            if (e == newEntry) continue;
            if (newEntries == this.elements) {
                newEntries = (Ref[])this.elements.clone();
            }
            newEntries[i] = newEntry;
        }
        if (newEntries == this.elements) {
            return this;
        }
        return new SetLeaf<T>(newEntries);
    }

    public SetLeaf<T> filterHexDigits(int digitPos, int mask) {
        if ((mask &= 0xFFFF) == 0) {
            return Sets.empty();
        }
        if (mask == 65535) {
            return this;
        }
        int sel = 0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Hash h = this.elements[i].getHash();
            if ((mask & 1 << h.getHexDigit(digitPos)) == 0) continue;
            sel |= 1 << i;
        }
        if (sel == 0) {
            return Sets.empty();
        }
        return this.filterEntries(sel);
    }

    private SetLeaf<T> filterEntries(int selection) {
        if (selection == 0) {
            return Sets.empty();
        }
        int n = this.size();
        if (selection == (1 << n) - 1) {
            return this;
        }
        Ref[] newEntries = new Ref[Integer.bitCount(selection)];
        int ix = 0;
        for (int i = 0; i < n; ++i) {
            if ((selection & 1 << i) == 0) continue;
            newEntries[ix++] = this.elements[i];
        }
        assert (ix == Integer.bitCount(selection));
        return new SetLeaf<T>(newEntries);
    }

    @Override
    public AHashSet<T> mergeWith(AHashSet<T> b, int setOp) {
        return this.mergeWith(b, setOp, 0);
    }

    @Override
    protected AHashSet<T> mergeWith(AHashSet<T> b, int setOp, int shift) {
        if (b instanceof SetLeaf) {
            return this.mergeWith((SetLeaf)b, setOp, shift);
        }
        if (b instanceof SetTree) {
            return b.mergeWith(this, this.reverseOp(setOp), shift);
        }
        throw new TODOException("Unhandled map type: " + b.getClass());
    }

    @Override
    public AHashSet<T> mergeWith(SetLeaf<T> b, int setOp, int shift) {
        if (this.equals(b)) {
            return this.applySelf(setOp);
        }
        int al = this.size();
        int bl = b.size();
        int ai = 0;
        int bi = 0;
        ArrayList<Ref<T>> results = null;
        while (ai < al || bi < bl) {
            int c;
            Ref<T> be;
            Ref<T> ae = ai < al ? this.elements[ai] : null;
            Ref<T> ref = be = bi < bl ? b.elements[bi] : null;
            int n = ae == null ? 1 : (c = be == null ? -1 : ae.getHash().compareTo(be.getHash()));
            Ref<T> newE = c == 0 ? this.applyOp(setOp, ae, be) : (c < 0 ? this.applyOp(setOp, ae, null) : this.applyOp(setOp, null, be));
            if (results == null && newE != (c <= 0 ? ae : null)) {
                results = new ArrayList<Ref<T>>(32);
                for (int i = 0; i < ai; ++i) {
                    results.add(this.elements[i]);
                }
            }
            if (c <= 0) {
                ++ai;
            }
            if (c >= 0) {
                ++bi;
            }
            if (results == null || newE == null) continue;
            results.add(newE);
        }
        if (results == null) {
            return this;
        }
        return Sets.createWithShift(shift, results);
    }

    public <R> R reduceValues(BiFunction<? super R, ? super T, ? extends R> func, R initial) {
        int n = this.size();
        R result = initial;
        for (int i = 0; i < n; ++i) {
            result = func.apply(result, this.elements[i].getValue());
        }
        return result;
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof SetLeaf)) {
            return false;
        }
        return this.equals((SetLeaf)a);
    }

    public boolean equals(SetLeaf<T> a) {
        if (this == a) {
            return true;
        }
        if (this.count != a.count) {
            return false;
        }
        int n = (int)this.count;
        for (int i = 0; i < n; ++i) {
            if (this.elements[i].equals(a.elements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        this.validateWithPrefix(Hash.EMPTY_HASH, 0, -1);
    }

    @Override
    protected void validateWithPrefix(Hash prefix, int digit, int position) throws InvalidDataException {
        if (!SetLeaf.isValidOrder(this.elements)) {
            throw new InvalidDataException("Bad ordering of set elements!", this);
        }
        for (int i = 0; i < this.elements.length; ++i) {
            int mydigit;
            Ref<T> e = this.elements[i];
            Hash h = e.getHash();
            long match = h.commonHexPrefixLength(prefix);
            if (match < (long)(position - 1)) {
                throw new InvalidDataException("Parent prefix did not match", this);
            }
            if (position >= 0 && (mydigit = h.getHexDigit(position)) != digit) {
                throw new InvalidDataException("Bad hex digit at position: " + position, this);
            }
            e.validate();
            T value = e.getValue();
            if (RT.isCVM(value)) continue;
            throw new InvalidDataException("Non-CVM value in Set", this);
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.count == 0L && this != Sets.EMPTY) {
            throw new InvalidDataException("Empty set not using canonical instance", this);
        }
        if (this.count > 16L) {
            throw new InvalidDataException("Too many items in SetLeaf: " + this.elements.length, this);
        }
        if (!SetLeaf.isValidOrder(this.elements)) {
            throw new InvalidDataException("Bad ordering of set elements", this);
        }
    }

    @Override
    public boolean containsAll(ASet<T> b) {
        if (this == b) {
            return true;
        }
        if (b.count() > this.count) {
            return false;
        }
        return this.containsAll((SetLeaf)b);
    }

    @Override
    public boolean isSubset(ASet<T> b) {
        return b.containsAll(this);
    }

    @Override
    protected boolean containsAll(SetLeaf<T> b) {
        int ix = 0;
        block0: for (Ref<T> meb : b.elements) {
            Hash bh = meb.getHash();
            if ((long)ix >= this.count) {
                return false;
            }
            while ((long)ix < this.count) {
                Ref<T> mea = this.elements[ix];
                Hash ah = mea.getHash();
                int c = ah.compareTo(bh);
                if (c < 0) {
                    if ((long)(++ix) < this.count) continue;
                    return false;
                }
                if (c > 0) {
                    return false;
                }
                ++ix;
                continue block0;
            }
        }
        return true;
    }

    @Override
    public AHashSet<T> includeRef(Ref<T> ref) {
        return this.includeRef(ref, 0);
    }

    @Override
    protected AHashSet<T> includeRef(Ref<T> e, int shift) {
        int pos;
        int n = this.elements.length;
        Hash h = e.getHash();
        for (pos = 0; pos < n; ++pos) {
            Ref<T> iref = this.elements[pos];
            int c = h.compareTo(iref.getHash());
            if (c == 0) {
                return this;
            }
            if (c < 0) break;
        }
        Ref[] newEntries = new Ref[n + 1];
        System.arraycopy(this.elements, 0, newEntries, 0, pos);
        System.arraycopy(this.elements, pos, newEntries, pos + 1, n - pos);
        newEntries[pos] = e;
        if (n < 16) {
            return new SetLeaf<T>(newEntries);
        }
        return SetTree.create(newEntries, shift);
    }

    @Override
    protected <R> void copyToArray(R[] arr, int offset) {
        int i = 0;
        while ((long)i < this.count) {
            arr[i + offset] = this.get(i);
            ++i;
        }
    }

    @Override
    public T get(long index) {
        return this.elements[Utils.checkedInt(index)].getValue();
    }

    @Override
    public AHashSet<T> toCanonical() {
        if (this.count <= 16L) {
            return this;
        }
        return SetTree.create(this.elements, 0);
    }

    @Override
    public ASet<T> slice(long start, long end) {
        throw new TODOException();
    }
}

