/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.Blobs;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public class Blob
extends AArrayBlob {
    public static final Blob EMPTY = Blob.wrap(Utils.EMPTY_BYTES);
    public static final Blob NULL_ENCODING = Blob.wrap(new byte[]{0});
    public static final int CHUNK_LENGTH = 4096;
    public static final int MAX_ENCODING_LENGTH = 1 + Format.getVLCLength(4096L) + 4096;

    private Blob(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    public static Blob create(byte[] data, int offset, int length) {
        if (length <= 0) {
            if (length == 0) {
                return EMPTY;
            }
            throw new IllegalArgumentException(Errors.negativeLength(length));
        }
        byte[] store = Arrays.copyOfRange(data, offset, offset + length);
        return Blob.wrap(store);
    }

    public static Blob create(byte[] data) {
        return Blob.create(data, 0, data.length);
    }

    public static Blob wrap(byte[] data) {
        return new Blob(data, 0, data.length);
    }

    public static Blob wrap(byte[] data, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException(Errors.negativeLength(length));
        }
        if (offset < 0 || offset + length > data.length) {
            throw new IndexOutOfBoundsException(Errors.badRange(offset, offset + length));
        }
        if (length == 0) {
            return EMPTY;
        }
        return new Blob(data, offset, length);
    }

    @Override
    public Blob toFlatBlob() {
        return this;
    }

    @Override
    public Blob slice(long start, long end) {
        if (start < 0L) {
            return null;
        }
        if (end > (long)this.length) {
            return null;
        }
        long length = end - start;
        if (length < 0L) {
            return null;
        }
        if (length == 0L) {
            return EMPTY;
        }
        if (length == (long)this.length) {
            return this;
        }
        return Blob.wrap(this.store, Utils.checkedInt(start + (long)this.offset), Utils.checkedInt(length));
    }

    @Override
    public boolean equals(ABlob a) {
        if (a == null) {
            return false;
        }
        if (a instanceof Blob) {
            return this.equals((Blob)a);
        }
        long n = this.count();
        if (a.count() != n) {
            return false;
        }
        if (a.getType() != Types.BLOB) {
            return false;
        }
        if (n <= 4096L) {
            return a.equalsBytes(this.store, this.offset);
        }
        return this.getEncoding().equals(a.getEncoding());
    }

    public boolean equals(Blob b) {
        if (this == b) {
            return true;
        }
        if (this.length != b.length) {
            return false;
        }
        return Arrays.equals(this.store, this.offset, this.offset + this.length, b.store, b.offset, b.offset + this.length);
    }

    public boolean equals(AArrayBlob other) {
        if (other == this) {
            return true;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.contentHash != null && other.contentHash != null && this.contentHash.equals(other.contentHash)) {
            return true;
        }
        return Utils.arrayEquals(other.store, other.offset, this.store, this.offset, this.length);
    }

    public static Blob fromHex(String hexString) {
        byte[] bs = Utils.hexToBytes(hexString);
        if (bs == null) {
            return null;
        }
        return Blob.wrap(bs);
    }

    public static Blob fromByteBuffer(ByteBuffer bb) {
        int count = bb.remaining();
        byte[] bs = new byte[count];
        bb.get(bs);
        return Blob.wrap(bs);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        if (this.offset == 0) {
            return ByteBuffer.wrap(this.store, this.offset, this.length).asReadOnlyBuffer();
        }
        return ByteBuffer.wrap(this.getBytes()).asReadOnlyBuffer();
    }

    public static AArrayBlob read(Blob source, long len) throws BadFormatException {
        int headerLength = 1 + Format.getVLCLength(len);
        long rLen = source.count() - (long)headerLength;
        if (len != rLen) {
            throw new BadFormatException("Invalid length for Blob, length field " + len + " but actual length " + rLen);
        }
        return source.slice(headerLength, (long)headerLength + len);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        if (this.length > 4096) {
            return this.getCanonical().encode(bs, pos);
        }
        bs[pos++] = 49;
        pos = this.encodeRaw(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 11 + this.length;
    }

    @Override
    public boolean isCanonical() {
        return this.length <= 4096;
    }

    public static Blob createRandom(Random random, long length) {
        byte[] randBytes = new byte[Utils.checkedInt(length)];
        random.nextBytes(randBytes);
        return Blob.wrap(randBytes);
    }

    @Override
    public Blob getChunk(long i) {
        if (i == 0L && this.length <= 4096) {
            return this;
        }
        long start = i * 4096L;
        long take = Math.min(4096L, (long)this.length - start);
        return this.slice(start, start + take);
    }

    public void attachContentHash(Hash hash) {
        if (this.contentHash == null) {
            this.contentHash = hash;
        }
    }

    @Override
    public ABlob toCanonical() {
        if (this.isCanonical()) {
            return this;
        }
        return Blobs.toCanonical(this);
    }
}

