/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.AString;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.INumeric;
import convex.core.data.Strings;
import convex.core.data.prim.APrimitive;
import convex.core.data.prim.CVMDouble;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;

public final class CVMLong
extends APrimitive
implements INumeric {
    private static final int CACHE_SIZE = 256;
    private static final CVMLong[] CACHE = new CVMLong[256];
    public static final CVMLong ZERO;
    public static final CVMLong ONE;
    public static final CVMLong MINUS_ONE;
    public static final CVMLong MAX_VALUE;
    public static final CVMLong MIN_VALUE;
    public static final int MAX_ENCODING_LENGTH = 11;
    private final long value;

    public CVMLong(long value) {
        this.value = value;
    }

    public static CVMLong create(long value) {
        if (value < 256L && value >= 0L) {
            return CACHE[(int)value];
        }
        return new CVMLong(value);
    }

    @Override
    public AType getType() {
        return Types.LONG;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public CVMLong toLong() {
        return this;
    }

    @Override
    public CVMDouble toDouble() {
        return CVMDouble.create(this.doubleValue());
    }

    @Override
    public int estimatedEncodingSize() {
        return 11;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 9;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return Format.writeVLCLong(bs, pos, this.value);
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.toCVMString(20L));
        return bb.check(limit);
    }

    @Override
    public Class<?> numericType() {
        return Long.class;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static CVMLong parse(String s) {
        return CVMLong.create(Long.parseLong(s));
    }

    @Override
    public byte getTag() {
        return 9;
    }

    @Override
    public CVMLong signum() {
        if (this.value > 0L) {
            return ONE;
        }
        if (this.value < 0L) {
            return MINUS_ONE;
        }
        return ZERO;
    }

    @Override
    public INumeric toStandardNumber() {
        return this;
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < 1L) {
            return null;
        }
        return Strings.create(this.toString());
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            CVMLong.CACHE[i] = new CVMLong(i);
        }
        ZERO = CACHE[0];
        ONE = CACHE[1];
        MINUS_ONE = CVMLong.create(-1L);
        MAX_VALUE = CVMLong.create(Long.MAX_VALUE);
        MIN_VALUE = CVMLong.create(Long.MIN_VALUE);
    }
}

