/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Block;
import convex.core.BlockResult;
import convex.core.Constants;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.data.ABlob;
import convex.core.data.ABlobMap;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.ARecord;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.BlobMap;
import convex.core.data.BlobMaps;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.LongBlob;
import convex.core.data.MapEntry;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.BadSignatureException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.Symbols;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;
import convex.core.util.Counters;
import convex.core.util.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State
extends ARecord {
    private static final Keyword[] STATE_KEYS = new Keyword[]{Keywords.ACCOUNTS, Keywords.PEERS, Keywords.GLOBALS, Keywords.SCHEDULE};
    private static final RecordFormat FORMAT = RecordFormat.of(STATE_KEYS);
    static final AVector<Symbol> GLOBAL_SYMBOLS = Vectors.of(Symbols.TIMESTAMP, Symbols.FEES, Symbols.JUICE_PRICE);
    static final int GLOBAL_TIMESTAMP = 0;
    static final int GLOBAL_FEES = 1;
    static final int GLOBAL_JUICE_PRICE = 2;
    public static final State EMPTY = State.create(Vectors.empty(), (BlobMap)BlobMaps.empty(), Constants.INITIAL_GLOBALS, (BlobMap)BlobMaps.empty());
    private static final Logger log = LoggerFactory.getLogger((String)State.class.getName());
    private final AVector<AccountStatus> accounts;
    private final BlobMap<AccountKey, PeerStatus> peers;
    private final AVector<ACell> globals;
    private final BlobMap<ABlob, AVector<ACell>> schedule;

    private State(AVector<AccountStatus> accounts, BlobMap<AccountKey, PeerStatus> peers, AVector<ACell> globals, BlobMap<ABlob, AVector<ACell>> schedule) {
        super(FORMAT);
        this.accounts = accounts;
        this.peers = peers;
        this.globals = globals;
        this.schedule = schedule;
    }

    @Override
    public ACell get(ACell k) {
        if (Keywords.ACCOUNTS.equals(k)) {
            return this.accounts;
        }
        if (Keywords.PEERS.equals(k)) {
            return this.peers;
        }
        if (Keywords.GLOBALS.equals(k)) {
            return this.globals;
        }
        if (Keywords.SCHEDULE.equals(k)) {
            return this.schedule;
        }
        return null;
    }

    @Override
    public int getRefCount() {
        int rc = this.accounts.getRefCount();
        rc += this.peers.getRefCount();
        rc += this.globals.getRefCount();
        return rc += this.schedule.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException(i);
        }
        int c = this.accounts.getRefCount();
        if (i < c) {
            return this.accounts.getRef(i);
        }
        if ((i -= c) < (c = this.peers.getRefCount())) {
            return this.peers.getRef(i);
        }
        if ((i -= c) < (c = this.globals.getRefCount())) {
            return this.globals.getRef(i);
        }
        if ((i -= c) < (c = this.schedule.getRefCount())) {
            return this.schedule.getRef(i);
        }
        throw new IndexOutOfBoundsException(i -= c);
    }

    @Override
    protected State updateAll(ACell[] newVals) {
        AVector accounts = (AVector)newVals[0];
        BlobMap peers = (BlobMap)newVals[1];
        AVector globals = (AVector)newVals[2];
        BlobMap schedule = (BlobMap)newVals[3];
        if (this.accounts == accounts && this.peers == peers && this.globals == globals && this.schedule == schedule) {
            return this;
        }
        return new State(accounts, peers, globals, schedule);
    }

    public static State create(AVector<AccountStatus> accounts, BlobMap<AccountKey, PeerStatus> peers, AVector<ACell> globals, BlobMap<ABlob, AVector<ACell>> schedule) {
        return new State(accounts, peers, globals, schedule);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.accounts.encode(bs, pos);
        pos = this.peers.encode(bs, pos);
        pos = this.globals.encode(bs, pos);
        pos = this.schedule.encode(bs, pos);
        return pos;
    }

    @Override
    public long getEncodingLength() {
        long length = 1L;
        length += this.accounts.getEncodingLength();
        length += this.peers.getEncodingLength();
        length += this.globals.getEncodingLength();
        return length += this.schedule.getEncodingLength();
    }

    @Override
    public int estimatedEncodingSize() {
        int est = 1;
        est += this.accounts.estimatedEncodingSize();
        est += this.peers.estimatedEncodingSize();
        est += this.globals.estimatedEncodingSize();
        return est += this.schedule.estimatedEncodingSize();
    }

    public static State read(ByteBuffer bb) throws BadFormatException {
        try {
            AVector accounts = (AVector)Format.read(bb);
            BlobMap peers = (BlobMap)Format.read(bb);
            AVector globals = (AVector)Format.read(bb);
            BlobMap schedule = (BlobMap)Format.read(bb);
            return State.create(accounts, peers, globals, schedule);
        }
        catch (ClassCastException ex) {
            throw new BadFormatException("Can't read state", ex);
        }
    }

    public AVector<AccountStatus> getAccounts() {
        return this.accounts;
    }

    public BlobMap<AccountKey, PeerStatus> getPeers() {
        return this.peers;
    }

    public Long getBalance(Address address) {
        AccountStatus acc = this.getAccount(address);
        if (acc == null) {
            return null;
        }
        return acc.getBalance();
    }

    public State withBalance(Address address, long newBalance) {
        AccountStatus acc = this.getAccount(address);
        if (acc == null) {
            throw new Error("No account for " + address);
        }
        acc = acc.withBalance(newBalance);
        return this.putAccount(address, acc);
    }

    public BlockResult applyBlock(Block block) {
        ++Counters.applyBlock;
        State state = this.prepareBlock(block);
        return state.applyTransactions(block);
    }

    private State prepareBlock(Block b) {
        State state = this;
        AVector<ACell> glbs = state.globals;
        long ts = ((CVMLong)glbs.get(0)).longValue();
        long bts = b.getTimeStamp();
        if (bts > ts) {
            ASequence newGlbs = glbs.assoc(0L, (ACell)CVMLong.create(bts));
            state = state.withGlobals((AVector<ACell>)newGlbs);
        }
        state = state.applyScheduledTransactions(b);
        return state;
    }

    private State applyScheduledTransactions(Block b) {
        MapEntry<ABlob, AVector<ACell>> me;
        ABlob key;
        long time;
        long tcount = 0L;
        ABlobMap sched = this.schedule;
        CVMLong timestamp = this.getTimeStamp();
        ArrayList al = null;
        while (tcount < 100L && !sched.isEmpty() && (time = (key = (ABlob)(me = sched.entryAt(0L)).getKey()).longValue()) <= timestamp.longValue()) {
            AVector trans = (AVector)me.getValue();
            long numScheduled = trans.count();
            long take = Math.min(numScheduled, 100L - tcount);
            if (al == null) {
                al = new ArrayList();
            }
            for (long i = 0L; i < take; ++i) {
                al.add(trans.get(i));
            }
            if (!(trans = trans.subVector(take, numScheduled - take)).isEmpty()) continue;
            sched = sched.dissoc(key);
        }
        if (al == null) {
            return this;
        }
        State state = this.withSchedule((BlobMap<ABlob, AVector<ACell>>)sched);
        int n = al.size();
        log.debug("Applying {} scheduled transactions", (Object)n);
        for (int i = 0; i < n; ++i) {
            AVector st = (AVector)al.get(i);
            Address origin = (Address)st.get(0);
            AOp op = (AOp)st.get(1);
            try {
                Context<Object> ctx = Context.createInitial(state, origin, 1000000L);
                ctx = ctx.run(op);
                if (ctx.isExceptional()) {
                    log.trace("Scheduled transaction error: {}", (Object)ctx.getExceptional());
                    continue;
                }
                state = ctx.getState();
                log.trace("Scheduled transaction succeeded");
                continue;
            }
            catch (Exception e) {
                log.trace("Scheduled transaction failed: {}", (Throwable)e);
                e.printStackTrace();
            }
        }
        return state;
    }

    private State withSchedule(BlobMap<ABlob, AVector<ACell>> newSchedule) {
        if (this.schedule == newSchedule) {
            return this;
        }
        return new State(this.accounts, this.peers, this.globals, newSchedule);
    }

    private State withGlobals(AVector<ACell> newGlobals) {
        if (newGlobals == this.globals) {
            return this;
        }
        return new State(this.accounts, this.peers, newGlobals, this.schedule);
    }

    private BlockResult applyTransactions(Block block) {
        State state = this;
        int blockLength = block.length();
        Result[] results = new Result[blockLength];
        AVector<SignedData<ATransaction>> transactions = block.getTransactions();
        for (int i = 0; i < blockLength; ++i) {
            try {
                SignedData signed = (SignedData)transactions.get(i);
                Context ctx = state.applyTransaction(signed);
                results[i] = Result.fromContext(CVMLong.create(i), ctx);
                state = ctx.getState();
                continue;
            }
            catch (Throwable t) {
                String msg = "Unexpected fatal exception applying transaction: " + t.toString();
                results[i] = Result.create(CVMLong.create(i), Strings.create(msg), ErrorCodes.UNEXPECTED);
                t.printStackTrace();
                log.error(msg);
            }
        }
        return BlockResult.create(state, results);
    }

    private <T extends ACell> Context<T> applyTransaction(SignedData<? extends ATransaction> signedTransaction) throws BadSignatureException {
        ATransaction t = signedTransaction.getValue();
        Address addr = t.getOrigin();
        AccountStatus as = this.getAccount(addr);
        if (as == null) {
            return Context.createFake(this).withError(ErrorCodes.NOBODY, "Transaction for non-existent Account: " + addr);
        }
        AccountKey key = as.getAccountKey();
        if (key == null) {
            return Context.createFake(this).withError(ErrorCodes.NOBODY, "Transaction for account that is an Actor: " + addr);
        }
        if (!Utils.equals(key, signedTransaction.getAccountKey())) {
            return Context.createFake(this).withError(ErrorCodes.SIGNATURE, "Signature not valid for Account: " + addr + " expected public key: " + key);
        }
        Context<T> ctx = this.applyTransaction(t);
        return ctx;
    }

    public <T extends ACell> Context<T> applyTransaction(ATransaction t) {
        Address origin = t.getOrigin();
        try {
            Context<T> ctx = this.prepareTransaction(origin, t);
            if (ctx.isExceptional()) {
                return ctx;
            }
            long totalJuice = ctx.getJuice();
            State preparedState = ctx.getState();
            ctx = t.apply(ctx);
            ctx = ctx.completeTransaction(preparedState, totalJuice);
            return ctx;
        }
        catch (Throwable ex) {
            StringWriter s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            String message = s.toString();
            Context<Object> fCtx = Context.createInitial(this, origin, 0L);
            fCtx = fCtx.withError(ErrorCodes.FATAL, message);
            return fCtx;
        }
    }

    private <T extends ACell> Context<T> prepareTransaction(Address origin, ATransaction t) {
        AccountStatus account = this.getAccount(origin);
        if (account == null) {
            return Context.createFake(this).withError(ErrorCodes.NOBODY);
        }
        long sequence = t.getSequence();
        AccountStatus newAccount = account.updateSequence(sequence);
        if (newAccount == null) {
            return Context.createFake(this, origin).withError(ErrorCodes.SEQUENCE, "Received = " + sequence + " & Expected = " + (account.getSequence() + 1L));
        }
        State preparedState = this.putAccount(origin, newAccount);
        Long maxJuice = t.getMaxJuice();
        long juiceLimit = Math.min(1000000L, maxJuice == null ? account.getBalance() : maxJuice.longValue());
        Context ctx = Context.createInitial(preparedState, origin, juiceLimit);
        return ctx;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public HashMap<AccountKey, Double> computeStakes() {
        HashMap<AccountKey, Double> hm = new HashMap<AccountKey, Double>(this.peers.size());
        Double totalStake = this.peers.reduceEntries((? super R acc, MapEntry<K, V> e) -> {
            double stake = ((PeerStatus)e.getValue()).getTotalStake();
            hm.put(RT.ensureAccountKey((ACell)e.getKey()), stake);
            return stake + acc;
        }, 0.0);
        hm.put(null, totalStake);
        return hm;
    }

    public State withAccounts(AVector<AccountStatus> newAccounts) {
        if (newAccounts == this.accounts) {
            return this;
        }
        return State.create(newAccounts, this.peers, this.globals, this.schedule);
    }

    public State putAccount(Address address, AccountStatus accountStatus) {
        long n;
        long ix = address.longValue();
        if (ix > (n = this.accounts.count())) {
            throw new IndexOutOfBoundsException("Trying to add an account beyond accounts array at position: " + ix);
        }
        ASequence newAccounts = ix == n ? this.accounts.conj(accountStatus) : this.accounts.assoc(ix, (ACell)accountStatus);
        return this.withAccounts((AVector<AccountStatus>)newAccounts);
    }

    public AccountStatus getAccount(Address target) {
        long ix = target.longValue();
        if (ix < 0L || ix >= this.accounts.count()) {
            return null;
        }
        return this.accounts.get(ix);
    }

    public AMap<Symbol, ACell> getEnvironment(Address addr) {
        AccountStatus as = this.getAccount(addr);
        if (as == null) {
            return null;
        }
        return as.getEnvironment();
    }

    public State withPeers(BlobMap<AccountKey, PeerStatus> newPeers) {
        if (this.peers == newPeers) {
            return this;
        }
        return State.create(this.accounts, newPeers, this.globals, this.schedule);
    }

    @Override
    public byte getTag() {
        return -96;
    }

    public State tryAddActor() {
        AccountStatus as = AccountStatus.createActor();
        ASequence newAccounts = this.accounts.conj(as);
        return this.withAccounts((AVector<AccountStatus>)newAccounts);
    }

    public long computeTotalFunds() {
        long total = this.accounts.reduce((acc, as) -> acc + as.getBalance(), 0L);
        total += this.peers.reduceValues((? super R acc, ? super V ps) -> acc + ps.getTotalStake(), 0L).longValue();
        return total += this.getGlobalFees().longValue();
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.accounts.validateCell();
        this.peers.validateCell();
        this.globals.validateCell();
        this.schedule.validateCell();
    }

    public CVMLong getTimeStamp() {
        return (CVMLong)this.globals.get(0);
    }

    public CVMLong getJuicePrice() {
        return (CVMLong)this.globals.get(2);
    }

    public State scheduleOp(long time, Address address, AOp<?> op) {
        AVector v = Vectors.of(address, op);
        LongBlob key = LongBlob.create(time);
        AVector<ACell> list = this.schedule.get(key);
        list = list == null ? Vectors.of(v) : list.append(v);
        ABlobMap newSchedule = this.schedule.assoc(key, list);
        return this.withSchedule((BlobMap<ABlob, AVector<ACell>>)newSchedule);
    }

    public BlobMap<ABlob, AVector<ACell>> getSchedule() {
        return this.schedule;
    }

    public CVMLong getGlobalFees() {
        return (CVMLong)this.globals.get(1);
    }

    public State withGlobalFees(CVMLong newFees) {
        return this.withGlobals((AVector<ACell>)this.globals.assoc(1L, (ACell)newFees));
    }

    public PeerStatus getPeer(AccountKey peerAddress) {
        return this.getPeers().get(peerAddress);
    }

    public State withPeer(AccountKey peerKey, PeerStatus updatedPeer) {
        return this.withPeers((BlobMap<AccountKey, PeerStatus>)this.peers.assoc(peerKey, updatedPeer));
    }

    public Address nextAddress() {
        return Address.create(this.accounts.count());
    }

    public Address lookupCNS(String name) {
        Context ctx = Context.createFake(this);
        return (Address)ctx.lookupCNS(name).getResult();
    }

    public AVector<ACell> getGlobals() {
        return this.globals;
    }

    public State withTimestamp(long timestamp) {
        return this.withGlobals((AVector<ACell>)this.globals.assoc(0L, (ACell)CVMLong.create(timestamp)));
    }

    @Override
    public boolean equals(AMap<Keyword, ACell> a) {
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a.getTag() != this.getTag()) {
            return false;
        }
        State as = (State)a;
        return this.equals(as);
    }

    public boolean equals(State a) {
        Hash ha;
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Utils.equals(h, ha);
        }
        if (!Utils.equals(this.accounts, a.accounts)) {
            return false;
        }
        if (!Utils.equals(this.globals, a.globals)) {
            return false;
        }
        if (!Utils.equals(this.peers, a.peers)) {
            return false;
        }
        return Utils.equals(this.schedule, a.schedule);
    }
}

