/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Block;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import java.nio.ByteBuffer;

public class Order
extends ACell {
    private final AVector<Block> blocks;
    private final long proposalPoint;
    private final long consensusPoint;

    private Order(AVector<Block> blocks, long proposalPoint, long consensusPoint) {
        this.blocks = blocks;
        this.consensusPoint = consensusPoint;
        this.proposalPoint = proposalPoint;
    }

    private static Order create(AVector<Block> blocks, long proposalPoint, long consensusPoint) {
        return new Order(blocks, proposalPoint, consensusPoint);
    }

    public static Order create() {
        return Order.create(Vectors.empty(), 0L, 0L);
    }

    private byte getRecordTag() {
        return -84;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getRecordTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.blocks.encode(bs, pos);
        pos = Format.writeVLCLong(bs, pos, this.proposalPoint);
        pos = Format.writeVLCLong(bs, pos, this.consensusPoint);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.blocks.estimatedEncodingSize() + 30;
    }

    public static Order read(ByteBuffer bb) throws BadFormatException {
        AVector blocks = (AVector)Format.read(bb);
        if (blocks == null) {
            throw new BadFormatException("Null blocks in Order!");
        }
        long bcount = blocks.count();
        long pp = Format.readVLCLong(bb);
        long cp = Format.readVLCLong(bb);
        if (cp < 0L || cp > bcount) {
            throw new BadFormatException("Consensus point outside current block range: " + cp);
        }
        if (pp < cp) {
            throw new BadFormatException("Proposal point [" + pp + "] before consensus point [" + cp + "]");
        }
        if (pp > bcount) {
            throw new BadFormatException("Proposal point outside block range: " + pp);
        }
        return new Order(blocks, pp, cp);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    @Override
    public void print(StringBuilder sb) {
        sb.append("{");
        sb.append(":prop " + this.getProposalPoint() + ",");
        sb.append(":cons " + this.getConsensusPoint() + ",");
        sb.append(":hash " + this.getHash() + ",");
        sb.append(":blocks ");
        this.blocks.print(sb);
        sb.append("}\n");
    }

    public boolean checkConsistent(Order bc) {
        long commonPrefix = this.blocks.commonPrefixLength(bc.blocks);
        return commonPrefix >= this.consensusPoint;
    }

    public long getConsensusPoint() {
        return this.consensusPoint;
    }

    public long getProposalPoint() {
        return this.proposalPoint;
    }

    public AVector<Block> getBlocks() {
        return this.blocks;
    }

    public Block getBlock(long i) {
        return this.blocks.get(i);
    }

    public Order append(Block block) {
        AVector<Block> newBlocks = this.blocks.append(block);
        return Order.create(newBlocks, this.proposalPoint, this.consensusPoint);
    }

    public Order withBlocks(AVector<Block> newBlocks) {
        if (this.blocks == newBlocks) {
            return this;
        }
        return Order.create(newBlocks, this.proposalPoint, this.consensusPoint);
    }

    public Order withProposalPoint(long newProposalPoint) {
        if (this.proposalPoint == newProposalPoint) {
            return this;
        }
        if (newProposalPoint < this.consensusPoint) {
            throw new IllegalArgumentException("Trying to move proposed consensus before confirmed consensus?! " + newProposalPoint);
        }
        if (newProposalPoint > this.blocks.count()) {
            throw new IndexOutOfBoundsException("Block index: " + newProposalPoint);
        }
        return new Order(this.blocks, newProposalPoint, this.consensusPoint);
    }

    public Order withConsenusPoint(long newConsensusPoint) {
        if (this.consensusPoint == newConsensusPoint) {
            return this;
        }
        if (newConsensusPoint > this.blocks.count()) {
            throw new IndexOutOfBoundsException("Block index: " + newConsensusPoint);
        }
        long newProposalPoint = Math.max(this.proposalPoint, newConsensusPoint);
        return Order.create(this.blocks, newProposalPoint, newConsensusPoint);
    }

    public long getBlockCount() {
        return this.blocks.count();
    }

    public Order withoutConsenus() {
        return Order.create(this.blocks, 0L, 0L);
    }

    public Order updateBlocks(AVector<Block> newBlocks) {
        if (this.blocks == newBlocks) {
            return this;
        }
        long prefix = this.blocks.commonPrefixLength(newBlocks);
        long newProposalPoint = Math.min(prefix, this.proposalPoint);
        long newConsensusPoint = Math.min(this.consensusPoint, newProposalPoint);
        return Order.create(newBlocks, newProposalPoint, newConsensusPoint);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        this.blocks.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int getRefCount() {
        return this.blocks.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.blocks.getRef(i);
    }

    @Override
    public Order updateRefs(IRefFunction func) {
        ACell newBlocks = this.blocks.updateRefs(func);
        return this.withBlocks((AVector<Block>)newBlocks);
    }

    @Override
    public byte getTag() {
        return -84;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }
}

