/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.util.Utils;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shutdown {
    public static final int CLIENTHTTP = 60;
    public static final int SERVER = 80;
    public static final int ETCH = 100;
    public static final int EXECUTOR = 110;
    public static final int CLI = 120;
    private static final Logger log = LoggerFactory.getLogger((String)Shutdown.class.getName());
    private static final TreeMap<Integer, Group> order;

    public static synchronized void addHook(int priority, Runnable shutdownTask) {
        Group g = order.get(priority);
        if (g == null) {
            g = new Group();
            order.put(priority, g);
        }
        g.addHook(shutdownTask);
    }

    private static synchronized void runHooks() {
        for (Map.Entry<Integer, Group> me : order.entrySet()) {
            log.debug("Running shutdown hooks at level: " + String.valueOf(me.getKey()));
            me.getValue().runHooks();
        }
        order.clear();
        log.debug("Convex shutdown hooks complete");
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    log.debug("Running Convex shutdown hooks");
                    Shutdown.runHooks();
                }
            }, "Convex Shutdown"));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        order = new TreeMap();
    }

    private static class Group {
        private final IdentityHashMap<Runnable, Runnable> hookSet = new IdentityHashMap();

        private Group() {
        }

        public synchronized void addHook(Runnable r) {
            this.hookSet.put(r, r);
        }

        public synchronized void runHooks() {
            Set<Runnable> hooks = this.hookSet.keySet();
            hooks.stream().forEach(r -> {
                log.trace("Running shutdown hook: " + Utils.getClassName(r));
                try {
                    r.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
            this.hookSet.clear();
        }
    }
}

