/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.util.Utils;

public class Economics {
    public static double swapRate(long a, long b) {
        if (a <= 0L || b <= 0L) {
            throw new IllegalArgumentException("Pool quantities must be positive");
        }
        return (double)b / (double)a;
    }

    public static long swapPrice(long delta, long a, long b) {
        if (a <= 0L || b <= 0L) {
            throw new IllegalArgumentException("Pool quantities must be positive");
        }
        if (delta >= a) {
            throw new IllegalArgumentException("Trying to buy entire pool!");
        }
        long newB = Utils.mulDiv(a, b, a - delta);
        long result = newB - b + 1L;
        return result;
    }

    public static double stakeDecay(long time, long peerTime) {
        if (peerTime >= time) {
            return 1.0;
        }
        double delay = time - peerTime;
        if ((delay -= 180000.0) < 0.0) {
            return 1.0;
        }
        return Math.max(0.001, Math.exp(-delay / 300000.0));
    }
}

