/*
 * Decompiled with CFR 0.152.
 */
package convex.core.text;

import convex.core.Coin;
import convex.core.data.prim.CVMDouble;
import convex.core.data.util.BlobBuilder;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;

public class Text {
    private static final int WHITESPACE_LENGTH = 32;
    private static final String ZEROS_9 = "000000000";
    private static String WHITESPACE_32 = "                                ";
    static DecimalFormat balanceFormatter = new DecimalFormat("#,###");
    static DecimalFormat percentFormatter = new DecimalFormat("##.###%");
    static DecimalFormat decimalFormatter = new DecimalFormat("#,##0.####");
    static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();

    public static boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static String whiteSpace(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative whitespace requested!");
        }
        if (length == 0) {
            return "";
        }
        if (length <= 32) {
            return WHITESPACE_32.substring(0, length);
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 32; i <= length; i += 32) {
            sb.append(WHITESPACE_32);
        }
        sb.append(Text.whiteSpace(length & 0x1F));
        return sb.toString();
    }

    public static String leftPad(String s, int length) {
        int spaces;
        if (s == null) {
            s = "";
        }
        if ((spaces = length - s.length()) < 0) {
            throw new IllegalArgumentException("String [" + s + "] too long for pad length: " + length);
        }
        return Text.whiteSpace(spaces) + s;
    }

    public static String leftPad(long value, int length) {
        return Text.leftPad(Long.toString(value), length);
    }

    public static String rightPad(String s, int length) {
        int spaces;
        if (s == null) {
            s = "";
        }
        if ((spaces = length - s.length()) < 0) {
            throw new IllegalArgumentException("String [" + s + "] too long for pad length: " + length);
        }
        return s + Text.whiteSpace(spaces);
    }

    public static String rightPad(long value, int length) {
        return Text.rightPad(Long.toString(value), length);
    }

    public static String toFriendlyNumber(long value) {
        return balanceFormatter.format(value);
    }

    public static String toPercentString(double value) {
        return percentFormatter.format(value);
    }

    public static String toFriendlyDecimal(double value) {
        if (!Double.isFinite(value)) {
            return CVMDouble.create(value).toString();
        }
        return decimalFormatter.format(value);
    }

    public static String toFriendlyIntString(double value) {
        return Text.toFriendlyNumber((long)value);
    }

    public static String toFriendlyBalance(long balance) {
        if (!Coin.isValidAmount(balance)) {
            throw new IllegalArgumentException("Invalid balance)");
        }
        long gold = balance / 1000000000L;
        long copper = balance % 1000000000L;
        Object copperString = Long.toString(copper);
        int cn = ((String)copperString).length();
        if (cn < 9) {
            copperString = ZEROS_9.substring(cn, 9) + (String)copperString;
        }
        return Text.toFriendlyNumber(gold) + "." + (String)copperString;
    }

    public static String dateFormat(long timestamp) {
        return formatter.format(Instant.ofEpochMilli(timestamp));
    }

    public static void writeEscapedByte(BlobBuilder sb, byte b) {
        char c = (char)b;
        switch (c) {
            case '\"': {
                sb.append('\\');
                sb.append('\"');
                return;
            }
            case '\\': {
                sb.append('\\');
                sb.append('\\');
                return;
            }
            case '\t': {
                sb.append('\\');
                sb.append('t');
                return;
            }
            case '\b': {
                sb.append('\\');
                sb.append('b');
                return;
            }
            case '\n': {
                sb.append('\\');
                sb.append('n');
                return;
            }
            case '\r': {
                sb.append('\\');
                sb.append('r');
                return;
            }
            case '\f': {
                sb.append('\\');
                sb.append('f');
                return;
            }
        }
        sb.append(b);
    }

    public static int lineCount(String text) {
        if (text == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    public static int columnCount(String text) {
        if (text == null) {
            return 0;
        }
        int result = 0;
        int n = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                n = 0;
                continue;
            }
            if (++n <= result) continue;
            result = n;
        }
        return result;
    }

    public static String zeroPad(BigInteger b, int digits) {
        if (digits > 9) {
            throw new IllegalArgumentException("Too many digits!!");
        }
        if (b.signum() < 0) {
            throw new IllegalArgumentException("Negative number!");
        }
        Object s = b.toString();
        int n = ((String)s).length();
        if (n < digits) {
            s = ZEROS_9.substring(0, digits - n) + (String)s;
        }
        return s;
    }

    public static String repeat(char c, int count) {
        char[] cs = new char[count];
        Arrays.fill(cs, c);
        return new String(cs);
    }
}

