/*
 * Decompiled with CFR 0.152.
 */
package convex.core.text;

import convex.core.data.Address;
import convex.core.text.AFormat;
import convex.core.text.Text;
import java.text.FieldPosition;
import java.text.ParsePosition;

public class AddressFormat
extends AFormat {
    public static final AddressFormat INSTANCE = new AddressFormat();

    @Override
    public StringBuffer format(Object obj, StringBuffer sb, FieldPosition pos) {
        if (obj instanceof Address) {
            Address a = (Address)obj;
            sb.append(a.toString());
        }
        return sb;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int i;
        int n;
        int ix = pos.getIndex();
        if (ix >= (n = source.length())) {
            pos.setErrorIndex(ix);
            return null;
        }
        while (Character.isWhitespace(source.charAt(ix))) {
            if (++ix < n) continue;
            pos.setErrorIndex(ix);
            return null;
        }
        if (source.charAt(ix) == '#') {
            ++ix;
        }
        if (ix >= n) {
            pos.setErrorIndex(ix);
            return null;
        }
        long v = 0L;
        for (i = ix; i < n; ++i) {
            char d = source.charAt(i);
            if (Text.isASCIIDigit(d)) {
                if (v > 0xCCCCCCCCCCCCCCCL) {
                    pos.setErrorIndex(i);
                    return null;
                }
            } else {
                if (i != ix) break;
                pos.setErrorIndex(i);
                return null;
            }
            v = v * 10L + (long)(d - 48);
        }
        pos.setIndex(i);
        return Address.create(v);
    }
}

